/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.inject.spigot;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import org.geysermc.floodgate.api.logger.FloodgateLogger;
import org.geysermc.floodgate.inject.CommonPlatformInjector;
import org.geysermc.floodgate.inject.spigot.CustomList;
import org.geysermc.floodgate.shadow.com.google.inject.Inject;
import org.geysermc.floodgate.shadow.com.google.inject.Singleton;
import org.geysermc.floodgate.util.ClassNames;
import org.geysermc.floodgate.util.ReflectionUtils;

@Singleton
public final class SpigotInjector
extends CommonPlatformInjector {
    @Inject
    private FloodgateLogger logger;
    private Object serverConnection;
    private String injectedFieldName;
    private boolean injected;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void inject() throws Exception {
        if (this.isInjected()) {
            return;
        }
        Object serverConnection = this.getServerConnection();
        if (serverConnection == null) {
            throw new RuntimeException("Unable to find server connection");
        }
        for (Field field : serverConnection.getClass().getDeclaredFields()) {
            CustomList newList;
            if (field.getType() != List.class) continue;
            field.setAccessible(true);
            ParameterizedType parameterType = (ParameterizedType)field.getGenericType();
            Type listType = parameterType.getActualTypeArguments()[0];
            if (listType != ChannelFuture.class) continue;
            this.injectedFieldName = field.getName();
            CustomList customList = newList = new CustomList((List)field.get(serverConnection)){

                @Override
                public void onAdd(Object object) {
                    try {
                        SpigotInjector.this.injectClient((ChannelFuture)object);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            };
            synchronized (customList) {
                for (Object object : newList) {
                    try {
                        this.injectClient((ChannelFuture)object);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
            field.set(serverConnection, newList);
            this.injected = true;
            return;
        }
    }

    public void injectClient(ChannelFuture future) {
        future.channel().pipeline().addFirst("floodgate-init", (ChannelHandler)new ChannelInboundHandlerAdapter(){

            public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                super.channelRead(ctx, msg);
                Channel channel = (Channel)msg;
                channel.pipeline().addLast(new ChannelHandler[]{new ChannelInitializer<Channel>(){

                    protected void initChannel(Channel channel) {
                        SpigotInjector.this.injectAddonsCall(channel, false);
                        SpigotInjector.this.addInjectedClient(channel);
                    }
                }});
            }
        });
    }

    @Override
    public void removeInjection() {
        if (!this.isInjected()) {
            return;
        }
        Object serverConnection = this.getServerConnection();
        if (serverConnection != null) {
            Field field = ReflectionUtils.getField(serverConnection.getClass(), this.injectedFieldName);
            Object value = ReflectionUtils.getValue(serverConnection, field);
            if (value instanceof CustomList) {
                CustomList customList = (CustomList)value;
                ReflectionUtils.setValue(serverConnection, field, (Object)customList.getOriginalList());
                return;
            }
            this.logger.debug("Unable to remove all references of Floodgate due to {}! ", value.getClass().getName());
        }
        for (Channel channel : this.injectedClients()) {
            this.removeAddonsCall(channel);
        }
        this.injected = false;
    }

    private Object getServerConnection() {
        if (this.serverConnection != null) {
            return this.serverConnection;
        }
        Class<?> minecraftServer = ClassNames.MINECRAFT_SERVER;
        Object minecraftServerInstance = ReflectionUtils.invokeStatic(minecraftServer, "getServer");
        Method method = ReflectionUtils.getMethodThatReturns(minecraftServer, ClassNames.SERVER_CONNECTION, true, new Class[0]);
        this.serverConnection = ReflectionUtils.invoke(minecraftServerInstance, method, new Object[0]);
        return this.serverConnection;
    }

    @Override
    public boolean isInjected() {
        return this.injected;
    }
}

