/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.module;

import java.util.logging.Logger;
import org.bukkit.event.Listener;
import org.bukkit.plugin.java.JavaPlugin;
import org.geysermc.floodgate.SpigotPlugin;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.floodgate.api.logger.FloodgateLogger;
import org.geysermc.floodgate.inject.CommonPlatformInjector;
import org.geysermc.floodgate.inject.spigot.SpigotInjector;
import org.geysermc.floodgate.listener.SpigotListenerRegistration;
import org.geysermc.floodgate.logger.JavaUtilFloodgateLogger;
import org.geysermc.floodgate.platform.command.CommandUtil;
import org.geysermc.floodgate.platform.listener.ListenerRegistration;
import org.geysermc.floodgate.platform.pluginmessage.PluginMessageUtils;
import org.geysermc.floodgate.platform.util.PlatformUtils;
import org.geysermc.floodgate.pluginmessage.PluginMessageRegistration;
import org.geysermc.floodgate.pluginmessage.SpigotPluginMessageRegistration;
import org.geysermc.floodgate.pluginmessage.SpigotPluginMessageUtils;
import org.geysermc.floodgate.pluginmessage.SpigotSkinApplier;
import org.geysermc.floodgate.shadow.com.google.inject.AbstractModule;
import org.geysermc.floodgate.shadow.com.google.inject.Provides;
import org.geysermc.floodgate.shadow.com.google.inject.Singleton;
import org.geysermc.floodgate.shadow.com.google.inject.name.Named;
import org.geysermc.floodgate.shadow.com.google.inject.name.Names;
import org.geysermc.floodgate.skin.SkinApplier;
import org.geysermc.floodgate.util.LanguageManager;
import org.geysermc.floodgate.util.SpigotCommandUtil;
import org.geysermc.floodgate.util.SpigotPlatformUtils;
import org.geysermc.floodgate.util.SpigotVersionSpecificMethods;

public final class SpigotPlatformModule
extends AbstractModule {
    private final SpigotPlugin plugin;

    @Override
    protected void configure() {
        this.bind(SpigotPlugin.class).toInstance(this.plugin);
        this.bind(PlatformUtils.class).to(SpigotPlatformUtils.class);
        this.bind(CommonPlatformInjector.class).to(SpigotInjector.class);
        this.bind(Logger.class).annotatedWith(Names.named("logger")).toInstance(this.plugin.getLogger());
        this.bind(FloodgateLogger.class).to(JavaUtilFloodgateLogger.class);
        this.bind(SkinApplier.class).to(SpigotSkinApplier.class);
    }

    @Provides
    @Singleton
    public JavaPlugin javaPlugin() {
        return this.plugin;
    }

    @Provides
    @Singleton
    public CommandUtil commandUtil(FloodgateApi api, SpigotVersionSpecificMethods versionSpecificMethods, LanguageManager languageManager) {
        return new SpigotCommandUtil(languageManager, this.plugin.getServer(), api, versionSpecificMethods);
    }

    @Provides
    @Singleton
    public ListenerRegistration<Listener> listenerRegistration() {
        return new SpigotListenerRegistration(this.plugin);
    }

    @Provides
    @Named(value="packetEncoder")
    public String packetEncoder() {
        return "encoder";
    }

    @Provides
    @Named(value="packetDecoder")
    public String packetDecoder() {
        return "decoder";
    }

    @Provides
    @Named(value="packetHandler")
    public String packetHandler() {
        return "packet_handler";
    }

    @Provides
    @Named(value="implementationName")
    public String implementationName() {
        return "Spigot";
    }

    @Provides
    @Singleton
    public PluginMessageUtils pluginMessageUtils() {
        return new SpigotPluginMessageUtils(this.plugin);
    }

    @Provides
    @Singleton
    public PluginMessageRegistration pluginMessageRegister() {
        return new SpigotPluginMessageRegistration(this.plugin);
    }

    @Provides
    @Singleton
    public SpigotVersionSpecificMethods versionSpecificMethods() {
        return new SpigotVersionSpecificMethods(this.plugin);
    }

    public SpigotPlatformModule(SpigotPlugin plugin) {
        this.plugin = plugin;
    }
}

