/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.configutils.parser.placeholder;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public final class Placeholders {
    private final Map<String, Object> placeholders = new HashMap<String, Object>();

    public boolean addPlaceholder(String name, Supplier<Object> supplier) {
        return this.placeholders.put(name, supplier) != null;
    }

    public boolean addPlaceholder(String name, Object value) {
        return this.placeholders.put(name, value) != null;
    }

    public String replacePlaceholders(String line) {
        int placeholderIndex = line.indexOf("${");
        if (placeholderIndex == -1) {
            return line;
        }
        String name = line.substring(placeholderIndex + 2);
        int placeholderCloseIndex = name.indexOf(125);
        if (placeholderCloseIndex == -1) {
            return line;
        }
        Object placeholder = this.placeholder(name = name.substring(0, placeholderCloseIndex));
        if (placeholder == null) {
            return line;
        }
        if (placeholder instanceof Supplier) {
            Object response = ((Supplier)placeholder).get();
            return line.replace("${" + name + "}", response.toString());
        }
        return placeholder.toString();
    }

    public Object placeholder(String name) {
        return this.placeholders.get(name);
    }

    public boolean isPlaceholder(String name) {
        return this.placeholder(name) != null;
    }

    public boolean removePlaceholder(String name) {
        return this.placeholders.remove(name) != null;
    }
}

