/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.util;

import org.checkerframework.checker.nullness.qual.Nullable;

public enum WebsocketEventType {
    SUBSCRIBER_CREATED(0),
    SUBSCRIBER_COUNT(1),
    CREATOR_DISCONNECTED(4),
    ADDED_TO_QUEUE(2),
    SKIN_UPLOADED(3),
    NEWS_ADDED(6),
    LOG_MESSAGE(5);

    private static final WebsocketEventType[] VALUES;
    private final int id;

    private WebsocketEventType(int id) {
        this.id = id;
    }

    public static @Nullable WebsocketEventType fromId(int id) {
        return VALUES.length > id ? VALUES[id] : null;
    }

    public int id() {
        return this.id;
    }

    static {
        WebsocketEventType[] values = WebsocketEventType.values();
        VALUES = new WebsocketEventType[values.length];
        WebsocketEventType[] websocketEventTypeArray = values;
        int n = websocketEventTypeArray.length;
        for (int i = 0; i < n; ++i) {
            WebsocketEventType value;
            WebsocketEventType.VALUES[value.id] = value = websocketEventTypeArray[i];
        }
    }
}

