/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.paper;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import me.lucko.spark.paper.common.platform.serverconfig.ConfigParser;
import me.lucko.spark.paper.common.platform.serverconfig.ExcludedConfigFilter;
import me.lucko.spark.paper.common.platform.serverconfig.PropertiesConfigParser;
import me.lucko.spark.paper.common.platform.serverconfig.ServerConfigProvider;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.configuration.MemorySection;
import org.bukkit.configuration.file.YamlConfiguration;

public class PaperServerConfigProvider
extends ServerConfigProvider {
    private static final Map<String, ConfigParser> FILES;
    private static final Collection<String> HIDDEN_PATHS;

    public PaperServerConfigProvider() {
        super(FILES, HIDDEN_PATHS);
    }

    static {
        ImmutableMap.Builder files = ImmutableMap.builder().put((Object)"server.properties", (Object)PropertiesConfigParser.INSTANCE).put((Object)"bukkit.yml", (Object)YamlConfigParser.INSTANCE).put((Object)"spigot.yml", (Object)YamlConfigParser.INSTANCE).put((Object)"paper.yml", (Object)YamlConfigParser.INSTANCE).put((Object)"paper/", (Object)SplitYamlConfigParser.INSTANCE).put((Object)"purpur.yml", (Object)YamlConfigParser.INSTANCE).put((Object)"pufferfish.yml", (Object)YamlConfigParser.INSTANCE);
        for (String config : PaperServerConfigProvider.getSystemPropertyList("spark.serverconfigs.extra")) {
            files.put((Object)config, (Object)YamlConfigParser.INSTANCE);
        }
        ImmutableSet.Builder hiddenPaths = ImmutableSet.builder().addAll((Iterable)BASE_HIDDEN_PATHS).add((Object)"database").add((Object)"settings.bungeecord-addresses").add((Object)"settings.velocity-support.secret").add((Object)"proxies.velocity.secret").add((Object)"world-settings.*.feature-seeds").add((Object)"world-settings.*.seed-*").add((Object)"feature-seeds").add((Object)"seed-*").addAll(PaperServerConfigProvider.getSystemPropertyList("spark.serverconfigs.hiddenpaths"));
        FILES = files.build();
        HIDDEN_PATHS = hiddenPaths.build();
    }

    private static class YamlConfigParser
    implements ConfigParser {
        public static final YamlConfigParser INSTANCE = new YamlConfigParser();
        protected static final Gson GSON = new GsonBuilder().registerTypeAdapter(MemorySection.class, (obj, type, ctx) -> ctx.serialize((Object)obj.getValues(false))).create();

        private YamlConfigParser() {
        }

        @Override
        public JsonElement load(String file, ExcludedConfigFilter filter) throws IOException {
            Map<String, Object> values = this.parse(Paths.get(file, new String[0]));
            if (values == null) {
                return null;
            }
            return filter.apply(GSON.toJsonTree(values));
        }

        @Override
        public Map<String, Object> parse(BufferedReader reader) throws IOException {
            YamlConfiguration config = YamlConfiguration.loadConfiguration((Reader)reader);
            return config.getValues(false);
        }
    }

    private static class SplitYamlConfigParser
    extends YamlConfigParser {
        public static final SplitYamlConfigParser INSTANCE = new SplitYamlConfigParser();

        private SplitYamlConfigParser() {
        }

        @Override
        public JsonElement load(String group, ExcludedConfigFilter filter) throws IOException {
            String prefix = group.replace("/", "");
            Path configDir = Paths.get("config", new String[0]);
            if (!Files.exists(configDir, new LinkOption[0])) {
                return null;
            }
            JsonObject root = new JsonObject();
            for (Map.Entry<String, Path> entry : SplitYamlConfigParser.getNestedFiles(configDir, prefix).entrySet()) {
                String fileName = entry.getKey();
                Path path = entry.getValue();
                Map<String, Object> values = this.parse(path);
                if (values == null) continue;
                root.add(fileName, filter.apply(GSON.toJsonTree(values)));
            }
            return root;
        }

        private static Map<String, Path> getNestedFiles(Path configDir, String prefix) {
            LinkedHashMap<String, Path> files = new LinkedHashMap<String, Path>();
            files.put("global.yml", configDir.resolve(prefix + "-global.yml"));
            files.put("world-defaults.yml", configDir.resolve(prefix + "-world-defaults.yml"));
            for (World world : Bukkit.getWorlds()) {
                files.put(world.getName() + ".yml", world.getWorldFolder().toPath().resolve(prefix + "-world.yml"));
            }
            return files;
        }
    }
}

