/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.paper.common.platform.serverconfig;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import me.lucko.spark.paper.common.platform.serverconfig.ConfigParser;
import me.lucko.spark.paper.common.platform.serverconfig.ExcludedConfigFilter;

public enum PropertiesConfigParser implements ConfigParser
{
    INSTANCE;

    private static final Gson GSON;

    @Override
    public JsonElement load(String file, ExcludedConfigFilter filter) throws IOException {
        Map<String, Object> values = this.parse(Paths.get(file, new String[0]));
        if (values == null) {
            return null;
        }
        return filter.apply(GSON.toJsonTree(values));
    }

    @Override
    public Map<String, Object> parse(BufferedReader reader) throws IOException {
        Properties properties = new Properties();
        properties.load(reader);
        HashMap<String, Object> values = new HashMap<String, Object>();
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            String key = k.toString();
            String value = v.toString();
            if ("true".equals(value) || "false".equals(value)) {
                values.put(key, Boolean.parseBoolean(value));
            } else if (value.matches("\\d+")) {
                try {
                    values.put(key, Long.parseLong(value));
                }
                catch (NumberFormatException e) {
                    values.put(key, value);
                }
            } else {
                values.put(key, value);
            }
        }));
        return values;
    }

    static {
        GSON = new Gson();
    }
}

