/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.paper.common.sampler.node.exporter;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import me.lucko.spark.paper.common.sampler.node.StackTraceNode;
import me.lucko.spark.paper.common.sampler.node.ThreadNode;
import me.lucko.spark.paper.common.sampler.node.exporter.NodeExporter;
import me.lucko.spark.paper.common.sampler.window.ProtoTimeEncoder;
import me.lucko.spark.paper.common.util.IndexedListBuilder;
import me.lucko.spark.paper.proto.SparkSamplerProtos;

public abstract class AbstractNodeExporter
implements NodeExporter {
    protected final ProtoTimeEncoder timeEncoder;

    protected AbstractNodeExporter(ProtoTimeEncoder timeEncoder) {
        this.timeEncoder = timeEncoder;
    }

    @Override
    public SparkSamplerProtos.ThreadNode export(ThreadNode threadNode) {
        double[] times;
        SparkSamplerProtos.ThreadNode.Builder proto = SparkSamplerProtos.ThreadNode.newBuilder().setName(threadNode.getThreadLabel());
        for (double time : times = threadNode.encodeTimesForProto(this.timeEncoder)) {
            proto.addTimes(time);
        }
        IndexedListBuilder<SparkSamplerProtos.StackTraceNode> nodesArray = new IndexedListBuilder<SparkSamplerProtos.StackTraceNode>();
        ArrayDeque<Node> stack = new ArrayDeque<Node>();
        LinkedList childrenRefs = new LinkedList();
        for (StackTraceNode stackTraceNode : this.exportChildren(threadNode.getChildren())) {
            stack.push(new Node(stackTraceNode, childrenRefs));
        }
        while (!stack.isEmpty()) {
            Node node = (Node)stack.peek();
            if (node.firstVisit) {
                for (StackTraceNode child : this.exportChildren(node.stackTraceNode.getChildren())) {
                    stack.push(new Node(child, node.childrenRefs));
                }
                node.firstVisit = false;
                continue;
            }
            SparkSamplerProtos.StackTraceNode stackTraceNode = this.export(node.stackTraceNode, node.childrenRefs);
            int childIndex = nodesArray.add(stackTraceNode);
            node.parentChildrenRefs.add(childIndex);
            stack.pop();
        }
        proto.addAllChildrenRefs(childrenRefs);
        proto.addAllChildren(nodesArray.build());
        return (SparkSamplerProtos.ThreadNode)proto.build();
    }

    protected abstract SparkSamplerProtos.StackTraceNode export(StackTraceNode var1, Iterable<Integer> var2);

    protected abstract Collection<StackTraceNode> exportChildren(Collection<StackTraceNode> var1);

    private static final class Node {
        private final StackTraceNode stackTraceNode;
        private boolean firstVisit = true;
        private final List<Integer> childrenRefs = new LinkedList<Integer>();
        private final List<Integer> parentChildrenRefs;

        private Node(StackTraceNode node, List<Integer> parentChildrenRefs) {
            this.stackTraceNode = node;
            this.parentChildrenRefs = parentChildrenRefs;
        }
    }
}

