/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.paper.common.ws;

import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import me.lucko.spark.paper.lib.protobuf.ByteString;

public enum CryptoAlgorithm {
    Ed25519("Ed25519", 255, "Ed25519"),
    RSA2048("RSA", 2048, "SHA256withRSA");

    private final String keyAlgorithm;
    private final int keySize;
    private final String signatureAlgorithm;

    private CryptoAlgorithm(String keyAlgorithm, int keySize, String signatureAlgorithm) {
        this.keyAlgorithm = keyAlgorithm;
        this.keySize = keySize;
        this.signatureAlgorithm = signatureAlgorithm;
    }

    public KeyPairGenerator createKeyPairGenerator() throws NoSuchAlgorithmException {
        return KeyPairGenerator.getInstance(this.keyAlgorithm);
    }

    public KeyFactory createKeyFactory() throws NoSuchAlgorithmException {
        return KeyFactory.getInstance(this.keyAlgorithm);
    }

    public Signature createSignature() throws NoSuchAlgorithmException {
        return Signature.getInstance(this.signatureAlgorithm);
    }

    public KeyPair generateKeyPair() {
        try {
            KeyPairGenerator generator = this.createKeyPairGenerator();
            generator.initialize(this.keySize);
            return generator.generateKeyPair();
        }
        catch (Exception e) {
            throw new RuntimeException("Exception generating keypair", e);
        }
    }

    public PublicKey decodePublicKey(byte[] bytes) throws IllegalArgumentException {
        try {
            X509EncodedKeySpec spec = new X509EncodedKeySpec(bytes);
            KeyFactory factory = this.createKeyFactory();
            return factory.generatePublic(spec);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Exception parsing public key", e);
        }
    }

    public PublicKey decodePublicKey(ByteString bytes) throws IllegalArgumentException {
        if (bytes == null) {
            return null;
        }
        return this.decodePublicKey(bytes.toByteArray());
    }
}

