/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.paper.common.ws;

import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import me.lucko.spark.paper.common.util.config.Configuration;
import me.lucko.spark.paper.common.ws.ViewerSocketConnection;

public class TrustedKeyStore {
    private static final String TRUSTED_KEYS_OPTION = "trustedKeys";
    private final Configuration configuration;
    private final CompletableFuture<KeyPair> localKeyPair;
    private final Set<PublicKey> remoteTrustedKeys;
    private final Map<String, PublicKey> remotePendingKeys = new HashMap<String, PublicKey>();

    public TrustedKeyStore(Configuration configuration) {
        this.configuration = configuration;
        this.localKeyPair = CompletableFuture.supplyAsync(ViewerSocketConnection.CRYPTO::generateKeyPair);
        this.remoteTrustedKeys = new HashSet<PublicKey>();
        this.readTrustedKeys();
    }

    public PublicKey getLocalPublicKey() {
        return this.localKeyPair.join().getPublic();
    }

    public PrivateKey getLocalPrivateKey() {
        return this.localKeyPair.join().getPrivate();
    }

    public boolean isKeyTrusted(PublicKey publicKey) {
        return publicKey != null && this.remoteTrustedKeys.contains(publicKey);
    }

    public void addPendingKey(String clientId, PublicKey publicKey) {
        this.remotePendingKeys.put(clientId, publicKey);
    }

    public boolean trustPendingKey(String clientId) {
        PublicKey key = this.remotePendingKeys.remove(clientId);
        if (key == null) {
            return false;
        }
        this.remoteTrustedKeys.add(key);
        this.writeTrustedKeys();
        return true;
    }

    private void readTrustedKeys() {
        for (String encodedKey : this.configuration.getStringList(TRUSTED_KEYS_OPTION)) {
            try {
                PublicKey publicKey = ViewerSocketConnection.CRYPTO.decodePublicKey(Base64.getDecoder().decode(encodedKey));
                this.remoteTrustedKeys.add(publicKey);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void writeTrustedKeys() {
        List<String> encodedKeys = this.remoteTrustedKeys.stream().map(key -> Base64.getEncoder().encodeToString(key.getEncoded())).collect(Collectors.toList());
        this.configuration.setStringList(TRUSTED_KEYS_OPTION, encodedKeys);
    }
}

