/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.converters.particle;

import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.TypeUtil;
import ca.spottedleaf.dataconverter.types.nbt.NBTMapType;
import ca.spottedleaf.dataconverter.util.NamespaceUtil;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import org.slf4j.Logger;

public final class ConverterParticleToNBT {
    private static final Logger LOGGER = LogUtils.getLogger();

    private static NBTTagCompound parseNBT(String flat) {
        try {
            return MojangsonParser.a(flat);
        }
        catch (Exception ex) {
            LOGGER.warn("Failed to parse nbt: " + flat, (Throwable)ex);
            return null;
        }
    }

    private static void convertItem(MapType nbt, String data) {
        MapType itemNBT = nbt.getTypeUtil().createEmptyMap();
        nbt.setMap("item", itemNBT);
        itemNBT.setInt("Count", 1);
        int nbtStart = data.indexOf(123);
        if (nbtStart == -1) {
            itemNBT.setString("id", NamespaceUtil.correctNamespace(data));
            return;
        }
        itemNBT.setString("id", NamespaceUtil.correctNamespace(data.substring(0, nbtStart)));
        NBTTagCompound tag = ConverterParticleToNBT.parseNBT(data.substring(nbtStart));
        if (tag != null) {
            itemNBT.setMap("tag", new NBTMapType(tag));
        }
    }

    private static MapType parseProperties(String input, TypeUtil<?> type) {
        MapType ret = type.createEmptyMap();
        try {
            StringReader reader = new StringReader(input);
            reader.expect('[');
            reader.skipWhitespace();
            if (reader.canRead() && reader.peek() != ']') {
                while (reader.canRead()) {
                    String property = reader.readString();
                    reader.skipWhitespace();
                    reader.expect('=');
                    reader.skipWhitespace();
                    String value = reader.readString();
                    ret.setString(property, value);
                    reader.skipWhitespace();
                    if (reader.canRead()) {
                        if (reader.peek() != ',') break;
                        reader.skip();
                    }
                    reader.skipWhitespace();
                }
            }
            reader.expect(']');
            return ret;
        }
        catch (Exception ex) {
            LOGGER.warn("Failed to parse block properties: " + input, (Throwable)ex);
            return null;
        }
    }

    private static void convertBlock(MapType nbt, String data) {
        MapType blockNBT = nbt.getTypeUtil().createEmptyMap();
        nbt.setMap("block_state", blockNBT);
        int propertiesStart = data.indexOf(91);
        if (propertiesStart == -1) {
            blockNBT.setString("Name", NamespaceUtil.correctNamespace(data));
            return;
        }
        blockNBT.setString("Name", NamespaceUtil.correctNamespace(data.substring(0, propertiesStart)));
        MapType properties = ConverterParticleToNBT.parseProperties(data.substring(propertiesStart), nbt.getTypeUtil());
        if (properties != null && !properties.isEmpty()) {
            blockNBT.setMap("Properties", properties);
        }
    }

    private static ListType parseFloatVector(StringReader reader, TypeUtil<?> type) throws CommandSyntaxException {
        float x2 = reader.readFloat();
        reader.expect(' ');
        float y2 = reader.readFloat();
        reader.expect(' ');
        float z2 = reader.readFloat();
        ListType ret = type.createEmptyList();
        ret.addFloat(x2);
        ret.addFloat(y2);
        ret.addFloat(z2);
        return ret;
    }

    private static void convertDust(MapType nbt, String data) {
        try {
            StringReader reader = new StringReader(data);
            ListType color = ConverterParticleToNBT.parseFloatVector(reader, nbt.getTypeUtil());
            reader.expect(' ');
            float scale = reader.readFloat();
            nbt.setList("color", color);
            nbt.setFloat("scale", scale);
        }
        catch (Exception ex) {
            LOGGER.warn("Failed to parse dust particle: " + data, (Throwable)ex);
        }
    }

    private static void convertColorDust(MapType nbt, String data) {
        try {
            StringReader reader = new StringReader(data);
            ListType fromColor = ConverterParticleToNBT.parseFloatVector(reader, nbt.getTypeUtil());
            reader.expect(' ');
            float scale = reader.readFloat();
            reader.expect(' ');
            ListType toColor = ConverterParticleToNBT.parseFloatVector(reader, nbt.getTypeUtil());
            nbt.setList("from_color", fromColor);
            nbt.setFloat("scale", scale);
            nbt.setList("to_color", toColor);
        }
        catch (Exception ex) {
            LOGGER.warn("Failed to parse color transition dust particle: " + data, (Throwable)ex);
        }
    }

    private static void convertSculk(MapType nbt, String data) {
        try {
            StringReader reader = new StringReader(data);
            float roll = reader.readFloat();
            nbt.setFloat("roll", roll);
        }
        catch (Exception ex) {
            LOGGER.warn("Failed to parse sculk particle: " + data, (Throwable)ex);
        }
    }

    private static void convertVibration(MapType nbt, String data) {
        try {
            StringReader reader = new StringReader(data);
            double posX = reader.readDouble();
            reader.expect(' ');
            double posY = reader.readDouble();
            reader.expect(' ');
            double posZ = reader.readDouble();
            reader.expect(' ');
            int arrival = reader.readInt();
            nbt.setInt("arrival_in_ticks", arrival);
            MapType destination = nbt.getTypeUtil().createEmptyMap();
            nbt.setMap("destination", destination);
            destination.setString("type", "minecraft:block");
            ListType pos = nbt.getTypeUtil().createEmptyList();
            destination.setList("pos", pos);
            pos.addInt(MathHelper.c(posX));
            pos.addInt(MathHelper.c(posY));
            pos.addInt(MathHelper.c(posZ));
        }
        catch (Exception ex) {
            LOGGER.warn("Failed to parse vibration particle: " + data, (Throwable)ex);
        }
    }

    private static void convertShriek(MapType nbt, String data) {
        try {
            StringReader reader = new StringReader(data);
            int delay = reader.readInt();
            nbt.setInt("delay", delay);
        }
        catch (Exception ex) {
            LOGGER.warn("Failed to parse shriek particle: " + data, (Throwable)ex);
        }
    }

    public static MapType convert(String flat, TypeUtil<?> type) {
        String[] split = flat.split(" ", 2);
        String name = NamespaceUtil.correctNamespace(split[0]);
        MapType ret = type.createEmptyMap();
        ret.setString("type", name);
        if (split.length > 1) {
            String data = split[1];
            switch (name) {
                case "minecraft:item": {
                    ConverterParticleToNBT.convertItem(ret, data);
                    break;
                }
                case "minecraft:block": 
                case "minecraft:block_marker": 
                case "minecraft:falling_dust": 
                case "minecraft:dust_pillar": {
                    ConverterParticleToNBT.convertBlock(ret, data);
                    break;
                }
                case "minecraft:dust": {
                    ConverterParticleToNBT.convertDust(ret, data);
                    break;
                }
                case "minecraft:dust_color_transition": {
                    ConverterParticleToNBT.convertColorDust(ret, data);
                    break;
                }
                case "minecraft:sculk_charge": {
                    ConverterParticleToNBT.convertSculk(ret, data);
                    break;
                }
                case "minecraft:vibration": {
                    ConverterParticleToNBT.convertVibration(ret, data);
                    break;
                }
                case "minecraft:shriek": {
                    ConverterParticleToNBT.convertShriek(ret, data);
                }
            }
        }
        return ret;
    }

    private ConverterParticleToNBT() {
    }
}

