/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.minecraft.walkers.generic.WalkerUtils;
import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.ObjectType;
import ca.spottedleaf.dataconverter.types.Types;

public final class V100 {
    private static final int VERSION = 100;

    public static void register() {
        MCTypeRegistry.ENTITY.addStructureConverter(new DataConverter<MapType, MapType>(100){

            @Override
            public MapType convert(MapType data, long sourceVersion, long toVersion) {
                ListType equipment = data.getList("Equipment", ObjectType.MAP);
                data.remove("Equipment");
                if (equipment != null) {
                    if (equipment.size() > 0 && data.getListUnchecked("HandItems") == null) {
                        ListType handItems = Types.NBT.createEmptyList();
                        data.setList("HandItems", handItems);
                        handItems.addMap(equipment.getMap(0));
                        handItems.addMap(Types.NBT.createEmptyMap());
                    }
                    if (equipment.size() > 1 && data.getListUnchecked("ArmorItems") == null) {
                        ListType armorItems = Types.NBT.createEmptyList();
                        data.setList("ArmorItems", armorItems);
                        for (int i2 = 1; i2 < Math.min(equipment.size(), 5); ++i2) {
                            armorItems.addMap(equipment.getMap(i2));
                        }
                    }
                }
                ListType dropChances = data.getList("DropChances", ObjectType.FLOAT);
                data.remove("DropChances");
                if (dropChances != null) {
                    if (data.getListUnchecked("HandDropChances") == null) {
                        ListType handDropChances = Types.NBT.createEmptyList();
                        data.setList("HandDropChances", handDropChances);
                        if (0 < dropChances.size()) {
                            handDropChances.addFloat(dropChances.getFloat(0));
                        } else {
                            handDropChances.addFloat(0.0f);
                        }
                        handDropChances.addFloat(0.0f);
                    }
                    if (data.getListUnchecked("ArmorDropChances") == null) {
                        ListType armorDropChances = Types.NBT.createEmptyList();
                        data.setList("ArmorDropChances", armorDropChances);
                        for (int i3 = 1; i3 < 5; ++i3) {
                            if (i3 < dropChances.size()) {
                                armorDropChances.addFloat(dropChances.getFloat(i3));
                                continue;
                            }
                            armorDropChances.addFloat(0.0f);
                        }
                    }
                }
                return null;
            }
        });
        MCTypeRegistry.ENTITY_EQUIPMENT.addStructureWalker(100, (data, fromVersion, toVersion) -> {
            WalkerUtils.convertList(MCTypeRegistry.ITEM_STACK, data, "ArmorItems", fromVersion, toVersion);
            WalkerUtils.convertList(MCTypeRegistry.ITEM_STACK, data, "HandItems", fromVersion, toVersion);
            WalkerUtils.convert(MCTypeRegistry.ITEM_STACK, data, "body_armor_item", fromVersion, toVersion);
            WalkerUtils.convert(MCTypeRegistry.ITEM_STACK, data, "saddle", fromVersion, toVersion);
            return null;
        });
    }

    private V100() {
    }
}

