/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.minecraft.walkers.generic.WalkerUtils;
import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.ObjectType;
import ca.spottedleaf.dataconverter.types.Types;

public final class V1466 {
    private static final int VERSION = 1466;

    private static short packOffsetCoordinates(int x2, int y2, int z2) {
        return (short)(x2 & 0xF | (y2 & 0xF) << 4 | (z2 & 0xF) << 8);
    }

    public static void register() {
        MCTypeRegistry.CHUNK.addStructureConverter(new DataConverter<MapType, MapType>(1466){

            @Override
            public MapType convert(MapType data, long sourceVersion, long toVersion) {
                ListType ticks;
                boolean lightPopulated;
                MapType level = data.getMap("Level");
                if (level == null) {
                    return null;
                }
                boolean terrainPopulated = level.getBoolean("TerrainPopulated");
                boolean bl = lightPopulated = level.getBoolean("LightPopulated") || level.getNumber("LightPopulated") == null;
                String newStatus = !terrainPopulated ? "carved" : (lightPopulated ? "mobs_spawned" : "decorated");
                level.setString("Status", newStatus);
                level.setBoolean("hasLegacyStructureData", true);
                byte[] biomes = level.getBytes("Biomes");
                if (biomes != null) {
                    int[] newBiomes = new int[256];
                    int len = Math.min(newBiomes.length, biomes.length);
                    for (int i2 = 0; i2 < len; ++i2) {
                        newBiomes[i2] = biomes[i2] & 0xFF;
                    }
                    level.setInts("Biomes", newBiomes);
                }
                if ((ticks = level.getList("TileTicks", ObjectType.MAP)) != null) {
                    int i3;
                    ListType sections = Types.NBT.createEmptyList();
                    ListType[] sectionAccess = new ListType[16];
                    for (i3 = 0; i3 < sectionAccess.length; ++i3) {
                        sectionAccess[i3] = Types.NBT.createEmptyList();
                        sections.addList(sectionAccess[i3]);
                    }
                    level.setList("ToBeTicked", sections);
                    int len = ticks.size();
                    for (i3 = 0; i3 < len; ++i3) {
                        MapType tick = ticks.getMap(i3);
                        int x2 = tick.getInt("x");
                        int y2 = tick.getInt("y");
                        int z2 = tick.getInt("z");
                        short coordinate = V1466.packOffsetCoordinates(x2, y2, z2);
                        sectionAccess[y2 >> 4].addShort(coordinate);
                    }
                }
                return null;
            }
        });
        MCTypeRegistry.CHUNK.addStructureWalker(1466, (data, fromVersion, toVersion) -> {
            ListType sections;
            MapType level = data.getMap("Level");
            if (level == null) {
                return null;
            }
            WalkerUtils.convertList(MCTypeRegistry.ENTITY, level, "Entities", fromVersion, toVersion);
            WalkerUtils.convertList(MCTypeRegistry.TILE_ENTITY, level, "TileEntities", fromVersion, toVersion);
            ListType tileTicks = level.getList("TileTicks", ObjectType.MAP);
            if (tileTicks != null) {
                int len = tileTicks.size();
                for (int i2 = 0; i2 < len; ++i2) {
                    MapType tileTick = tileTicks.getMap(i2);
                    WalkerUtils.convert(MCTypeRegistry.BLOCK_NAME, tileTick, "i", fromVersion, toVersion);
                }
            }
            if ((sections = level.getList("Sections", ObjectType.MAP)) != null) {
                int len = sections.size();
                for (int i3 = 0; i3 < len; ++i3) {
                    MapType section = sections.getMap(i3);
                    WalkerUtils.convertList(MCTypeRegistry.BLOCK_STATE, section, "Palette", fromVersion, toVersion);
                }
            }
            WalkerUtils.convertValues(MCTypeRegistry.STRUCTURE_FEATURE, level.getMap("Structures"), "Starts", fromVersion, toVersion);
            return null;
        });
        MCTypeRegistry.STRUCTURE_FEATURE.addStructureWalker(1466, (data, fromVersion, toVersion) -> {
            ListType list = data.getList("Children", ObjectType.MAP);
            if (list != null) {
                int len = list.size();
                for (int i2 = 0; i2 < len; ++i2) {
                    MapType child = list.getMap(i2);
                    WalkerUtils.convert(MCTypeRegistry.BLOCK_STATE, child, "CA", fromVersion, toVersion);
                    WalkerUtils.convert(MCTypeRegistry.BLOCK_STATE, child, "CB", fromVersion, toVersion);
                    WalkerUtils.convert(MCTypeRegistry.BLOCK_STATE, child, "CC", fromVersion, toVersion);
                    WalkerUtils.convert(MCTypeRegistry.BLOCK_STATE, child, "CD", fromVersion, toVersion);
                }
            }
            WalkerUtils.convert(MCTypeRegistry.BIOME, data, "biome", fromVersion, toVersion);
            return null;
        });
    }

    private V1466() {
    }
}

