/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.types.MapType;

public final class V2531 {
    private static final int VERSION = 2531;

    private static boolean isConnected(String facing) {
        return !"none".equals(facing);
    }

    public static void register() {
        MCTypeRegistry.BLOCK_STATE.addStructureConverter(new DataConverter<MapType, MapType>(2531){

            @Override
            public MapType convert(MapType data, long sourceVersion, long toVersion) {
                String newSouth;
                if (!"minecraft:redstone_wire".equals(data.getString("Name"))) {
                    return null;
                }
                MapType properties = data.getMap("Properties");
                if (properties == null) {
                    return null;
                }
                String east = properties.getString("east", "none");
                String west = properties.getString("west", "none");
                String north = properties.getString("north", "none");
                String south = properties.getString("south", "none");
                boolean connectedX = V2531.isConnected(east) || V2531.isConnected(west);
                boolean connectedZ = V2531.isConnected(north) || V2531.isConnected(south);
                String newEast = !V2531.isConnected(east) && !connectedZ ? "side" : east;
                String newWest = !V2531.isConnected(west) && !connectedZ ? "side" : west;
                String newNorth = !V2531.isConnected(north) && !connectedX ? "side" : north;
                String string = newSouth = !V2531.isConnected(south) && !connectedX ? "side" : south;
                if (properties.hasKey("east")) {
                    properties.setString("east", newEast);
                }
                if (properties.hasKey("west")) {
                    properties.setString("west", newWest);
                }
                if (properties.hasKey("north")) {
                    properties.setString("north", newNorth);
                }
                if (properties.hasKey("south")) {
                    properties.setString("south", newSouth);
                }
                return null;
            }
        });
    }

    private V2531() {
    }
}

