/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.ObjectType;
import com.google.common.collect.Sets;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class V2701 {
    private static final int VERSION = 2701;
    private static final Pattern INDEX_PATTERN = Pattern.compile("\\[(\\d+)\\]");
    private static final Set<String> PIECE_TYPE = Sets.newHashSet((Object[])new String[]{"minecraft:jigsaw", "minecraft:nvi", "minecraft:pcp", "minecraft:bastionremnant", "minecraft:runtime"});
    private static final Set<String> FEATURES = Sets.newHashSet((Object[])new String[]{"minecraft:tree", "minecraft:flower", "minecraft:block_pile", "minecraft:random_patch"});

    public static void register() {
        MCTypeRegistry.STRUCTURE_FEATURE.addStructureConverter(new DataConverter<MapType, MapType>(2701){

            @Override
            public MapType convert(MapType data, long sourceVersion, long toVersion) {
                ListType children = data.getList("Children", ObjectType.MAP);
                if (children == null) {
                    return null;
                }
                int len = children.size();
                for (int i2 = 0; i2 < len; ++i2) {
                    String replacement;
                    MapType feature;
                    String poolElement;
                    MapType child = children.getMap(i2);
                    if (!PIECE_TYPE.contains(child.getString("id")) || !"minecraft:feature_pool_element".equals(poolElement = child.getString("pool_element")) || (feature = child.getMap("feature")) == null || (replacement = V2701.convertToString(feature)) == null) continue;
                    child.setString("feature", replacement);
                }
                return null;
            }
        });
    }

    private static String getNestedString(MapType root, String ... paths) {
        if (paths.length == 0) {
            throw new IllegalArgumentException("Missing path");
        }
        Object current = root.getGeneric(paths[0]);
        for (int i2 = 1; i2 < paths.length; ++i2) {
            String path = paths[i2];
            Matcher indexMatcher = INDEX_PATTERN.matcher(path);
            if (!indexMatcher.matches()) {
                Object object = current = current instanceof MapType ? ((MapType)current).getGeneric(path) : null;
                if (current != null) continue;
                break;
            }
            int index = Integer.parseInt(indexMatcher.group(1));
            if (!(current instanceof ListType)) {
                current = null;
                break;
            }
            ListType list = (ListType)current;
            if (index >= 0 && index < list.size()) {
                current = list.getGeneric(index);
                continue;
            }
            current = null;
            break;
        }
        return current instanceof String ? (String)current : "";
    }

    private static String convertToString(MapType feature) {
        return V2701.getReplacement(V2701.getNestedString(feature, "type"), V2701.getNestedString(feature, "name"), V2701.getNestedString(feature, "config", "state_provider", "type"), V2701.getNestedString(feature, "config", "state_provider", "state", "Name"), V2701.getNestedString(feature, "config", "state_provider", "entries", "[0]", "data", "Name"), V2701.getNestedString(feature, "config", "foliage_placer", "type"), V2701.getNestedString(feature, "config", "leaves_provider", "state", "Name"));
    }

    private static String getReplacement(String type, String name, String stateType, String stateName, String firstEntryName, String foliageName, String leavesName) {
        String actualType;
        if (!type.isEmpty()) {
            actualType = type;
        } else {
            if (name.isEmpty()) {
                return null;
            }
            actualType = "minecraft:normal_tree".equals(name) ? "minecraft:tree" : name;
        }
        if (FEATURES.contains(actualType)) {
            if ("minecraft:random_patch".equals(actualType)) {
                if ("minecraft:simple_state_provider".equals(stateType)) {
                    if ("minecraft:sweet_berry_bush".equals(stateName)) {
                        return "minecraft:patch_berry_bush";
                    }
                    if ("minecraft:cactus".equals(stateName)) {
                        return "minecraft:patch_cactus";
                    }
                } else if ("minecraft:weighted_state_provider".equals(stateType) && ("minecraft:grass".equals(firstEntryName) || "minecraft:fern".equals(firstEntryName))) {
                    return "minecraft:patch_taiga_grass";
                }
            } else if ("minecraft:block_pile".equals(actualType)) {
                if (!"minecraft:simple_state_provider".equals(stateType) && !"minecraft:rotated_block_provider".equals(stateType)) {
                    if ("minecraft:weighted_state_provider".equals(stateType)) {
                        if ("minecraft:packed_ice".equals(firstEntryName) || "minecraft:blue_ice".equals(firstEntryName)) {
                            return "minecraft:pile_ice";
                        }
                        if ("minecraft:jack_o_lantern".equals(firstEntryName) || "minecraft:pumpkin".equals(firstEntryName)) {
                            return "minecraft:pile_pumpkin";
                        }
                    }
                } else {
                    if ("minecraft:hay_block".equals(stateName)) {
                        return "minecraft:pile_hay";
                    }
                    if ("minecraft:melon".equals(stateName)) {
                        return "minecraft:pile_melon";
                    }
                    if ("minecraft:snow".equals(stateName)) {
                        return "minecraft:pile_snow";
                    }
                }
            } else {
                if ("minecraft:flower".equals(actualType)) {
                    return "minecraft:flower_plain";
                }
                if ("minecraft:tree".equals(actualType)) {
                    if ("minecraft:acacia_foliage_placer".equals(foliageName)) {
                        return "minecraft:acacia";
                    }
                    if ("minecraft:blob_foliage_placer".equals(foliageName) && "minecraft:oak_leaves".equals(leavesName)) {
                        return "minecraft:oak";
                    }
                    if ("minecraft:pine_foliage_placer".equals(foliageName)) {
                        return "minecraft:pine";
                    }
                    if ("minecraft:spruce_foliage_placer".equals(foliageName)) {
                        return "minecraft:spruce";
                    }
                }
            }
        }
        return null;
    }

    private V2701() {
    }
}

