/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.minecraft.walkers.generic.WalkerUtils;
import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.ObjectType;
import ca.spottedleaf.dataconverter.types.Types;

public final class V2831 {
    private static final int VERSION = 2831;

    public static void register() {
        MCTypeRegistry.UNTAGGED_SPAWNER.addStructureWalker(2831, (root, fromVersion, toVersion) -> {
            WalkerUtils.convertListPath(MCTypeRegistry.ENTITY, root, "SpawnPotentials", "data", "entity", fromVersion, toVersion);
            WalkerUtils.convert(MCTypeRegistry.ENTITY, root.getMap("SpawnData"), "entity", fromVersion, toVersion);
            return null;
        });
        MCTypeRegistry.UNTAGGED_SPAWNER.addStructureConverter(new DataConverter<MapType, MapType>(2831){

            @Override
            public MapType convert(MapType root, long sourceVersion, long toVersion) {
                ListType spawnPotentials;
                MapType spawnData = root.getMap("SpawnData");
                if (spawnData != null) {
                    MapType wrapped = Types.NBT.createEmptyMap();
                    root.setMap("SpawnData", wrapped);
                    wrapped.setMap("entity", spawnData);
                }
                if ((spawnPotentials = root.getList("SpawnPotentials", ObjectType.MAP)) != null) {
                    int len = spawnPotentials.size();
                    for (int i2 = 0; i2 < len; ++i2) {
                        MapType spawnPotential = spawnPotentials.getMap(i2);
                        MapType entity = spawnPotential.getMap("Entity");
                        int weight = spawnPotential.getInt("Weight", 1);
                        spawnPotential.remove("Entity");
                        spawnPotential.remove("Weight");
                        spawnPotential.setInt("weight", weight);
                        MapType data = Types.NBT.createEmptyMap();
                        spawnPotential.setMap("data", data);
                        data.setMap("entity", entity);
                    }
                }
                return null;
            }
        });
    }

    private V2831() {
    }
}

