/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.ObjectType;
import com.google.common.collect.ImmutableMap;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;

public final class V2970 {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int VERSION = 2970;
    private static final Map<String, BiomeRemap> CONVERSION_MAP = new HashMap<String, BiomeRemap>((Map<String, BiomeRemap>)ImmutableMap.builder().put((Object)"mineshaft", (Object)BiomeRemap.create(Map.of(List.of("minecraft:badlands", "minecraft:eroded_badlands", "minecraft:wooded_badlands"), "minecraft:mineshaft_mesa"), "minecraft:mineshaft")).put((Object)"shipwreck", (Object)BiomeRemap.create(Map.of(List.of("minecraft:beach", "minecraft:snowy_beach"), "minecraft:shipwreck_beached"), "minecraft:shipwreck")).put((Object)"ocean_ruin", (Object)BiomeRemap.create(Map.of(List.of("minecraft:warm_ocean", "minecraft:lukewarm_ocean", "minecraft:deep_lukewarm_ocean"), "minecraft:ocean_ruin_warm"), "minecraft:ocean_ruin_cold")).put((Object)"village", (Object)BiomeRemap.create(Map.of(List.of("minecraft:desert"), "minecraft:village_desert", List.of("minecraft:savanna"), "minecraft:village_savanna", List.of("minecraft:snowy_plains"), "minecraft:village_snowy", List.of("minecraft:taiga"), "minecraft:village_taiga"), "minecraft:village_plains")).put((Object)"ruined_portal", (Object)BiomeRemap.create(Map.of(List.of("minecraft:desert"), "minecraft:ruined_portal_desert", List.of("minecraft:badlands", "minecraft:eroded_badlands", "minecraft:wooded_badlands", "minecraft:windswept_hills", "minecraft:windswept_forest", "minecraft:windswept_gravelly_hills", "minecraft:savanna_plateau", "minecraft:windswept_savanna", "minecraft:stony_shore", "minecraft:meadow", "minecraft:frozen_peaks", "minecraft:jagged_peaks", "minecraft:stony_peaks", "minecraft:snowy_slopes"), "minecraft:ruined_portal_mountain", List.of("minecraft:bamboo_jungle", "minecraft:jungle", "minecraft:sparse_jungle"), "minecraft:ruined_portal_jungle", List.of("minecraft:deep_frozen_ocean", "minecraft:deep_cold_ocean", "minecraft:deep_ocean", "minecraft:deep_lukewarm_ocean", "minecraft:frozen_ocean", "minecraft:ocean", "minecraft:cold_ocean", "minecraft:lukewarm_ocean", "minecraft:warm_ocean"), "minecraft:ruined_portal_ocean"), "minecraft:ruined_portal")).put((Object)"pillager_outpost", (Object)BiomeRemap.create("minecraft:pillager_outpost")).put((Object)"mansion", (Object)BiomeRemap.create("minecraft:mansion")).put((Object)"jungle_pyramid", (Object)BiomeRemap.create("minecraft:jungle_pyramid")).put((Object)"desert_pyramid", (Object)BiomeRemap.create("minecraft:desert_pyramid")).put((Object)"igloo", (Object)BiomeRemap.create("minecraft:igloo")).put((Object)"swamp_hut", (Object)BiomeRemap.create("minecraft:swamp_hut")).put((Object)"stronghold", (Object)BiomeRemap.create("minecraft:stronghold")).put((Object)"monument", (Object)BiomeRemap.create("minecraft:monument")).put((Object)"fortress", (Object)BiomeRemap.create("minecraft:fortress")).put((Object)"endcity", (Object)BiomeRemap.create("minecraft:end_city")).put((Object)"buried_treasure", (Object)BiomeRemap.create("minecraft:buried_treasure")).put((Object)"nether_fossil", (Object)BiomeRemap.create("minecraft:nether_fossil")).put((Object)"bastion_remnant", (Object)BiomeRemap.create("minecraft:bastion_remnant")).build());

    public static void register() {
        MCTypeRegistry.CHUNK.addStructureConverter(new DataConverter<MapType, MapType>(2970){

            private static Object2IntOpenHashMap<String> countBiomes(MapType chunk) {
                ListType sections = chunk.getList("sections", ObjectType.MAP);
                if (sections == null) {
                    return null;
                }
                Object2IntOpenHashMap ret = new Object2IntOpenHashMap();
                int len = sections.size();
                for (int i2 = 0; i2 < len; ++i2) {
                    ListType palette;
                    MapType section = sections.getMap(i2);
                    MapType biomes = section.getMap("biomes");
                    if (biomes == null || (palette = biomes.getList("palette", ObjectType.STRING)) == null) continue;
                    int len2 = palette.size();
                    for (int k2 = 0; k2 < len2; ++k2) {
                        ret.addTo((Object)palette.getString(k2), 1);
                    }
                }
                return ret;
            }

            private static String getStructureConverted(String id, Object2IntOpenHashMap<String> biomeCount) {
                BiomeRemap remap = CONVERSION_MAP.get(id = id.toLowerCase(Locale.ROOT));
                if (remap == null) {
                    return null;
                }
                if (remap.biomeToNewStructure == null || biomeCount == null) {
                    return remap.dfl;
                }
                Object2IntOpenHashMap remapCount = new Object2IntOpenHashMap();
                ObjectIterator iterator = biomeCount.object2IntEntrySet().fastIterator();
                while (iterator.hasNext()) {
                    Object2IntMap.Entry entry = (Object2IntMap.Entry)iterator.next();
                    String remappedStructure = remap.biomeToNewStructure.get(entry.getKey());
                    if (remappedStructure == null) continue;
                    remapCount.addTo((Object)remappedStructure, entry.getIntValue());
                }
                String converted = remap.dfl;
                int maxCount = 0;
                ObjectIterator iterator2 = remapCount.object2IntEntrySet().fastIterator();
                while (iterator2.hasNext()) {
                    Object2IntMap.Entry entry = (Object2IntMap.Entry)iterator2.next();
                    int count = entry.getIntValue();
                    if (count <= maxCount) continue;
                    maxCount = count;
                    converted = (String)entry.getKey();
                }
                return converted;
            }

            @Override
            public MapType convert(MapType data, long sourceVersion, long toVersion) {
                Object value;
                MapType structures = data.getMap("structures");
                if (structures == null || structures.isEmpty()) {
                    return null;
                }
                Object2IntOpenHashMap<String> biomeCounts = 1.countBiomes(data);
                MapType starts = structures.getMap("starts");
                MapType references = structures.getMap("References");
                if (starts != null) {
                    MapType newStarts = data.getTypeUtil().createEmptyMap();
                    structures.setMap("starts", newStarts);
                    for (String key : starts.keys()) {
                        value = starts.getMap(key);
                        if ("INVALID".equals(value.getString("id", "INVALID"))) continue;
                        String remapped = 1.getStructureConverted(key, biomeCounts);
                        if (remapped == null) {
                            LOGGER.warn("Encountered unknown structure in dataconverter: " + key);
                            continue;
                        }
                        value.setString("id", remapped);
                        newStarts.setMap(remapped, (MapType)value);
                    }
                }
                if (references != null) {
                    MapType newReferences = data.getTypeUtil().createEmptyMap();
                    structures.setMap("References", newReferences);
                    for (String key : references.keys()) {
                        value = references.getLongs(key);
                        if (((Object)value).length == 0) continue;
                        String newKey = 1.getStructureConverted(key, biomeCounts);
                        if (newKey == null) {
                            LOGGER.warn("Encountered unknown structure reference in dataconverter: " + key);
                            continue;
                        }
                        newReferences.setLongs(newKey, (long[])value);
                    }
                }
                return null;
            }
        });
    }

    private V2970() {
    }

    private static final class BiomeRemap {
        public final Map<String, String> biomeToNewStructure;
        public final String dfl;

        private BiomeRemap(Map<String, String> biomeToNewStructure, String dfl) {
            this.biomeToNewStructure = biomeToNewStructure;
            this.dfl = dfl;
        }

        public static BiomeRemap create(String newId) {
            return new BiomeRemap(null, newId);
        }

        public static BiomeRemap create(Map<List<String>, String> biomeMap, String newId) {
            HashMap<String, String> biomeToNewStructure = new HashMap<String, String>();
            for (Map.Entry<List<String>, String> entry : biomeMap.entrySet()) {
                List<String> biomes = entry.getKey();
                String newBiomeStructure = entry.getValue();
                int len = biomes.size();
                for (int i2 = 0; i2 < len; ++i2) {
                    String biome = biomes.get(i2);
                    if (biomeToNewStructure.putIfAbsent(biome, newBiomeStructure) == null) continue;
                    throw new IllegalStateException("Duplicate biome remap: " + biome + " -> " + newBiomeStructure + ", but already mapped to " + (String)biomeToNewStructure.get(biome));
                }
            }
            return new BiomeRemap(biomeToNewStructure, newId);
        }
    }
}

