/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.minecraft.util.ComponentUtils;
import ca.spottedleaf.dataconverter.minecraft.walkers.generic.WalkerUtils;
import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;

public final class V3439 {
    private static final int VERSION = 3439;

    private static void handleSignText(MapType text, long fromVersion, long toVersion) {
        if (text == null) {
            return;
        }
        WalkerUtils.convertList(MCTypeRegistry.TEXT_COMPONENT, text, "messages", fromVersion, toVersion);
        WalkerUtils.convertList(MCTypeRegistry.TEXT_COMPONENT, text, "filtered_messages", fromVersion, toVersion);
    }

    static void registerSign(int version, String id) {
        MCTypeRegistry.TILE_ENTITY.addWalker(version, id, (data, fromVersion, toVersion) -> {
            V3439.handleSignText(data.getMap("front_text"), fromVersion, toVersion);
            V3439.handleSignText(data.getMap("back_text"), fromVersion, toVersion);
            return null;
        });
    }

    public static void register() {
        DataConverter<MapType, MapType> signTileUpdater = new DataConverter<MapType, MapType>(3439){
            private static final String DEFAULT_COLOR = "black";

            private static ListType migrateToList(MapType root, String prefix) {
                if (root == null) {
                    return null;
                }
                ListType ret = root.getTypeUtil().createEmptyList();
                ret.addString(root.getString(prefix.concat("1"), ComponentUtils.EMPTY));
                ret.addString(root.getString(prefix.concat("2"), ComponentUtils.EMPTY));
                ret.addString(root.getString(prefix.concat("3"), ComponentUtils.EMPTY));
                ret.addString(root.getString(prefix.concat("4"), ComponentUtils.EMPTY));
                return ret;
            }

            @Override
            public MapType convert(MapType data, long sourceVersion, long toVersion) {
                MapType frontText = data.getTypeUtil().createEmptyMap();
                data.setMap("front_text", frontText);
                ListType frontMessages = 1.migrateToList(data, "Text");
                frontText.setList("messages", frontMessages);
                ListType frontFilteredMessages = null;
                for (int i2 = 0; i2 < 4; ++i2) {
                    String filtered = data.getString("FilteredText" + i2);
                    if (filtered == null) {
                        if (frontFilteredMessages == null) continue;
                        frontFilteredMessages.addString(frontMessages.getString(i2));
                        continue;
                    }
                    if (frontFilteredMessages == null) {
                        frontFilteredMessages = data.getTypeUtil().createEmptyList();
                        for (int k2 = 0; k2 < i2; ++k2) {
                            frontFilteredMessages.addString(frontMessages.getString(k2));
                        }
                    }
                    frontFilteredMessages.addString(filtered);
                }
                if (frontFilteredMessages != null) {
                    frontText.setList("filtered_messages", frontFilteredMessages);
                }
                frontText.setString("color", data.getString("Color", DEFAULT_COLOR));
                frontText.setBoolean("has_glowing_text", data.getBoolean("GlowingText", false));
                frontText.setBoolean("_filtered_correct", true);
                MapType backText = data.getTypeUtil().createEmptyMap();
                data.setMap("back_text", backText);
                ListType blankMessages = data.getTypeUtil().createEmptyList();
                backText.setList("messages", blankMessages);
                for (int i3 = 0; i3 < 4; ++i3) {
                    blankMessages.addString(ComponentUtils.EMPTY);
                }
                backText.setString("color", DEFAULT_COLOR);
                backText.setBoolean("has_glowing_text", false);
                data.setBoolean("is_waxed", false);
                return null;
            }
        };
        MCTypeRegistry.TILE_ENTITY.addConverterForId("minecraft:sign", signTileUpdater);
        MCTypeRegistry.TILE_ENTITY.addConverterForId("minecraft:hanging_sign", signTileUpdater);
        V3439.registerSign(3439, "minecraft:sign");
        V3439.registerSign(3439, "minecraft:hanging_sign");
    }

    private V3439() {
    }
}

