/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.converters.helpers.RenameHelper;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.ObjectType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class V3568 {
    private static final int VERSION = 3568;
    private static final String[] EFFECT_ID_MAP = new String[34];
    private static final Set<String> EFFECT_ITEMS;
    private static final Map<String, String> MOB_EFFECT_RENAMES;

    private static String readLegacyEffect(MapType data, String path) {
        Number id = data.getNumber(path);
        if (id == null) {
            return null;
        }
        int castedId = id.intValue();
        return castedId >= 0 && castedId < EFFECT_ID_MAP.length ? EFFECT_ID_MAP[castedId] : null;
    }

    private static void convertLegacyEffect(MapType data, String legacyPath, String newPath) {
        String newId;
        Number id = data.getNumber(legacyPath);
        data.remove(legacyPath);
        if (id == null) {
            return;
        }
        int castedId = id.intValue();
        String string = newId = castedId >= 0 && castedId < EFFECT_ID_MAP.length ? EFFECT_ID_MAP[castedId] : null;
        if (newId == null) {
            return;
        }
        data.setString(newPath, newId);
    }

    private static void convertMobEffect(MapType mobEffect) {
        if (mobEffect == null) {
            return;
        }
        V3568.convertLegacyEffect(mobEffect, "Id", "id");
        for (Map.Entry<String, String> rename : MOB_EFFECT_RENAMES.entrySet()) {
            RenameHelper.renameSingle(mobEffect, rename.getKey(), rename.getValue());
        }
        V3568.convertMobEffect(mobEffect.getMap("hidden_effect"));
    }

    private static void convertMobEffectList(MapType data, String oldPath, String newPath) {
        ListType effects = data.getList(oldPath, ObjectType.MAP);
        if (effects == null) {
            return;
        }
        int len = effects.size();
        for (int i2 = 0; i2 < len; ++i2) {
            V3568.convertMobEffect(effects.getMap(i2));
        }
        data.remove(oldPath);
        data.setList(newPath, effects);
    }

    private static void removeAndSet(MapType data, String toRemovePath, String toSetPath, Object toSet) {
        data.remove(toRemovePath);
        if (toSet != null) {
            data.setGeneric(toSetPath, toSet);
        }
    }

    private static void updateSuspiciousStew(MapType from, MapType into) {
        V3568.removeAndSet(into, "EffectId", "id", V3568.readLegacyEffect(from, "EffectId"));
        V3568.removeAndSet(into, "EffectDuration", "duration", from.getGeneric("EffectDuration"));
    }

    public static void register() {
        DataConverter<MapType, MapType> beaconConverter = new DataConverter<MapType, MapType>(3568){

            @Override
            public MapType convert(MapType data, long sourceVersion, long toVersion) {
                V3568.convertLegacyEffect(data, "Primary", "primary_effect");
                V3568.convertLegacyEffect(data, "Secondary", "secondary_effect");
                return null;
            }
        };
        DataConverter<MapType, MapType> mooshroomConverter = new DataConverter<MapType, MapType>(3568){

            @Override
            public MapType convert(MapType data, long sourceVersion, long toVersion) {
                MapType newEffect = data.getTypeUtil().createEmptyMap();
                V3568.updateSuspiciousStew(data, newEffect);
                data.remove("EffectId");
                data.remove("EffectDuration");
                if (!newEffect.isEmpty()) {
                    ListType stewEffects = data.getTypeUtil().createEmptyList();
                    data.setList("stew_effects", stewEffects);
                    stewEffects.addMap(newEffect);
                }
                return null;
            }
        };
        DataConverter<MapType, MapType> arrowConverter = new DataConverter<MapType, MapType>(3568){

            @Override
            public MapType convert(MapType data, long sourceVersion, long toVersion) {
                V3568.convertMobEffectList(data, "CustomPotionEffects", "custom_potion_effects");
                return null;
            }
        };
        DataConverter<MapType, MapType> areaEffectCloudConverter = new DataConverter<MapType, MapType>(3568){

            @Override
            public MapType convert(MapType data, long sourceVersion, long toVersion) {
                V3568.convertMobEffectList(data, "Effects", "effects");
                return null;
            }
        };
        DataConverter<MapType, MapType> livingEntityConverter = new DataConverter<MapType, MapType>(3568){

            @Override
            public MapType convert(MapType data, long sourceVersion, long toVersion) {
                V3568.convertMobEffectList(data, "ActiveEffects", "active_effects");
                return null;
            }
        };
        DataConverter<MapType, MapType> itemConverter = new DataConverter<MapType, MapType>(3568){

            @Override
            public MapType convert(MapType root, long sourceVersion, long toVersion) {
                String id = root.getString("id");
                MapType tag = root.getMap("tag");
                if (tag == null) {
                    return null;
                }
                if ("minecraft:suspicious_stew".equals(id)) {
                    RenameHelper.renameSingle(tag, "Effects", "effects");
                    ListType effects = tag.getList("effects", ObjectType.MAP);
                    if (effects != null) {
                        int len = effects.size();
                        for (int i2 = 0; i2 < len; ++i2) {
                            MapType effect = effects.getMap(i2);
                            V3568.updateSuspiciousStew(effect, effect);
                        }
                    }
                    return null;
                }
                if (EFFECT_ITEMS.contains(id)) {
                    V3568.convertMobEffectList(tag, "CustomPotionEffects", "custom_potion_effects");
                    return null;
                }
                return null;
            }
        };
        MCTypeRegistry.TILE_ENTITY.addConverterForId("minecraft:beacon", beaconConverter);
        MCTypeRegistry.ENTITY.addConverterForId("minecraft:mooshroom", mooshroomConverter);
        MCTypeRegistry.ENTITY.addConverterForId("minecraft:arrow", arrowConverter);
        MCTypeRegistry.ENTITY.addConverterForId("minecraft:area_effect_cloud", areaEffectCloudConverter);
        MCTypeRegistry.ENTITY.addStructureConverter(livingEntityConverter);
        MCTypeRegistry.PLAYER.addStructureConverter(livingEntityConverter);
        MCTypeRegistry.ITEM_STACK.addStructureConverter(itemConverter);
    }

    private V3568() {
    }

    static {
        V3568.EFFECT_ID_MAP[1] = "minecraft:speed";
        V3568.EFFECT_ID_MAP[2] = "minecraft:slowness";
        V3568.EFFECT_ID_MAP[3] = "minecraft:haste";
        V3568.EFFECT_ID_MAP[4] = "minecraft:mining_fatigue";
        V3568.EFFECT_ID_MAP[5] = "minecraft:strength";
        V3568.EFFECT_ID_MAP[6] = "minecraft:instant_health";
        V3568.EFFECT_ID_MAP[7] = "minecraft:instant_damage";
        V3568.EFFECT_ID_MAP[8] = "minecraft:jump_boost";
        V3568.EFFECT_ID_MAP[9] = "minecraft:nausea";
        V3568.EFFECT_ID_MAP[10] = "minecraft:regeneration";
        V3568.EFFECT_ID_MAP[11] = "minecraft:resistance";
        V3568.EFFECT_ID_MAP[12] = "minecraft:fire_resistance";
        V3568.EFFECT_ID_MAP[13] = "minecraft:water_breathing";
        V3568.EFFECT_ID_MAP[14] = "minecraft:invisibility";
        V3568.EFFECT_ID_MAP[15] = "minecraft:blindness";
        V3568.EFFECT_ID_MAP[16] = "minecraft:night_vision";
        V3568.EFFECT_ID_MAP[17] = "minecraft:hunger";
        V3568.EFFECT_ID_MAP[18] = "minecraft:weakness";
        V3568.EFFECT_ID_MAP[19] = "minecraft:poison";
        V3568.EFFECT_ID_MAP[20] = "minecraft:wither";
        V3568.EFFECT_ID_MAP[21] = "minecraft:health_boost";
        V3568.EFFECT_ID_MAP[22] = "minecraft:absorption";
        V3568.EFFECT_ID_MAP[23] = "minecraft:saturation";
        V3568.EFFECT_ID_MAP[24] = "minecraft:glowing";
        V3568.EFFECT_ID_MAP[25] = "minecraft:levitation";
        V3568.EFFECT_ID_MAP[26] = "minecraft:luck";
        V3568.EFFECT_ID_MAP[27] = "minecraft:unluck";
        V3568.EFFECT_ID_MAP[28] = "minecraft:slow_falling";
        V3568.EFFECT_ID_MAP[29] = "minecraft:conduit_power";
        V3568.EFFECT_ID_MAP[30] = "minecraft:dolphins_grace";
        V3568.EFFECT_ID_MAP[31] = "minecraft:bad_omen";
        V3568.EFFECT_ID_MAP[32] = "minecraft:hero_of_the_village";
        V3568.EFFECT_ID_MAP[33] = "minecraft:darkness";
        EFFECT_ITEMS = new HashSet<String>(Set.of("minecraft:potion", "minecraft:splash_potion", "minecraft:lingering_potion", "minecraft:tipped_arrow"));
        MOB_EFFECT_RENAMES = new HashMap<String, String>();
        MOB_EFFECT_RENAMES.put("Ambient", "ambient");
        MOB_EFFECT_RENAMES.put("Amplifier", "amplifier");
        MOB_EFFECT_RENAMES.put("Duration", "duration");
        MOB_EFFECT_RENAMES.put("ShowParticles", "show_particles");
        MOB_EFFECT_RENAMES.put("ShowIcon", "show_icon");
        MOB_EFFECT_RENAMES.put("FactorCalculationData", "factor_calculation_data");
        MOB_EFFECT_RENAMES.put("HiddenEffect", "hidden_effect");
    }
}

