/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.ObjectType;
import ca.spottedleaf.dataconverter.util.NamespaceUtil;

public final class V3812 {
    private static final int VERSION = 3812;

    public static void register() {
        MCTypeRegistry.ENTITY.addConverterForId("minecraft:wolf", new DataConverter<MapType, MapType>(3812){

            @Override
            public MapType convert(MapType data, long sourceVersion, long toVersion) {
                boolean doubleHealth = false;
                ListType attributes = data.getList("Attributes", ObjectType.MAP);
                if (attributes != null) {
                    int len = attributes.size();
                    for (int i2 = 0; i2 < len; ++i2) {
                        double base;
                        MapType attribute = attributes.getMap(i2);
                        if (!"minecraft:generic.max_health".equals(NamespaceUtil.correctNamespace(attribute.getString("Name"))) || (base = attribute.getDouble("Base", 0.0)) != 20.0) continue;
                        attribute.setDouble("Base", 40.0);
                        doubleHealth = true;
                    }
                }
                if (doubleHealth) {
                    data.setFloat("Health", data.getFloat("Health", 0.0f) * 2.0f);
                }
                return null;
            }
        });
    }

    private V3812() {
    }
}

