/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.converters.helpers.CopyHelper;
import ca.spottedleaf.dataconverter.minecraft.converters.helpers.RenameHelper;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.minecraft.walkers.generic.WalkerUtils;
import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.ObjectType;
import java.net.URI;

public final class V4292 {
    private static final int VERSION = 4292;

    public static void register() {
        MCTypeRegistry.TEXT_COMPONENT.addStructureConverter(new DataConverter<Object, Object>(4292){

            private static boolean isWebUrl(String value) {
                try {
                    String scheme = new URI(value).getScheme();
                    return "http".equalsIgnoreCase(scheme) || "https".equalsIgnoreCase(scheme);
                }
                catch (Exception ex) {
                    return false;
                }
            }

            private static boolean isValidCommandOrChat(String value) {
                int len = value.length();
                for (int i2 = 0; i2 < len; ++i2) {
                    char c2 = value.charAt(i2);
                    if (c2 >= ' ' && c2 != '\u007f' && c2 != '\u00a7') continue;
                    return false;
                }
                return true;
            }

            private static Integer parseInteger(MapType root, String path) {
                Object value = root.getGeneric(path);
                if (value instanceof String) {
                    String string = (String)value;
                    try {
                        return Integer.parseInt(string);
                    }
                    catch (Exception ex) {
                        return null;
                    }
                }
                if (value instanceof Number) {
                    Number number = (Number)value;
                    return number.intValue();
                }
                return null;
            }

            @Override
            public Object convert(Object data, long sourceVersion, long toVersion) {
                if (!(data instanceof MapType)) {
                    return null;
                }
                MapType root = (MapType)data;
                RenameHelper.renameSingle(root, "hoverEvent", "hover_event");
                MapType hoverEvent = root.getMap("hover_event");
                if (hoverEvent != null) {
                    switch (hoverEvent.getString("action", "")) {
                        case "show_text": {
                            RenameHelper.renameSingle(hoverEvent, "contents", "value");
                            break;
                        }
                        case "show_item": {
                            if (hoverEvent.hasKey("contents", ObjectType.STRING)) {
                                RenameHelper.renameSingle(hoverEvent, "contents", "id");
                                break;
                            }
                            MapType contents = hoverEvent.getOrCreateMap("contents");
                            hoverEvent.remove("contents");
                            CopyHelper.move(contents, "id", hoverEvent, "id");
                            CopyHelper.move(contents, "count", hoverEvent, "count");
                            CopyHelper.move(contents, "components", hoverEvent, "components");
                            break;
                        }
                        case "show_entity": {
                            MapType contents = hoverEvent.getOrCreateMap("contents");
                            hoverEvent.remove("contents");
                            CopyHelper.move(contents, "id", hoverEvent, "uuid");
                            CopyHelper.move(contents, "type", hoverEvent, "id");
                            CopyHelper.move(contents, "name", hoverEvent, "name");
                            break;
                        }
                    }
                }
                RenameHelper.renameSingle(root, "clickEvent", "click_event");
                MapType clickEvent = root.getMap("click_event");
                if (clickEvent != null) {
                    String value = clickEvent.getString("value", "");
                    switch (clickEvent.getString("action", "")) {
                        case "open_url": {
                            if (!1.isWebUrl(value)) {
                                root.remove("click_event");
                                break;
                            }
                            RenameHelper.renameSingle(clickEvent, "value", "url");
                            break;
                        }
                        case "open_file": {
                            RenameHelper.renameSingle(clickEvent, "value", "path");
                            break;
                        }
                        case "run_command": 
                        case "suggest_command": {
                            if (!1.isValidCommandOrChat(value)) {
                                root.remove("click_event");
                                break;
                            }
                            RenameHelper.renameSingle(clickEvent, "value", "command");
                            break;
                        }
                        case "change_page": {
                            Integer page = 1.parseInteger(clickEvent, "value");
                            if (page == null) {
                                root.remove("click_event");
                                break;
                            }
                            clickEvent.remove("value");
                            clickEvent.setInt("page", Math.max(1, page));
                        }
                    }
                }
                return null;
            }
        });
        MCTypeRegistry.TEXT_COMPONENT.addStructureWalker(4292, (input, fromVersion, toVersion) -> {
            if (input instanceof ListType) {
                ListType listType = (ListType)input;
                WalkerUtils.convert(MCTypeRegistry.TEXT_COMPONENT, listType, fromVersion, toVersion);
            } else if (input instanceof MapType) {
                MapType root = (MapType)input;
                WalkerUtils.convertList(MCTypeRegistry.TEXT_COMPONENT, root, "extra", fromVersion, toVersion);
                WalkerUtils.convert(MCTypeRegistry.TEXT_COMPONENT, root, "separator", fromVersion, toVersion);
                WalkerUtils.convert(MCTypeRegistry.DATACONVERTER_CUSTOM_TYPE_COMMAND, root.getMap("clickEvent"), "command", fromVersion, toVersion);
                MapType hoverEvent = root.getMap("hover_event");
                if (hoverEvent != null) {
                    switch (hoverEvent.getString("action", "")) {
                        case "show_text": {
                            WalkerUtils.convert(MCTypeRegistry.TEXT_COMPONENT, hoverEvent, "value", fromVersion, toVersion);
                            break;
                        }
                        case "show_item": {
                            WalkerUtils.convert(MCTypeRegistry.ITEM_STACK, root, "hover_event", fromVersion, toVersion);
                            break;
                        }
                        case "show_entity": {
                            WalkerUtils.convert(MCTypeRegistry.ENTITY_NAME, hoverEvent, "id", fromVersion, toVersion);
                            WalkerUtils.convert(MCTypeRegistry.TEXT_COMPONENT, hoverEvent, "name", fromVersion, toVersion);
                        }
                    }
                }
            }
            return null;
        });
    }

    private V4292() {
    }
}

