/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.minecraft.versions.V3818;
import ca.spottedleaf.dataconverter.types.MapType;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;

public final class V4299 {
    private static final int VERSION = 4299;

    public static void register() {
        MCTypeRegistry.ITEM_STACK.addStructureConverter(new DataConverter<MapType, MapType>(4299){
            private static final String[] AXOLOTL_VARIANT_LOOKUP = new String[]{"lucy", "wild", "gold", "cyan", "blue"};
            private static final Int2ObjectOpenHashMap<String> FISH_PATTERN_LOOKUP = new Int2ObjectOpenHashMap();

            private static String lookupAxolotl(int index) {
                return index >= 0 && index < AXOLOTL_VARIANT_LOOKUP.length ? AXOLOTL_VARIANT_LOOKUP[index] : AXOLOTL_VARIANT_LOOKUP[0];
            }

            @Override
            public MapType convert(MapType data, long sourceVersion, long toVersion) {
                String id;
                MapType components = data.getMap("components");
                if (components == null) {
                    return null;
                }
                switch (id = data.getString("id")) {
                    case "minecraft:axolotl_bucket": {
                        Number variant;
                        MapType bucketEntityData = components.getMap("minecraft:bucket_entity_data");
                        if (bucketEntityData == null || (variant = bucketEntityData.getNumber("Variant")) == null) break;
                        bucketEntityData.remove("Variant");
                        components.setString("minecraft:axolotl/variant", 1.lookupAxolotl(variant.intValue()));
                        break;
                    }
                    case "minecraft:salmon_bucket": {
                        Object type;
                        MapType bucketEntityData = components.getMap("minecraft:bucket_entity_data");
                        if (bucketEntityData == null || (type = bucketEntityData.getGeneric("type")) == null) break;
                        bucketEntityData.remove("type");
                        components.setGeneric("minecraft:salmon/size", type);
                        break;
                    }
                    case "minecraft:tropical_fish_bucket": {
                        Number variantBoxed;
                        MapType bucketEntityData = components.getMap("minecraft:bucket_entity_data");
                        if (bucketEntityData == null || (variantBoxed = bucketEntityData.getNumber("BucketVariantTag")) == null) break;
                        bucketEntityData.remove("BucketVariantTag");
                        int variant = variantBoxed.intValue();
                        String fishPattern = (String)FISH_PATTERN_LOOKUP.get(variant & 0xFFFF);
                        String baseColour = V3818.getBannerColour(variant >>> 16 & 0xFF);
                        String patternColour = V3818.getBannerColour(variant >>> 24 & 0xFF);
                        components.setString("minecraft:tropical_fish/pattern", fishPattern);
                        components.setString("minecraft:tropical_fish/base_color", baseColour);
                        components.setString("minecraft:tropical_fish/pattern_color", patternColour);
                        break;
                    }
                    case "minecraft:painting": {
                        MapType entityData = components.getMap("minecraft:entity_data");
                        if (entityData == null || !"minecraft:painting".equals(entityData.getString("id"))) break;
                        Object variant = entityData.getGeneric("variant");
                        if (variant != null) {
                            entityData.remove("variant");
                            components.setGeneric("minecraft:painting/variant", variant);
                        }
                        if (entityData.size() != 1) break;
                        components.remove("minecraft:entity_data");
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                return null;
            }

            static {
                FISH_PATTERN_LOOKUP.defaultReturnValue((Object)"kob");
                FISH_PATTERN_LOOKUP.put(1, (Object)"flopper");
                FISH_PATTERN_LOOKUP.put(256, (Object)"sunstreak");
                FISH_PATTERN_LOOKUP.put(257, (Object)"stripey");
                FISH_PATTERN_LOOKUP.put(512, (Object)"snooper");
                FISH_PATTERN_LOOKUP.put(513, (Object)"glitter");
                FISH_PATTERN_LOOKUP.put(768, (Object)"dasher");
                FISH_PATTERN_LOOKUP.put(769, (Object)"blockfish");
                FISH_PATTERN_LOOKUP.put(1024, (Object)"brinely");
                FISH_PATTERN_LOOKUP.put(1025, (Object)"betty");
                FISH_PATTERN_LOOKUP.put(1280, (Object)"spotty");
                FISH_PATTERN_LOOKUP.put(1281, (Object)"clayfish");
            }
        });
    }

    private V4299() {
    }
}

