/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.minecraft.walkers.generic.WalkerUtils;
import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Map;

public final class V4312 {
    private static final int VERSION = 4312;

    public static void register() {
        MCTypeRegistry.PLAYER.addStructureConverter(new DataConverter<MapType, MapType>(4312){
            private static final Int2ObjectOpenHashMap<String> SLOT_MOVE_MAPPING = new Int2ObjectOpenHashMap(Map.of(100, "feet", 101, "legs", 102, "chest", 103, "head", -106, "offhand"));

            @Override
            public MapType convert(MapType data, long sourceVersion, long toVersion) {
                ListType inventory = data.getListUnchecked("Inventory");
                if (inventory == null) {
                    return null;
                }
                MapType equipment = data.getTypeUtil().createEmptyMap();
                for (int i2 = 0; i2 < inventory.size(); ++i2) {
                    int slot;
                    String equipmentKey;
                    MapType item = inventory.getMap(i2, null);
                    if (item == null || (equipmentKey = (String)SLOT_MOVE_MAPPING.get(slot = item.getInt("Slot", Integer.MIN_VALUE))) == null) continue;
                    inventory.remove(i2--);
                    item.remove("Slot");
                    equipment.setMap(equipmentKey, item);
                }
                data.setMap("equipment", equipment);
                return null;
            }
        });
        MCTypeRegistry.PLAYER.addStructureWalker(4312, (data, fromVersion, toVersion) -> {
            WalkerUtils.convert(MCTypeRegistry.ENTITY, data.getMap("RootVehicle"), "Entity", fromVersion, toVersion);
            WalkerUtils.convertList(MCTypeRegistry.ENTITY, data, "ender_pearls", fromVersion, toVersion);
            WalkerUtils.convertList(MCTypeRegistry.ITEM_STACK, data, "Inventory", fromVersion, toVersion);
            WalkerUtils.convertList(MCTypeRegistry.ITEM_STACK, data, "EnderItems", fromVersion, toVersion);
            WalkerUtils.convert(MCTypeRegistry.ENTITY, data, "ShoulderEntityLeft", fromVersion, toVersion);
            WalkerUtils.convert(MCTypeRegistry.ENTITY, data, "ShoulderEntityRight", fromVersion, toVersion);
            MapType recipeBook = data.getMap("recipeBook");
            if (recipeBook != null) {
                WalkerUtils.convertList(MCTypeRegistry.RECIPE, recipeBook, "recipes", fromVersion, toVersion);
                WalkerUtils.convertList(MCTypeRegistry.RECIPE, recipeBook, "toBeDisplayed", fromVersion, toVersion);
            }
            WalkerUtils.convert(MCTypeRegistry.TEXT_COMPONENT, data, "CustomName", fromVersion, toVersion);
            return MCTypeRegistry.ENTITY_EQUIPMENT.convert((MapType)data, fromVersion, toVersion);
        });
    }

    private V4312() {
    }
}

