/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.types.nbt;

import ca.spottedleaf.dataconverter.minecraft.converters.helpers.CopyHelper;
import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.types.TypeUtil;
import ca.spottedleaf.dataconverter.types.nbt.NBTListType;
import ca.spottedleaf.dataconverter.types.nbt.NBTMapType;
import java.lang.runtime.SwitchBootstraps;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTNumber;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagEnd;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;

public final class NBTTypeUtil
implements TypeUtil<NBTBase> {
    @Override
    public ListType createEmptyList() {
        return new NBTListType();
    }

    @Override
    public MapType createEmptyMap() {
        return new NBTMapType();
    }

    @Override
    public Object convertTo(Object valueGeneric, TypeUtil<?> to) {
        if (valueGeneric == null || valueGeneric instanceof String || valueGeneric instanceof Boolean) {
            return valueGeneric;
        }
        if (valueGeneric instanceof Number) {
            Number number = (Number)valueGeneric;
            if (CopyHelper.sanitizeNumber(number) == null) {
                throw new IllegalStateException("Unknown type: " + String.valueOf(number));
            }
            return number;
        }
        if (valueGeneric instanceof NBTListType) {
            NBTListType listType = (NBTListType)valueGeneric;
            return NBTTypeUtil.convertNBT(to, listType.list);
        }
        if (valueGeneric instanceof NBTMapType) {
            NBTMapType mapType = (NBTMapType)valueGeneric;
            return NBTTypeUtil.convertNBT(to, mapType.map);
        }
        throw new IllegalStateException("Unknown type: " + String.valueOf(valueGeneric));
    }

    @Override
    public Object convertFromBaseToGeneric(NBTBase input, TypeUtil<?> to) {
        return NBTTypeUtil.convertNBTToGeneric(to, input);
    }

    @Override
    public Object baseToGeneric(NBTBase input) {
        NBTBase nBTBase = input;
        int n2 = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{NBTTagCompound.class, NBTTagList.class, NBTTagEnd.class, NBTTagString.class, NBTTagByteArray.class, NBTTagIntArray.class, NBTTagLongArray.class, NBTNumber.class}, (Object)nBTBase, n2)) {
            case 0 -> {
                NBTTagCompound ct = (NBTTagCompound)nBTBase;
                yield new NBTMapType(ct);
            }
            case 1 -> {
                NBTTagList lt = (NBTTagList)nBTBase;
                yield new NBTListType(lt);
            }
            case 2 -> {
                NBTTagEnd endTag = (NBTTagEnd)nBTBase;
                yield null;
            }
            case 3 -> {
                NBTTagString st = (NBTTagString)nBTBase;
                yield st.k();
            }
            case 4 -> {
                NBTTagByteArray bt = (NBTTagByteArray)nBTBase;
                yield bt.e();
            }
            case 5 -> {
                NBTTagIntArray it = (NBTTagIntArray)nBTBase;
                yield it.g();
            }
            case 6 -> {
                NBTTagLongArray lt = (NBTTagLongArray)nBTBase;
                yield lt.g();
            }
            case 7 -> {
                NBTNumber nt = (NBTNumber)nBTBase;
                yield nt.m();
            }
            case -1 -> null;
            default -> throw new IllegalStateException("Unknown tag: " + String.valueOf(input));
        };
    }

    @Override
    public NBTBase genericToBase(Object input) {
        Object object = input;
        int n2 = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{NBTMapType.class, NBTListType.class, String.class, Boolean.class, Byte.class, Short.class, Integer.class, Long.class, byte[].class, int[].class, long[].class}, (Object)object, n2)) {
            case -1 -> NBTTagEnd.b;
            case 0 -> {
                NBTMapType mapType = (NBTMapType)object;
                yield mapType.map;
            }
            case 1 -> {
                NBTListType listType = (NBTListType)object;
                yield listType.list;
            }
            case 2 -> {
                String string = (String)object;
                yield NBTTagString.a(string);
            }
            case 3 -> {
                Boolean bool = (Boolean)object;
                yield NBTTagByte.a(bool);
            }
            case 4 -> {
                Byte b = (Byte)object;
                yield NBTTagByte.a(b);
            }
            case 5 -> {
                Short s = (Short)object;
                yield NBTTagShort.a(s);
            }
            case 6 -> {
                Integer i = (Integer)object;
                yield NBTTagInt.a(i);
            }
            case 7 -> {
                Long l = (Long)object;
                yield NBTTagLong.a(l);
            }
            case 8 -> {
                byte[] bytes = (byte[])object;
                yield new NBTTagByteArray(bytes);
            }
            case 9 -> {
                int[] ints = (int[])object;
                yield new NBTTagIntArray(ints);
            }
            case 10 -> {
                long[] longs = (long[])object;
                yield new NBTTagLongArray(longs);
            }
            default -> throw new IllegalStateException("Unrecognized type " + String.valueOf(input));
        };
    }

    private static Object convertNBTToGeneric(TypeUtil<?> to, NBTBase nbt) {
        NBTBase nBTBase = nbt;
        int n2 = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{NBTTagCompound.class, NBTTagList.class, NBTTagEnd.class, NBTTagString.class, NBTTagByteArray.class, NBTTagIntArray.class, NBTTagLongArray.class, NBTNumber.class}, (Object)nBTBase, n2)) {
            case 0 -> {
                NBTTagCompound ct = (NBTTagCompound)nBTBase;
                yield NBTTypeUtil.convertNBT(to, ct);
            }
            case 1 -> {
                NBTTagList lt = (NBTTagList)nBTBase;
                yield NBTTypeUtil.convertNBT(to, lt);
            }
            case 2 -> {
                NBTTagEnd endTag = (NBTTagEnd)nBTBase;
                yield null;
            }
            case 3 -> {
                NBTTagString st = (NBTTagString)nBTBase;
                yield st.k();
            }
            case 4 -> {
                NBTTagByteArray bt = (NBTTagByteArray)nBTBase;
                yield bt.e();
            }
            case 5 -> {
                NBTTagIntArray it = (NBTTagIntArray)nBTBase;
                yield it.g();
            }
            case 6 -> {
                NBTTagLongArray lt = (NBTTagLongArray)nBTBase;
                yield lt.g();
            }
            case 7 -> {
                NBTNumber nt = (NBTNumber)nBTBase;
                yield nt.m();
            }
            case -1 -> null;
            default -> throw new IllegalStateException("Unknown tag: " + String.valueOf(nbt));
        };
    }

    public static MapType convertNBT(TypeUtil<?> to, NBTTagCompound nbt) {
        MapType ret = to.createEmptyMap();
        for (String key : nbt.e()) {
            ret.setGeneric(key, NBTTypeUtil.convertNBTToGeneric(to, nbt.a(key)));
        }
        return ret;
    }

    public static ListType convertNBT(TypeUtil<?> to, NBTTagList nbt) {
        ListType ret = to.createEmptyList();
        int len = nbt.size();
        for (int i2 = 0; i2 < len; ++i2) {
            ret.addGeneric(NBTTypeUtil.convertNBTToGeneric(to, nbt.c(i2)));
        }
        return ret;
    }
}

