/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.common.time;

import ca.spottedleaf.concurrentutil.util.TimeUtil;
import ca.spottedleaf.moonrise.common.time.TickTime;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;

public final class TickData {
    private final long interval;
    private final ArrayDeque<TickTime> timeData = new ArrayDeque();

    public TickData(long intervalNS) {
        this.interval = intervalNS;
    }

    public void addDataFrom(TickTime time) {
        TickTime first;
        long start = time.tickStart();
        while ((first = this.timeData.peekFirst()) != null && start - first.tickEnd() > this.interval) {
            this.timeData.pollFirst();
        }
        this.timeData.add(time);
    }

    private static double median(long[] arr, int fromIndex, int toIndex) {
        int len = toIndex - fromIndex;
        int middle = fromIndex + (len >>> 1);
        if ((len & 1) == 0) {
            return (double)(arr[middle - 1] + arr[middle]) / 2.0;
        }
        return arr[middle];
    }

    private static SegmentData computeSegmentData(long[] arr, int fromIndex, int toIndex, boolean inverse) {
        int len = toIndex - fromIndex;
        long sum = 0L;
        double median = TickData.median(arr, fromIndex, toIndex);
        long min = Long.MAX_VALUE;
        long max = Long.MIN_VALUE;
        for (int i2 = fromIndex; i2 < toIndex; ++i2) {
            long val = arr[i2];
            sum += val;
            min = Math.min(min, val);
            max = Math.max(max, val);
        }
        if (inverse) {
            return new SegmentData(len, (double)len / ((double)sum / 1.0E9), 1.0E9 / median, 1.0E9 / (double)max, 1.0E9 / (double)min);
        }
        return new SegmentData(len, (double)sum / (double)len, median, min, max);
    }

    private static SegmentedAverage computeSegmentedAverage(long[] data, int allStart, int allEnd, int percent99BestStart, int percent99BestEnd, int percent95BestStart, int percent95BestEnd, int percent1WorstStart, int percent1WorstEnd, int percent5WorstStart, int percent5WorstEnd, boolean inverse) {
        return new SegmentedAverage(TickData.computeSegmentData(data, allStart, allEnd, inverse), TickData.computeSegmentData(data, percent99BestStart, percent99BestEnd, inverse), TickData.computeSegmentData(data, percent95BestStart, percent95BestEnd, inverse), TickData.computeSegmentData(data, percent1WorstStart, percent1WorstEnd, inverse), TickData.computeSegmentData(data, percent5WorstStart, percent5WorstEnd, inverse), data);
    }

    public Double getTPSAverage(TickTime inProgress, long tickInterval) {
        if (this.timeData.isEmpty() && inProgress == null) {
            return null;
        }
        long totalTimeBetweenTicks = 0L;
        int collectedTicks = this.timeData.size();
        if (inProgress != null) {
            ++collectedTicks;
            totalTimeBetweenTicks += inProgress.differenceFromLastTick(tickInterval);
        }
        for (TickTime time : this.timeData) {
            totalTimeBetweenTicks += time.differenceFromLastTick(tickInterval);
        }
        return (double)collectedTicks / ((double)totalTimeBetweenTicks / 1.0E9);
    }

    public MSPTData getMSPTData(TickTime inProgress, long tickInterval) {
        if (this.timeData.isEmpty() && inProgress == null) {
            return null;
        }
        long totalTimeTicking = 0L;
        long[] timePerTickDataRaw = new long[this.timeData.size() + (inProgress != null ? 1 : 0)];
        int index = 0;
        for (TickTime time : this.timeData) {
            long totalLength = time.tickLength() + time.intermediateTaskExecutionTime();
            totalTimeTicking += totalLength;
            timePerTickDataRaw[index++] = totalLength;
        }
        if (inProgress != null) {
            long totalLength = inProgress.tickLength() + inProgress.intermediateTaskExecutionTime();
            totalTimeTicking += totalLength;
            timePerTickDataRaw[index++] = totalLength;
        }
        return new MSPTData((double)totalTimeTicking / (double)timePerTickDataRaw.length * 1.0E-6, timePerTickDataRaw);
    }

    public TickReportData generateTickReport(TickTime inProgress, long endTime, long tickInterval) {
        if (this.timeData.isEmpty() && inProgress == null) {
            return null;
        }
        ArrayList<TickTime> allData = new ArrayList<TickTime>(this.timeData);
        if (inProgress != null) {
            allData.add(inProgress);
        }
        long intervalStart = ((TickTime)allData.get(0)).tickStart();
        long intervalEnd = ((TickTime)allData.get(allData.size() - 1)).tickEnd();
        long totalTimeOverInterval = 0L;
        long measureStart = endTime - this.interval;
        int len = allData.size();
        for (int i2 = 0; i2 < len; ++i2) {
            TickTime time = (TickTime)allData.get(i2);
            if (TimeUtil.compareTimes((long)time.tickStart(), (long)measureStart) < 0) {
                long diff = time.tickEnd() - measureStart;
                if (diff <= 0L) continue;
                totalTimeOverInterval += diff;
                continue;
            }
            totalTimeOverInterval += time.tickLength();
        }
        int collectedTicks = allData.size();
        long[] tickStartToStartDifferences = new long[collectedTicks];
        long[] timePerTickDataRaw = new long[collectedTicks];
        long[] missingCPUTimeDataRaw = new long[collectedTicks];
        long totalTimeTicking = 0L;
        int i3 = 0;
        for (TickTime time : allData) {
            tickStartToStartDifferences[i3] = time.differenceFromLastTick(tickInterval);
            long timePerTick = timePerTickDataRaw[i3] = time.tickLength() + time.intermediateTaskExecutionTime();
            if (time.supportCPUTime()) {
                missingCPUTimeDataRaw[i3] = Math.max(0L, timePerTick - (time.tickCpuTime() + time.intermediateTaskExecutionTimeCPU()));
            }
            ++i3;
            totalTimeTicking += timePerTick;
        }
        Arrays.sort(tickStartToStartDifferences);
        Arrays.sort(timePerTickDataRaw);
        Arrays.sort(missingCPUTimeDataRaw);
        boolean allStart = false;
        int allEnd = collectedTicks;
        boolean percent95BestStart = false;
        int percent95BestEnd = collectedTicks == 1 ? 1 : (int)(0.95 * (double)collectedTicks);
        boolean percent99BestStart = false;
        int percent99BestEnd = collectedTicks == 1 ? 1 : (int)(0.99 * (double)collectedTicks);
        int percent1WorstStart = (int)(0.99 * (double)collectedTicks);
        int percent1WorstEnd = collectedTicks;
        int percent5WorstStart = (int)(0.95 * (double)collectedTicks);
        int percent5WorstEnd = collectedTicks;
        SegmentedAverage tpsData = TickData.computeSegmentedAverage(tickStartToStartDifferences, 0, allEnd, 0, percent99BestEnd, 0, percent95BestEnd, percent1WorstStart, percent1WorstEnd, percent5WorstStart, percent5WorstEnd, true);
        SegmentedAverage timePerTickData = TickData.computeSegmentedAverage(timePerTickDataRaw, 0, allEnd, 0, percent99BestEnd, 0, percent95BestEnd, percent1WorstStart, percent1WorstEnd, percent5WorstStart, percent5WorstEnd, false);
        SegmentedAverage missingCPUTimeData = TickData.computeSegmentedAverage(missingCPUTimeDataRaw, 0, allEnd, 0, percent99BestEnd, 0, percent95BestEnd, percent1WorstStart, percent1WorstEnd, percent5WorstStart, percent5WorstEnd, false);
        double utilisation = (double)totalTimeOverInterval / (double)this.interval;
        return new TickReportData(collectedTicks, intervalStart, intervalEnd, totalTimeTicking, utilisation, tpsData, timePerTickData, missingCPUTimeData);
    }

    public record SegmentData(int count, double average, double median, double least, double greatest) {
    }

    public record SegmentedAverage(SegmentData segmentAll, SegmentData segment99PercentBest, SegmentData segment95PercentBest, SegmentData segment5PercentWorst, SegmentData segment1PercentWorst, long[] rawData) {
    }

    public record MSPTData(double avg, long[] rawData) {
    }

    public record TickReportData(int collectedTicks, long collectedTickIntervalStart, long collectedTickIntervalEnd, long totalTimeTicking, double utilisation, SegmentedAverage tpsData, SegmentedAverage timePerTickData, SegmentedAverage missingCPUTimeData) {
    }
}

