/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.common.util;

import java.lang.invoke.CallSite;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3D;

public final class EntityUtil {
    private static final ThreadLocal<DecimalFormat> THREE_DECIMAL_PLACES = ThreadLocal.withInitial(() -> new DecimalFormat("#,##0.000"));

    private static String formatVec(Vec3D vec) {
        DecimalFormat format = THREE_DECIMAL_PLACES.get();
        return "(" + format.format(vec.g) + "," + format.format(vec.h) + "," + format.format(vec.i) + ")";
    }

    private static String dumpEntityWithoutReferences(Entity entity) {
        if (entity == null) {
            return "{null}";
        }
        return "{type=" + entity.getClass().getSimpleName() + ",id=" + entity.aA() + ",uuid=" + String.valueOf(entity.cY()) + ",pos=" + EntityUtil.formatVec(entity.dI()) + ",mot=" + EntityUtil.formatVec(entity.dN()) + ",aabb=" + String.valueOf(entity.dj()) + ",removed=" + String.valueOf((Object)entity.ei()) + ",has_vehicle=" + (entity.dz() != null) + ",passenger_count=" + entity.dn().size();
    }

    public static String dumpEntity(Entity entity) {
        List<Entity> passengers = entity.dn();
        ArrayList<CallSite> passengerStrings = new ArrayList<CallSite>(passengers.size());
        for (Entity passenger : passengers) {
            passengerStrings.add((CallSite)((Object)("(" + EntityUtil.dumpEntityWithoutReferences(passenger) + ")")));
        }
        return "{root=[" + EntityUtil.dumpEntityWithoutReferences(entity) + "], vehicle=[" + EntityUtil.dumpEntityWithoutReferences(entity.dz()) + "], passengers=[" + String.join((CharSequence)",", passengerStrings) + "]";
    }

    private EntityUtil() {
    }
}

