/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.common.util;

import ca.spottedleaf.moonrise.common.util.EntityUtil;
import ca.spottedleaf.moonrise.common.util.WorldUtil;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TickThread
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(TickThread.class);
    public final int id;
    private static final AtomicInteger ID_GENERATOR = new AtomicInteger();

    private static String getThreadContext() {
        return "thread=" + Thread.currentThread().getName();
    }

    @Deprecated
    public static void ensureTickThread(String reason) {
        if (!TickThread.isTickThread()) {
            LOGGER.error("Thread failed main thread check: " + reason + ", context=" + TickThread.getThreadContext(), new Throwable());
            throw new IllegalStateException(reason);
        }
    }

    public static void ensureTickThread(World world, BlockPosition pos, String reason) {
        if (!TickThread.isTickThreadFor(world, pos)) {
            String ex = "Thread failed main thread check: " + reason + ", context=" + TickThread.getThreadContext() + ", world=" + WorldUtil.getWorldName(world) + ", block_pos=" + String.valueOf(pos);
            LOGGER.error(ex, new Throwable());
            throw new IllegalStateException(ex);
        }
    }

    public static void ensureTickThread(World world, BlockPosition pos, int blockRadius, String reason) {
        if (!TickThread.isTickThreadFor(world, pos, blockRadius)) {
            String ex = "Thread failed main thread check: " + reason + ", context=" + TickThread.getThreadContext() + ", world=" + WorldUtil.getWorldName(world) + ", block_pos=" + String.valueOf(pos) + ", block_radius=" + blockRadius;
            LOGGER.error(ex, new Throwable());
            throw new IllegalStateException(ex);
        }
    }

    public static void ensureTickThread(World world, ChunkCoordIntPair pos, String reason) {
        if (!TickThread.isTickThreadFor(world, pos)) {
            String ex = "Thread failed main thread check: " + reason + ", context=" + TickThread.getThreadContext() + ", world=" + WorldUtil.getWorldName(world) + ", chunk_pos=" + String.valueOf(pos);
            LOGGER.error(ex, new Throwable());
            throw new IllegalStateException(ex);
        }
    }

    public static void ensureTickThread(World world, int chunkX, int chunkZ, String reason) {
        if (!TickThread.isTickThreadFor(world, chunkX, chunkZ)) {
            String ex = "Thread failed main thread check: " + reason + ", context=" + TickThread.getThreadContext() + ", world=" + WorldUtil.getWorldName(world) + ", chunk_pos=" + String.valueOf(new ChunkCoordIntPair(chunkX, chunkZ));
            LOGGER.error(ex, new Throwable());
            throw new IllegalStateException(ex);
        }
    }

    public static void ensureTickThread(Entity entity, String reason) {
        if (!TickThread.isTickThreadFor(entity)) {
            String ex = "Thread failed main thread check: " + reason + ", context=" + TickThread.getThreadContext() + ", entity=" + EntityUtil.dumpEntity(entity);
            LOGGER.error(ex, new Throwable());
            throw new IllegalStateException(ex);
        }
    }

    public static void ensureTickThread(World world, AxisAlignedBB aabb, String reason) {
        if (!TickThread.isTickThreadFor(world, aabb)) {
            String ex = "Thread failed main thread check: " + reason + ", context=" + TickThread.getThreadContext() + ", world=" + WorldUtil.getWorldName(world) + ", aabb=" + String.valueOf(aabb);
            LOGGER.error(ex, new Throwable());
            throw new IllegalStateException(ex);
        }
    }

    public static void ensureTickThread(World world, double blockX, double blockZ, String reason) {
        if (!TickThread.isTickThreadFor(world, blockX, blockZ)) {
            String ex = "Thread failed main thread check: " + reason + ", context=" + TickThread.getThreadContext() + ", world=" + WorldUtil.getWorldName(world) + ", block_pos=" + String.valueOf(new Vec3D(blockX, 0.0, blockZ));
            LOGGER.error(ex, new Throwable());
            throw new IllegalStateException(ex);
        }
    }

    public TickThread(String name) {
        this((Runnable)null, name);
    }

    public TickThread(Runnable run, String name) {
        this(null, run, name);
    }

    public TickThread(ThreadGroup group, Runnable run, String name) {
        this(group, run, name, ID_GENERATOR.incrementAndGet());
    }

    private TickThread(ThreadGroup group, Runnable run, String name, int id) {
        super(group, run, name);
        this.id = id;
    }

    public static TickThread getCurrentTickThread() {
        return (TickThread)Thread.currentThread();
    }

    public static boolean isTickThread() {
        return Thread.currentThread() instanceof TickThread;
    }

    public static boolean isShutdownThread() {
        return false;
    }

    public static boolean isTickThreadFor(World world, BlockPosition pos) {
        return TickThread.isTickThread();
    }

    public static boolean isTickThreadFor(World world, BlockPosition pos, int blockRadius) {
        return TickThread.isTickThread();
    }

    public static boolean isTickThreadFor(World world, ChunkCoordIntPair pos) {
        return TickThread.isTickThread();
    }

    public static boolean isTickThreadFor(World world, Vec3D pos) {
        return TickThread.isTickThread();
    }

    public static boolean isTickThreadFor(World world, int chunkX, int chunkZ) {
        return TickThread.isTickThread();
    }

    public static boolean isTickThreadFor(World world, AxisAlignedBB aabb) {
        return TickThread.isTickThread();
    }

    public static boolean isTickThreadFor(World world, double blockX, double blockZ) {
        return TickThread.isTickThread();
    }

    public static boolean isTickThreadFor(World world, Vec3D position, Vec3D deltaMovement, int buffer) {
        return TickThread.isTickThread();
    }

    public static boolean isTickThreadFor(World world, int fromChunkX, int fromChunkZ, int toChunkX, int toChunkZ) {
        return TickThread.isTickThread();
    }

    public static boolean isTickThreadFor(World world, int chunkX, int chunkZ, int radius) {
        return TickThread.isTickThread();
    }

    public static boolean isTickThreadFor(Entity entity) {
        return TickThread.isTickThread();
    }
}

