/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.patches.starlight.util;

import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.patches.starlight.light.SWMRNibbleArray;
import ca.spottedleaf.moonrise.patches.starlight.light.StarLightEngine;
import com.mojang.logging.LogUtils;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.World;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import org.slf4j.Logger;

public final class SaveUtil {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final int STARLIGHT_LIGHT_VERSION = 10;
    public static final String BLOCKLIGHT_STATE_TAG = "starlight.blocklight_state";
    public static final String SKYLIGHT_STATE_TAG = "starlight.skylight_state";
    public static final String STARLIGHT_VERSION_TAG = "starlight.light_version";

    public static int getLightVersion() {
        return 10;
    }

    public static void saveLightHook(World world, IChunkAccess chunk, NBTTagCompound nbt) {
        try {
            SaveUtil.saveLightHookReal(world, chunk, nbt);
        }
        catch (Throwable ex) {
            LOGGER.warn("Failed to inject light data into save data for chunk " + String.valueOf(chunk.f()) + ", chunk light will be recalculated on its next load", ex);
        }
    }

    private static void saveLightHookReal(World world, IChunkAccess chunk, NBTTagCompound tag) {
        int i2;
        boolean lit;
        if (tag == null) {
            return;
        }
        int minSection = WorldUtil.getMinLightSection(world);
        int maxSection = WorldUtil.getMaxLightSection(world);
        SWMRNibbleArray[] blockNibbles = chunk.starlight$getBlockNibbles();
        SWMRNibbleArray[] skyNibbles = chunk.starlight$getSkyNibbles();
        boolean bl = lit = chunk.x() || !(world instanceof WorldServer);
        if (lit) {
            tag.a("isLightOn", false);
        }
        ChunkStatus status = tag.a("Status", ChunkStatus.o).orElse(ChunkStatus.c);
        NBTTagCompound[] sections = new NBTTagCompound[maxSection - minSection + 1];
        NBTTagList sectionsStored = tag.p("sections");
        for (i2 = 0; i2 < sectionsStored.size(); ++i2) {
            NBTTagCompound sectionStored = sectionsStored.a(i2).orElse(null);
            if (sectionStored == null) continue;
            byte k2 = sectionStored.b("Y", (byte)0);
            sectionStored.r("BlockLight");
            sectionStored.r("SkyLight");
            if (sectionStored.j()) continue;
            sections[k2 - minSection] = sectionStored;
        }
        if (lit && status.a(ChunkStatus.l)) {
            for (i2 = minSection; i2 <= maxSection; ++i2) {
                SWMRNibbleArray.SaveState blockNibble = blockNibbles[i2 - minSection].getSaveState();
                SWMRNibbleArray.SaveState skyNibble = skyNibbles[i2 - minSection].getSaveState();
                if (blockNibble == null && skyNibble == null) continue;
                NBTTagCompound section = sections[i2 - minSection];
                if (section == null) {
                    section = new NBTTagCompound();
                    section.a("Y", (byte)i2);
                    sections[i2 - minSection] = section;
                }
                if (blockNibble != null) {
                    if (blockNibble.data != null) {
                        section.a("BlockLight", blockNibble.data);
                    }
                    section.a(BLOCKLIGHT_STATE_TAG, blockNibble.state);
                }
                if (skyNibble == null) continue;
                if (skyNibble.data != null) {
                    section.a("SkyLight", skyNibble.data);
                }
                section.a(SKYLIGHT_STATE_TAG, skyNibble.state);
            }
        }
        sectionsStored.clear();
        for (NBTTagCompound section : sections) {
            if (section == null) continue;
            sectionsStored.add(section);
        }
        tag.a("sections", sectionsStored);
        if (lit) {
            tag.a(STARLIGHT_VERSION_TAG, 10);
        }
    }

    public static void loadLightHook(World world, ChunkCoordIntPair pos, NBTTagCompound tag, IChunkAccess into) {
        try {
            SaveUtil.loadLightHookReal(world, pos, tag, into);
        }
        catch (Throwable ex) {
            LOGGER.warn("Failed to load light for chunk " + String.valueOf(pos) + ", light will be recalculated", ex);
        }
    }

    private static void loadLightHookReal(World world, ChunkCoordIntPair pos, NBTTagCompound tag, IChunkAccess into) {
        if (into == null) {
            return;
        }
        int minSection = WorldUtil.getMinLightSection(world);
        int maxSection = WorldUtil.getMaxLightSection(world);
        into.a(false);
        SWMRNibbleArray[] blockNibbles = StarLightEngine.getFilledEmptyLight(world);
        SWMRNibbleArray[] skyNibbles = StarLightEngine.getFilledEmptyLight(world);
        boolean lit = tag.a("isLightOn") != null && tag.b(STARLIGHT_VERSION_TAG, -1) == 10;
        boolean canReadSky = world.F_().e();
        ChunkStatus status = tag.a("Status", ChunkStatus.o).orElse(ChunkStatus.c);
        if (lit && status.a(ChunkStatus.l)) {
            NBTTagList sections = tag.p("sections");
            for (int i2 = 0; i2 < sections.size(); ++i2) {
                NBTTagCompound sectionData = sections.a(i2).orElse(null);
                if (sectionData == null) continue;
                byte y2 = sectionData.b("Y", (byte)0);
                byte[] blockLight = sectionData.j("BlockLight").orElse(null);
                blockNibbles[y2 - minSection] = blockLight != null ? new SWMRNibbleArray((byte[])blockLight.clone(), sectionData.b(BLOCKLIGHT_STATE_TAG, 0)) : new SWMRNibbleArray(null, sectionData.b(BLOCKLIGHT_STATE_TAG, 0));
                if (!canReadSky) continue;
                byte[] skyLight = sectionData.j("SkyLight").orElse(null);
                skyNibbles[y2 - minSection] = skyLight != null ? new SWMRNibbleArray((byte[])skyLight.clone(), sectionData.b(SKYLIGHT_STATE_TAG, 0)) : new SWMRNibbleArray(null, sectionData.b(SKYLIGHT_STATE_TAG, 0));
            }
        }
        into.starlight$setBlockNibbles(blockNibbles);
        into.starlight$setSkyNibbles(skyNibbles);
        into.a(lit);
    }

    private SaveUtil() {
    }
}

