/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper;

import com.destroystokyo.paper.VersionHistoryManager;
import com.destroystokyo.paper.util.VersionFetcher;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.logging.LogUtils;
import io.papermc.paper.ServerBuildInfo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import org.apache.logging.log4j.LogManager;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.DefaultQualifier;
import org.slf4j.Logger;

@DefaultQualifier(value=NonNull.class)
public class PaperVersionFetcher
implements VersionFetcher {
    private static final Logger LOGGER = LogUtils.getClassLogger();
    private static final ComponentLogger COMPONENT_LOGGER = ComponentLogger.logger((String)LogManager.getRootLogger().getName());
    private static final int DISTANCE_ERROR = -1;
    private static final int DISTANCE_UNKNOWN = -2;
    private static final String DOWNLOAD_PAGE = "https://papermc.io/downloads/paper";
    private static final String REPOSITORY = "PaperMC/Paper";
    private static final ServerBuildInfo BUILD_INFO = ServerBuildInfo.buildInfo();
    private static final String USER_AGENT = BUILD_INFO.brandName() + "/" + BUILD_INFO.asString(ServerBuildInfo.StringRepresentation.VERSION_SIMPLE) + " (https://papermc.io)";
    private static final Gson GSON = new Gson();

    public long getCacheTime() {
        return 720000L;
    }

    public Component getVersionMessage() {
        Object updateMessage = BUILD_INFO.buildNumber().isEmpty() && BUILD_INFO.gitCommit().isEmpty() ? Component.text((String)"You are running a development version without access to version information", (TextColor)TextColor.color((int)16732928)) : PaperVersionFetcher.getUpdateStatusMessage();
        @Nullable Component history = this.getHistory();
        return history != null ? Component.textOfChildren((ComponentLike[])new ComponentLike[]{updateMessage, Component.newline(), history}) : updateMessage;
    }

    public static void getUpdateStatusStartupMessage() {
        int distance = -1;
        OptionalInt buildNumber = BUILD_INFO.buildNumber();
        if (buildNumber.isEmpty() && BUILD_INFO.gitCommit().isEmpty()) {
            COMPONENT_LOGGER.warn((Component)Component.text((String)"*** You are running a development version without access to version information ***"));
        } else {
            Optional<MinecraftVersionFetcher> apiResult = PaperVersionFetcher.fetchMinecraftVersionList();
            if (buildNumber.isPresent()) {
                distance = PaperVersionFetcher.fetchDistanceFromSiteApi(buildNumber.getAsInt());
            } else {
                Optional gitBranch = BUILD_INFO.gitBranch();
                Optional gitCommit = BUILD_INFO.gitCommit();
                if (gitBranch.isPresent() && gitCommit.isPresent()) {
                    distance = PaperVersionFetcher.fetchDistanceFromGitHub((String)gitBranch.get(), (String)gitCommit.get());
                }
            }
            switch (distance) {
                case -1: {
                    COMPONENT_LOGGER.error((Component)Component.text((String)"*** Error obtaining version information! Cannot fetch version info ***"));
                    break;
                }
                case 0: {
                    apiResult.ifPresent(result -> {
                        COMPONENT_LOGGER.warn((Component)Component.text((String)"*************************************************************************************"));
                        COMPONENT_LOGGER.warn((Component)Component.text((String)("You are running the latest build for your Minecraft version (" + BUILD_INFO.minecraftVersionId() + ")")));
                        COMPONENT_LOGGER.warn((Component)Component.text((String)("However, you are " + result.distance() + " release(s) behind the latest stable release (" + result.latestVersion() + ")!")));
                        COMPONENT_LOGGER.warn((Component)Component.text((String)"It is recommended that you update as soon as possible"));
                        COMPONENT_LOGGER.warn((Component)Component.text((String)DOWNLOAD_PAGE));
                        COMPONENT_LOGGER.warn((Component)Component.text((String)"*************************************************************************************"));
                    });
                    break;
                }
                case -2: {
                    COMPONENT_LOGGER.warn((Component)Component.text((String)"*** You are running an unknown version! Cannot fetch version info ***"));
                    break;
                }
                default: {
                    if (apiResult.isPresent()) {
                        COMPONENT_LOGGER.warn((Component)Component.text((String)("*** You are running an outdated version of Minecraft, which is " + apiResult.get().distance() + " release(s) and " + distance + " build(s) behind!")));
                        COMPONENT_LOGGER.warn((Component)Component.text((String)"*** Please update to the latest stable version on https://papermc.io/downloads/paper ***"));
                        break;
                    }
                    COMPONENT_LOGGER.info((Component)Component.text((String)("*** Currently you are " + distance + " build(s) behind ***")));
                    COMPONENT_LOGGER.info((Component)Component.text((String)"*** It is highly recommended to download the latest build from https://papermc.io/downloads/paper ***"));
                }
            }
        }
    }

    private static Component getUpdateStatusMessage() {
        int distance = -1;
        OptionalInt buildNumber = BUILD_INFO.buildNumber();
        if (buildNumber.isPresent()) {
            distance = PaperVersionFetcher.fetchDistanceFromSiteApi(buildNumber.getAsInt());
        } else {
            Optional gitBranch = BUILD_INFO.gitBranch();
            Optional gitCommit = BUILD_INFO.gitCommit();
            if (gitBranch.isPresent() && gitCommit.isPresent()) {
                distance = PaperVersionFetcher.fetchDistanceFromGitHub((String)gitBranch.get(), (String)gitCommit.get());
            }
        }
        return switch (distance) {
            case -1 -> Component.text((String)"Error obtaining version information", (TextColor)NamedTextColor.YELLOW);
            case 0 -> Component.text((String)"You are running the latest version", (TextColor)NamedTextColor.GREEN);
            case -2 -> Component.text((String)"Unknown version", (TextColor)NamedTextColor.YELLOW);
            default -> (TextComponent)((TextComponent)Component.text((String)("You are " + distance + " version(s) behind"), (TextColor)NamedTextColor.YELLOW).append((Component)Component.newline())).append(Component.text((String)"Download the new version at: ").append(((TextComponent)Component.text((String)DOWNLOAD_PAGE, (TextColor)NamedTextColor.GOLD).hoverEvent((HoverEventSource)Component.text((String)"Click to open", (TextColor)NamedTextColor.WHITE))).clickEvent(ClickEvent.openUrl((String)DOWNLOAD_PAGE))));
        };
    }

    /*
     * Exception decompiling
     */
    private static Optional<MinecraftVersionFetcher> fetchMinecraftVersionList() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 22[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static int fetchDistanceFromSiteApi(int jenkinsBuild) {
        int n2;
        URL buildsUrl = URI.create("https://fill.papermc.io/v3/projects/paper/versions/" + BUILD_INFO.minecraftVersionId() + "/builds").toURL();
        HttpURLConnection connection = (HttpURLConnection)buildsUrl.openConnection();
        connection.setConnectTimeout(5000);
        connection.setReadTimeout(5000);
        connection.setRequestProperty("User-Agent", USER_AGENT);
        connection.setRequestProperty("Accept", "application/json");
        BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
        try {
            JsonArray builds = (JsonArray)GSON.fromJson((Reader)reader, JsonArray.class);
            int latest = StreamSupport.stream(builds.spliterator(), false).mapToInt(build -> build.getAsJsonObject().get("id").getAsInt()).max().orElseThrow();
            n2 = Math.max(latest - jenkinsBuild, 0);
        }
        catch (Throwable throwable) {
            try {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (JsonSyntaxException ex) {
                    LOGGER.error("Error parsing json from Paper's downloads API", (Throwable)ex);
                    return -1;
                }
            }
            catch (IOException e2) {
                LOGGER.error("Error while parsing version", (Throwable)e2);
                return -1;
            }
        }
        reader.close();
        return n2;
    }

    private static int fetchDistanceFromGitHub(String branch, String hash) {
        int n2;
        HttpURLConnection connection = (HttpURLConnection)URI.create("https://api.github.com/repos/%s/compare/%s...%s".formatted(REPOSITORY, branch, hash)).toURL().openConnection();
        connection.setConnectTimeout(5000);
        connection.setReadTimeout(5000);
        connection.setRequestProperty("User-Agent", USER_AGENT);
        connection.connect();
        if (connection.getResponseCode() == 404) {
            return -2;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
        try {
            String status;
            JsonObject obj = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            n2 = switch (status = obj.get("status").getAsString()) {
                case "identical" -> 0;
                case "behind" -> obj.get("behind_by").getAsInt();
                default -> -1;
            };
        }
        catch (Throwable throwable) {
            try {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (JsonSyntaxException | NumberFormatException e2) {
                    LOGGER.error("Error parsing json from GitHub's API", e2);
                    return -1;
                }
            }
            catch (IOException e3) {
                LOGGER.error("Error while parsing version", (Throwable)e3);
                return -1;
            }
        }
        reader.close();
        return n2;
    }

    private @Nullable Component getHistory() {
        @Nullable VersionHistoryManager.VersionData data = VersionHistoryManager.INSTANCE.getVersionData();
        if (data == null) {
            return null;
        }
        @Nullable String oldVersion = data.getOldVersion();
        if (oldVersion == null) {
            return null;
        }
        return Component.text((String)("Previous version: " + oldVersion), (TextColor)NamedTextColor.GRAY, (TextDecoration[])new TextDecoration[]{TextDecoration.ITALIC});
    }

    private static /* synthetic */ Stream lambda$fetchMinecraftVersionList$1(JsonArray array) {
        return StreamSupport.stream(array.spliterator(), false);
    }

    private record MinecraftVersionFetcher(String latestVersion, int distance) {
    }
}

