/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.entity;

import com.destroystokyo.paper.entity.Pathfinder;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathPoint;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftLocation;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;

public class PaperPathfinder
implements Pathfinder {
    private EntityInsentient entity;

    public PaperPathfinder(EntityInsentient entity) {
        this.entity = entity;
    }

    public Mob getEntity() {
        return (Mob)this.entity.getBukkitEntity();
    }

    public void setHandle(EntityInsentient entity) {
        this.entity = entity;
    }

    public void stopPathfinding() {
        this.entity.N().n();
    }

    public boolean hasPath() {
        return this.entity.N().j() != null && !this.entity.N().j().c();
    }

    @Nullable
    public Pathfinder.PathResult getCurrentPath() {
        PathEntity path = this.entity.N().j();
        return path != null && !path.c() ? new PaperPathResult(path) : null;
    }

    @Nullable
    public Pathfinder.PathResult findPath(Location loc) {
        Preconditions.checkArgument((loc != null ? 1 : 0) != 0, (Object)"Location can not be null");
        PathEntity path = this.entity.N().a(loc.getX(), loc.getY(), loc.getZ(), 0);
        return path != null ? new PaperPathResult(path) : null;
    }

    @Nullable
    public Pathfinder.PathResult findPath(LivingEntity target) {
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"Target can not be null");
        PathEntity path = this.entity.N().a((Entity)((CraftLivingEntity)target).getHandle(), 0);
        return path != null ? new PaperPathResult(path) : null;
    }

    public boolean moveTo(@Nonnull Pathfinder.PathResult path, double speed) {
        Preconditions.checkArgument((path != null ? 1 : 0) != 0, (Object)"PathResult can not be null");
        PathEntity pathEntity = ((PaperPathResult)path).path;
        return this.entity.N().a(pathEntity, speed);
    }

    public boolean canOpenDoors() {
        return this.entity.N().v.d.e();
    }

    public void setCanOpenDoors(boolean canOpenDoors) {
        this.entity.N().v.d.b(canOpenDoors);
    }

    public boolean canPassDoors() {
        return this.entity.N().v.d.d();
    }

    public void setCanPassDoors(boolean canPassDoors) {
        this.entity.N().v.d.a(canPassDoors);
    }

    public boolean canFloat() {
        return this.entity.N().v.d.f();
    }

    public void setCanFloat(boolean canFloat) {
        this.entity.N().v.d.c(canFloat);
    }

    public class PaperPathResult
    implements Pathfinder.PathResult {
        private final PathEntity path;

        PaperPathResult(PathEntity path) {
            this.path = path;
        }

        @Nullable
        public Location getFinalPoint() {
            PathPoint point = this.path.d();
            return point != null ? CraftLocation.toBukkit(point, PaperPathfinder.this.entity.ao()) : null;
        }

        public boolean canReachFinalPoint() {
            return this.path.j();
        }

        public List<Location> getPoints() {
            ArrayList<Location> points = new ArrayList<Location>();
            for (PathPoint point : this.path.b) {
                points.add(CraftLocation.toBukkit(point, PaperPathfinder.this.entity.ao()));
            }
            return points;
        }

        public int getNextPointIndex() {
            return this.path.f();
        }

        @Nullable
        public Location getNextPoint() {
            if (this.path.c()) {
                return null;
            }
            return CraftLocation.toBukkit(this.path.b.get(this.path.f()), PaperPathfinder.this.entity.ao());
        }
    }
}

