/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.entity.ai;

import com.destroystokyo.paper.entity.RangedEntity;
import com.destroystokyo.paper.entity.ai.GoalKey;
import com.destroystokyo.paper.entity.ai.GoalType;
import com.google.common.base.CaseFormat;
import io.papermc.paper.entity.SchoolableFish;
import io.papermc.paper.util.MappingEnvironment;
import io.papermc.paper.util.ObfHelper;
import it.unimi.dsi.fastutil.ints.Int2BooleanFunction;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ambient.EntityAmbient;
import net.minecraft.world.entity.ambient.EntityBat;
import net.minecraft.world.entity.animal.AgeableWaterCreature;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.armadillo.Armadillo;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.animal.bee.EntityBee;
import net.minecraft.world.entity.animal.camel.CamelHusk;
import net.minecraft.world.entity.animal.chicken.EntityChicken;
import net.minecraft.world.entity.animal.cow.EntityCow;
import net.minecraft.world.entity.animal.cow.EntityMushroomCow;
import net.minecraft.world.entity.animal.dolphin.EntityDolphin;
import net.minecraft.world.entity.animal.equine.EntityHorse;
import net.minecraft.world.entity.animal.equine.EntityHorseAbstract;
import net.minecraft.world.entity.animal.equine.EntityHorseChestedAbstract;
import net.minecraft.world.entity.animal.equine.EntityHorseDonkey;
import net.minecraft.world.entity.animal.equine.EntityHorseMule;
import net.minecraft.world.entity.animal.equine.EntityHorseSkeleton;
import net.minecraft.world.entity.animal.equine.EntityHorseZombie;
import net.minecraft.world.entity.animal.equine.EntityLlama;
import net.minecraft.world.entity.animal.equine.EntityLlamaTrader;
import net.minecraft.world.entity.animal.feline.EntityCat;
import net.minecraft.world.entity.animal.feline.EntityOcelot;
import net.minecraft.world.entity.animal.fish.EntityCod;
import net.minecraft.world.entity.animal.fish.EntityFish;
import net.minecraft.world.entity.animal.fish.EntityFishSchool;
import net.minecraft.world.entity.animal.fish.EntityPufferFish;
import net.minecraft.world.entity.animal.fish.EntitySalmon;
import net.minecraft.world.entity.animal.fish.EntityTropicalFish;
import net.minecraft.world.entity.animal.fish.EntityWaterAnimal;
import net.minecraft.world.entity.animal.fox.EntityFox;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.animal.golem.EntityGolem;
import net.minecraft.world.entity.animal.golem.EntityIronGolem;
import net.minecraft.world.entity.animal.golem.EntitySnowman;
import net.minecraft.world.entity.animal.happyghast.HappyGhast;
import net.minecraft.world.entity.animal.nautilus.AbstractNautilus;
import net.minecraft.world.entity.animal.nautilus.Nautilus;
import net.minecraft.world.entity.animal.panda.EntityPanda;
import net.minecraft.world.entity.animal.parrot.EntityParrot;
import net.minecraft.world.entity.animal.parrot.EntityPerchable;
import net.minecraft.world.entity.animal.pig.EntityPig;
import net.minecraft.world.entity.animal.polarbear.EntityPolarBear;
import net.minecraft.world.entity.animal.rabbit.EntityRabbit;
import net.minecraft.world.entity.animal.sheep.EntitySheep;
import net.minecraft.world.entity.animal.squid.EntitySquid;
import net.minecraft.world.entity.animal.squid.GlowSquid;
import net.minecraft.world.entity.animal.turtle.EntityTurtle;
import net.minecraft.world.entity.animal.wolf.EntityWolf;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.boss.wither.EntityWither;
import net.minecraft.world.entity.monster.EntityBlaze;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.monster.EntityEnderman;
import net.minecraft.world.entity.monster.EntityEndermite;
import net.minecraft.world.entity.monster.EntityGhast;
import net.minecraft.world.entity.monster.EntityGiantZombie;
import net.minecraft.world.entity.monster.EntityGuardian;
import net.minecraft.world.entity.monster.EntityGuardianElder;
import net.minecraft.world.entity.monster.EntityMagmaCube;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.EntityMonsterPatrolling;
import net.minecraft.world.entity.monster.EntityPhantom;
import net.minecraft.world.entity.monster.EntityRavager;
import net.minecraft.world.entity.monster.EntityShulker;
import net.minecraft.world.entity.monster.EntitySilverfish;
import net.minecraft.world.entity.monster.EntitySlime;
import net.minecraft.world.entity.monster.EntityStrider;
import net.minecraft.world.entity.monster.EntityVex;
import net.minecraft.world.entity.monster.EntityWitch;
import net.minecraft.world.entity.monster.EntityZoglin;
import net.minecraft.world.entity.monster.IRangedEntity;
import net.minecraft.world.entity.monster.breeze.Breeze;
import net.minecraft.world.entity.monster.hoglin.EntityHoglin;
import net.minecraft.world.entity.monster.illager.EntityEvoker;
import net.minecraft.world.entity.monster.illager.EntityIllagerAbstract;
import net.minecraft.world.entity.monster.illager.EntityIllagerIllusioner;
import net.minecraft.world.entity.monster.illager.EntityIllagerWizard;
import net.minecraft.world.entity.monster.illager.EntityPillager;
import net.minecraft.world.entity.monster.illager.EntityVindicator;
import net.minecraft.world.entity.monster.piglin.EntityPiglin;
import net.minecraft.world.entity.monster.piglin.EntityPiglinAbstract;
import net.minecraft.world.entity.monster.piglin.EntityPiglinBrute;
import net.minecraft.world.entity.monster.skeleton.Bogged;
import net.minecraft.world.entity.monster.skeleton.EntitySkeleton;
import net.minecraft.world.entity.monster.skeleton.EntitySkeletonAbstract;
import net.minecraft.world.entity.monster.skeleton.EntitySkeletonStray;
import net.minecraft.world.entity.monster.skeleton.EntitySkeletonWither;
import net.minecraft.world.entity.monster.skeleton.Parched;
import net.minecraft.world.entity.monster.spider.EntityCaveSpider;
import net.minecraft.world.entity.monster.spider.EntitySpider;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.monster.zombie.EntityDrowned;
import net.minecraft.world.entity.monster.zombie.EntityPigZombie;
import net.minecraft.world.entity.monster.zombie.EntityZombie;
import net.minecraft.world.entity.monster.zombie.EntityZombieHusk;
import net.minecraft.world.entity.monster.zombie.EntityZombieVillager;
import net.minecraft.world.entity.npc.villager.EntityVillager;
import net.minecraft.world.entity.npc.villager.EntityVillagerAbstract;
import net.minecraft.world.entity.npc.wanderingtrader.EntityVillagerTrader;
import net.minecraft.world.entity.raid.EntityRaider;
import org.apache.commons.lang3.math.NumberUtils;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.AbstractCow;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.AbstractSkeleton;
import org.bukkit.entity.AbstractVillager;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Allay;
import org.bukkit.entity.Ambient;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Bat;
import org.bukkit.entity.Bee;
import org.bukkit.entity.Blaze;
import org.bukkit.entity.Camel;
import org.bukkit.entity.Cat;
import org.bukkit.entity.CaveSpider;
import org.bukkit.entity.ChestedHorse;
import org.bukkit.entity.Chicken;
import org.bukkit.entity.Cod;
import org.bukkit.entity.CopperGolem;
import org.bukkit.entity.Cow;
import org.bukkit.entity.Creaking;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Dolphin;
import org.bukkit.entity.Donkey;
import org.bukkit.entity.Drowned;
import org.bukkit.entity.ElderGuardian;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Endermite;
import org.bukkit.entity.Evoker;
import org.bukkit.entity.Fish;
import org.bukkit.entity.Fox;
import org.bukkit.entity.Ghast;
import org.bukkit.entity.Giant;
import org.bukkit.entity.Golem;
import org.bukkit.entity.Guardian;
import org.bukkit.entity.Hoglin;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Husk;
import org.bukkit.entity.Illager;
import org.bukkit.entity.Illusioner;
import org.bukkit.entity.IronGolem;
import org.bukkit.entity.Llama;
import org.bukkit.entity.MagmaCube;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Mule;
import org.bukkit.entity.MushroomCow;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Panda;
import org.bukkit.entity.Parrot;
import org.bukkit.entity.Phantom;
import org.bukkit.entity.Pig;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Piglin;
import org.bukkit.entity.PiglinAbstract;
import org.bukkit.entity.PiglinBrute;
import org.bukkit.entity.Pillager;
import org.bukkit.entity.PolarBear;
import org.bukkit.entity.PufferFish;
import org.bukkit.entity.Rabbit;
import org.bukkit.entity.Raider;
import org.bukkit.entity.Ravager;
import org.bukkit.entity.Salmon;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Shulker;
import org.bukkit.entity.Silverfish;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.SkeletonHorse;
import org.bukkit.entity.Slime;
import org.bukkit.entity.Sniffer;
import org.bukkit.entity.Snowman;
import org.bukkit.entity.Spellcaster;
import org.bukkit.entity.Spider;
import org.bukkit.entity.Squid;
import org.bukkit.entity.Stray;
import org.bukkit.entity.Strider;
import org.bukkit.entity.Tadpole;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.TraderLlama;
import org.bukkit.entity.TropicalFish;
import org.bukkit.entity.Turtle;
import org.bukkit.entity.Vex;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Vindicator;
import org.bukkit.entity.WanderingTrader;
import org.bukkit.entity.WaterMob;
import org.bukkit.entity.Witch;
import org.bukkit.entity.Wither;
import org.bukkit.entity.WitherSkeleton;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.Zoglin;
import org.bukkit.entity.Zombie;
import org.bukkit.entity.ZombieHorse;
import org.bukkit.entity.ZombieNautilus;
import org.bukkit.entity.ZombieVillager;

public class MobGoalHelper {
    private static final Map<Class<? extends PathfinderGoal>, Class<? extends Mob>> GENERIC_TYPE_CACHE = new HashMap<Class<? extends PathfinderGoal>, Class<? extends Mob>>();
    public static final Map<Class<? extends EntityInsentient>, Class<? extends Mob>> BUKKIT_BRIDGE = SystemUtils.a(new LinkedHashMap(), map -> {
        map.put(EntityInsentient.class, Mob.class);
        map.put(EntityAgeable.class, Ageable.class);
        map.put(EntityAmbient.class, Ambient.class);
        map.put(EntityAnimal.class, Animals.class);
        map.put(EntityBat.class, Bat.class);
        map.put(EntityBee.class, Bee.class);
        map.put(EntityBlaze.class, Blaze.class);
        map.put(EntityCat.class, Cat.class);
        map.put(EntityCaveSpider.class, CaveSpider.class);
        map.put(EntityChicken.class, Chicken.class);
        map.put(EntityCod.class, Cod.class);
        map.put(EntityCow.class, Cow.class);
        map.put(EntityCreature.class, Creature.class);
        map.put(EntityCreeper.class, Creeper.class);
        map.put(EntityDolphin.class, Dolphin.class);
        map.put(EntityDrowned.class, Drowned.class);
        map.put(EntityEnderDragon.class, EnderDragon.class);
        map.put(EntityEnderman.class, Enderman.class);
        map.put(EntityEndermite.class, Endermite.class);
        map.put(EntityEvoker.class, Evoker.class);
        map.put(EntityFish.class, Fish.class);
        map.put(EntityFishSchool.class, SchoolableFish.class);
        map.put(EntityFox.class, Fox.class);
        map.put(EntityGhast.class, Ghast.class);
        map.put(EntityGiantZombie.class, Giant.class);
        map.put(EntityGolem.class, Golem.class);
        map.put(EntityGuardian.class, Guardian.class);
        map.put(EntityGuardianElder.class, ElderGuardian.class);
        map.put(EntityHorse.class, Horse.class);
        map.put(EntityHorseAbstract.class, AbstractHorse.class);
        map.put(EntityHorseChestedAbstract.class, ChestedHorse.class);
        map.put(EntityHorseDonkey.class, Donkey.class);
        map.put(EntityHorseMule.class, Mule.class);
        map.put(EntityHorseSkeleton.class, SkeletonHorse.class);
        map.put(EntityHorseZombie.class, ZombieHorse.class);
        map.put(net.minecraft.world.entity.animal.camel.Camel.class, Camel.class);
        map.put(EntityIllagerAbstract.class, Illager.class);
        map.put(EntityIllagerIllusioner.class, Illusioner.class);
        map.put(EntityIllagerWizard.class, Spellcaster.class);
        map.put(EntityIronGolem.class, IronGolem.class);
        map.put(EntityLlama.class, Llama.class);
        map.put(EntityLlamaTrader.class, TraderLlama.class);
        map.put(EntityMagmaCube.class, MagmaCube.class);
        map.put(EntityMonster.class, Monster.class);
        map.put(EntityMonsterPatrolling.class, Raider.class);
        map.put(EntityMushroomCow.class, MushroomCow.class);
        map.put(EntityOcelot.class, Ocelot.class);
        map.put(EntityPanda.class, Panda.class);
        map.put(EntityParrot.class, Parrot.class);
        map.put(EntityPerchable.class, Parrot.class);
        map.put(EntityPhantom.class, Phantom.class);
        map.put(EntityPig.class, Pig.class);
        map.put(EntityPigZombie.class, PigZombie.class);
        map.put(EntityPillager.class, Pillager.class);
        map.put(EntityPolarBear.class, PolarBear.class);
        map.put(EntityPufferFish.class, PufferFish.class);
        map.put(EntityRabbit.class, Rabbit.class);
        map.put(EntityRaider.class, Raider.class);
        map.put(EntityRavager.class, Ravager.class);
        map.put(EntitySalmon.class, Salmon.class);
        map.put(EntitySheep.class, Sheep.class);
        map.put(EntityShulker.class, Shulker.class);
        map.put(EntitySilverfish.class, Silverfish.class);
        map.put(EntitySkeleton.class, Skeleton.class);
        map.put(EntitySkeletonAbstract.class, AbstractSkeleton.class);
        map.put(EntitySkeletonStray.class, Stray.class);
        map.put(EntitySkeletonWither.class, WitherSkeleton.class);
        map.put(EntitySlime.class, Slime.class);
        map.put(EntitySnowman.class, Snowman.class);
        map.put(EntitySpider.class, Spider.class);
        map.put(EntitySquid.class, Squid.class);
        map.put(EntityTameableAnimal.class, Tameable.class);
        map.put(EntityTropicalFish.class, TropicalFish.class);
        map.put(EntityTurtle.class, Turtle.class);
        map.put(EntityVex.class, Vex.class);
        map.put(EntityVillager.class, Villager.class);
        map.put(EntityVillagerAbstract.class, AbstractVillager.class);
        map.put(EntityVillagerTrader.class, WanderingTrader.class);
        map.put(EntityVindicator.class, Vindicator.class);
        map.put(EntityWaterAnimal.class, WaterMob.class);
        map.put(EntityWitch.class, Witch.class);
        map.put(EntityWither.class, Wither.class);
        map.put(EntityWolf.class, Wolf.class);
        map.put(EntityZombie.class, Zombie.class);
        map.put(EntityZombieHusk.class, Husk.class);
        map.put(EntityZombieVillager.class, ZombieVillager.class);
        map.put(EntityHoglin.class, Hoglin.class);
        map.put(EntityPiglin.class, Piglin.class);
        map.put(EntityPiglinAbstract.class, PiglinAbstract.class);
        map.put(EntityPiglinBrute.class, PiglinBrute.class);
        map.put(EntityStrider.class, Strider.class);
        map.put(EntityZoglin.class, Zoglin.class);
        map.put(GlowSquid.class, org.bukkit.entity.GlowSquid.class);
        map.put(Axolotl.class, org.bukkit.entity.Axolotl.class);
        map.put(Goat.class, org.bukkit.entity.Goat.class);
        map.put(Frog.class, org.bukkit.entity.Frog.class);
        map.put(net.minecraft.world.entity.animal.frog.Tadpole.class, Tadpole.class);
        map.put(Warden.class, org.bukkit.entity.Warden.class);
        map.put(net.minecraft.world.entity.animal.allay.Allay.class, Allay.class);
        map.put(net.minecraft.world.entity.animal.sniffer.Sniffer.class, Sniffer.class);
        map.put(Breeze.class, org.bukkit.entity.Breeze.class);
        map.put(Armadillo.class, org.bukkit.entity.Armadillo.class);
        map.put(Bogged.class, org.bukkit.entity.Bogged.class);
        map.put(net.minecraft.world.entity.monster.creaking.Creaking.class, Creaking.class);
        map.put(AgeableWaterCreature.class, Squid.class);
        map.put(net.minecraft.world.entity.animal.cow.AbstractCow.class, AbstractCow.class);
        map.put(HappyGhast.class, org.bukkit.entity.HappyGhast.class);
        map.put(net.minecraft.world.entity.animal.golem.CopperGolem.class, CopperGolem.class);
        map.put(AbstractNautilus.class, org.bukkit.entity.AbstractNautilus.class);
        map.put(Nautilus.class, org.bukkit.entity.Nautilus.class);
        map.put(net.minecraft.world.entity.animal.nautilus.ZombieNautilus.class, ZombieNautilus.class);
        map.put(CamelHusk.class, org.bukkit.entity.CamelHusk.class);
        map.put(Parched.class, org.bukkit.entity.Parched.class);
    });
    private static final Map<String, String> RENAMES = SystemUtils.a(new HashMap(), map -> {
        map.put("AbstractSkeleton$1", "AbstractSkeletonMelee");
        map.put("TraderLlama$TraderLlamaDefendWanderingTraderGoal", "TraderLlamaDefendWanderingTraderGoal");
        map.put("AbstractIllager$RaiderOpenDoorGoal", "RaiderOpenDoorGoal");
    });
    private static final Set<Class<? extends Mob>> NO_SPECIFIER = Set.of(Mob.class, Creature.class, Animals.class, RangedEntity.class, Tameable.class, Monster.class, PufferFish.class);
    private static final Int2BooleanFunction[] VISIBILITY_SEARCH_STEP = new Int2BooleanFunction[]{Modifier::isPublic, Modifier::isProtected, mod -> (mod & 7) == 0, Modifier::isPrivate};
    private static final Comparator<Constructor<?>> VISIBILITY_ORDER = Comparator.comparingInt(constructor -> {
        int mod = constructor.getModifiers();
        for (int i2 = 0; i2 < VISIBILITY_SEARCH_STEP.length; ++i2) {
            Int2BooleanFunction visibility = VISIBILITY_SEARCH_STEP[i2];
            if (!visibility.test(mod)) continue;
            return i2;
        }
        throw new UnsupportedOperationException("Unknown visibility: " + mod);
    });

    private static String getPathName(Class<? extends Mob> type, Class<?> holderClass, String name) {
        Object pathName = name.substring(name.lastIndexOf(46) + 1);
        boolean needRename = false;
        int firstInnerDelimiter = ((String)pathName).indexOf(36);
        if (firstInnerDelimiter != -1) {
            String innerClassNames = ((String)pathName).substring(firstInnerDelimiter + 1);
            for (String innerClassName : innerClassNames.split("\\$")) {
                if (!NumberUtils.isDigits((String)innerClassName)) continue;
                needRename = true;
                break;
            }
            if (!needRename && !RENAMES.containsKey(pathName)) {
                pathName = innerClassNames;
            }
        }
        if (!RENAMES.containsKey(pathName)) {
            if (needRename) {
                throw new IllegalStateException("need to map " + name + " (" + (String)pathName + ")");
            }
            String prefix = null;
            if (!NO_SPECIFIER.contains(type)) {
                prefix = type.getSimpleName();
            } else if (!EntityInsentient.class.isAssignableFrom(holderClass)) {
                prefix = holderClass.getSimpleName();
            }
            if (prefix != null && !((String)pathName).startsWith(prefix)) {
                pathName = prefix + (String)pathName;
            }
        } else {
            pathName = RENAMES.get(pathName);
        }
        pathName = ((String)pathName).replace("TargetGoal", "");
        pathName = ((String)pathName).replace("Goal", "");
        pathName = ((String)pathName).replace("Abstract", "");
        pathName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, (String)pathName);
        return pathName;
    }

    public static EnumSet<GoalType> vanillaToPaper(PathfinderGoal goal) {
        EnumSet<GoalType> goals = EnumSet.noneOf(GoalType.class);
        for (GoalType type : GoalType.values()) {
            if (!goal.hasFlag(MobGoalHelper.paperToVanilla(type))) continue;
            goals.add(type);
        }
        return goals;
    }

    public static GoalType vanillaToPaper(PathfinderGoal.Type type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case PathfinderGoal.Type.a -> GoalType.MOVE;
            case PathfinderGoal.Type.b -> GoalType.LOOK;
            case PathfinderGoal.Type.c -> GoalType.JUMP;
            case PathfinderGoal.Type.UNKNOWN_BEHAVIOR -> GoalType.UNKNOWN_BEHAVIOR;
            case PathfinderGoal.Type.d -> GoalType.TARGET;
        };
    }

    public static EnumSet<PathfinderGoal.Type> paperToVanilla(EnumSet<GoalType> types) {
        EnumSet<PathfinderGoal.Type> goals = EnumSet.noneOf(PathfinderGoal.Type.class);
        for (GoalType type : types) {
            goals.add(MobGoalHelper.paperToVanilla(type));
        }
        return goals;
    }

    public static PathfinderGoal.Type paperToVanilla(GoalType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case GoalType.MOVE -> PathfinderGoal.Type.a;
            case GoalType.LOOK -> PathfinderGoal.Type.b;
            case GoalType.JUMP -> PathfinderGoal.Type.c;
            case GoalType.UNKNOWN_BEHAVIOR -> PathfinderGoal.Type.UNKNOWN_BEHAVIOR;
            case GoalType.TARGET -> PathfinderGoal.Type.d;
        };
    }

    public static <T extends Mob> GoalKey<T> getKey(Class<? extends PathfinderGoal> goalClass) {
        Class<T> type = MobGoalHelper.getGenericType(goalClass);
        String name = goalClass.getName();
        if (MappingEnvironment.reobf()) {
            name = ObfHelper.INSTANCE.deobfClassName(name);
        }
        Class<?> holderClass = MobGoalHelper.getTopLevelClass(goalClass);
        name = MobGoalHelper.getPathName(type, holderClass, name);
        return GoalKey.of(type, (NamespacedKey)NamespacedKey.minecraft((String)name));
    }

    private static <T extends Mob> Class<T> getGenericType(Class<? extends PathfinderGoal> goalClass) {
        return GENERIC_TYPE_CACHE.computeIfAbsent(goalClass, key -> {
            Constructor<?>[] constructors = key.getDeclaredConstructors();
            Arrays.sort(constructors, VISIBILITY_ORDER);
            for (Constructor<?> constructor : constructors) {
                for (Class<?> paramType : constructor.getParameterTypes()) {
                    if (EntityInsentient.class.isAssignableFrom(paramType)) {
                        return MobGoalHelper.toBukkitClass(paramType);
                    }
                    if (!IRangedEntity.class.isAssignableFrom(paramType)) continue;
                    return RangedEntity.class;
                }
            }
            throw new RuntimeException("Can't figure out applicable entity for mob goal " + String.valueOf(goalClass));
        });
    }

    private static Class<?> getTopLevelClass(Class<?> clazz) {
        Class<?> topLevelClass = clazz;
        Class<?> upperClass = clazz;
        while ((upperClass = upperClass.getEnclosingClass()) != null) {
            topLevelClass = upperClass;
        }
        return topLevelClass;
    }

    public static Class<? extends Mob> toBukkitClass(Class<? extends EntityInsentient> internalClass) {
        Class<? extends Mob> bukkitClass = BUKKIT_BRIDGE.get(internalClass);
        if (bukkitClass == null) {
            throw new RuntimeException("Can't figure out applicable bukkit entity for internal entity " + String.valueOf(internalClass));
        }
        return bukkitClass;
    }
}

