/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.profile;

import com.destroystokyo.paper.event.profile.FillProfileEvent;
import com.destroystokyo.paper.event.profile.PreFillProfileEvent;
import com.destroystokyo.paper.profile.CraftPlayerProfile;
import com.destroystokyo.paper.profile.PlayerProfile;
import com.mojang.authlib.Environment;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.yggdrasil.ProfileResult;
import com.mojang.authlib.yggdrasil.ServicesKeySet;
import com.mojang.authlib.yggdrasil.YggdrasilMinecraftSessionService;
import java.net.Proxy;
import java.util.Collections;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;

public class PaperMinecraftSessionService
extends YggdrasilMinecraftSessionService {
    protected PaperMinecraftSessionService(ServicesKeySet servicesKeySet, Proxy proxy, Environment environment) {
        super(servicesKeySet, proxy, environment);
    }

    @Nullable
    public ProfileResult fetchProfile(GameProfile profile, boolean requireSecure) {
        CraftPlayerProfile playerProfile = (CraftPlayerProfile)CraftPlayerProfile.asBukkitCopy(profile);
        new PreFillProfileEvent((PlayerProfile)playerProfile).callEvent();
        profile = playerProfile.getGameProfile();
        if (profile.properties().containsKey((Object)"textures")) {
            return new ProfileResult(profile, Collections.emptySet());
        }
        ProfileResult result = super.fetchProfile(profile.id(), requireSecure);
        if (result != null) {
            FillProfileEvent event = new FillProfileEvent(CraftPlayerProfile.asBukkitCopy(result.profile()));
            event.callEvent();
            result = new ProfileResult(CraftPlayerProfile.asAuthlibCopy(event.getPlayerProfile()), result.actions());
        }
        return result;
    }

    @Deprecated
    @Nullable
    public ProfileResult fetchProfile(UUID profileId, boolean requireSecure) {
        return super.fetchProfile(profileId, requireSecure);
    }
}

