/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.math;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.math.MatrixUtil;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.SystemUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.jspecify.annotations.Nullable;

public final class Transformation {
    private final Matrix4fc c;
    public static final Codec<Transformation> a = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.e.fieldOf("translation").forGetter(transformation -> transformation.e), (App)ExtraCodecs.j.fieldOf("left_rotation").forGetter(transformation -> transformation.f), (App)ExtraCodecs.e.fieldOf("scale").forGetter(transformation -> transformation.g), (App)ExtraCodecs.j.fieldOf("right_rotation").forGetter(transformation -> transformation.h)).apply((Applicative)instance, Transformation::new));
    public static final Codec<Transformation> b = Codec.withAlternative(a, (Codec)ExtraCodecs.k.xmap(Transformation::new, Transformation::c));
    private boolean d;
    private @Nullable Vector3fc e;
    private @Nullable Quaternionfc f;
    private @Nullable Vector3fc g;
    private @Nullable Quaternionfc h;
    private static final Transformation i = SystemUtils.a(() -> {
        Transformation transformation = new Transformation((Matrix4fc)new Matrix4f());
        transformation.e = new Vector3f();
        transformation.f = new Quaternionf();
        transformation.g = new Vector3f(1.0f, 1.0f, 1.0f);
        transformation.h = new Quaternionf();
        transformation.d = true;
        return transformation;
    });

    public Transformation(@Nullable Matrix4fc matrix) {
        this.c = matrix == null ? new Matrix4f() : matrix;
    }

    public Transformation(@Nullable Vector3fc translation, @Nullable Quaternionfc leftRotation, @Nullable Vector3fc scale, @Nullable Quaternionfc rightRotation) {
        this.c = Transformation.a(translation, leftRotation, scale, rightRotation);
        this.e = translation != null ? translation : new Vector3f();
        this.f = leftRotation != null ? leftRotation : new Quaternionf();
        this.g = scale != null ? scale : new Vector3f(1.0f, 1.0f, 1.0f);
        this.h = rightRotation != null ? rightRotation : new Quaternionf();
        this.d = true;
    }

    public static Transformation a() {
        return i;
    }

    public Transformation a(Transformation other) {
        Matrix4f matrixCopy = this.d();
        matrixCopy.mul(other.c());
        return new Transformation((Matrix4fc)matrixCopy);
    }

    public @Nullable Transformation b() {
        if (this == i) {
            return this;
        }
        Matrix4f matrix4f = this.d().invertAffine();
        return matrix4f.isFinite() ? new Transformation((Matrix4fc)matrix4f) : null;
    }

    private void i() {
        if (!this.d) {
            float f2 = 1.0f / this.c.m33();
            Triple<Quaternionf, Vector3f, Quaternionf> triple = MatrixUtil.a(new Matrix3f(this.c).scale(f2));
            this.e = this.c.getTranslation(new Vector3f()).mul(f2);
            this.f = new Quaternionf((Quaternionfc)triple.getLeft());
            this.g = new Vector3f((Vector3fc)triple.getMiddle());
            this.h = new Quaternionf((Quaternionfc)triple.getRight());
            this.d = true;
        }
    }

    private static Matrix4f a(@Nullable Vector3fc translation, @Nullable Quaternionfc leftRotation, @Nullable Vector3fc scale, @Nullable Quaternionfc rightRotation) {
        Matrix4f matrix4f = new Matrix4f();
        if (translation != null) {
            matrix4f.translation(translation);
        }
        if (leftRotation != null) {
            matrix4f.rotate(leftRotation);
        }
        if (scale != null) {
            matrix4f.scale(scale);
        }
        if (rightRotation != null) {
            matrix4f.rotate(rightRotation);
        }
        return matrix4f;
    }

    public Matrix4fc c() {
        return this.c;
    }

    public Matrix4f d() {
        return new Matrix4f(this.c);
    }

    public Vector3fc e() {
        this.i();
        return this.e;
    }

    public Quaternionfc f() {
        this.i();
        return this.f;
    }

    public Vector3fc g() {
        this.i();
        return this.g;
    }

    public Quaternionfc h() {
        this.i();
        return this.h;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other != null && this.getClass() == other.getClass()) {
            Transformation transformation = (Transformation)other;
            return Objects.equals(this.c, transformation.c);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.c);
    }

    public Transformation a(Transformation transformation, float delta) {
        return new Transformation((Vector3fc)this.e().lerp(transformation.e(), delta, new Vector3f()), (Quaternionfc)this.f().slerp(transformation.f(), delta, new Quaternionf()), (Vector3fc)this.g().lerp(transformation.g(), delta, new Vector3f()), (Quaternionfc)this.h().slerp(transformation.h(), delta, new Quaternionf()));
    }
}

