/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper;

import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.plugin.entrypoint.classloader.group.PaperPluginClassLoaderStorage;
import io.papermc.paper.plugin.provider.classloader.ConfiguredPluginClassLoader;
import io.papermc.paper.plugin.provider.classloader.PaperClassLoaderStorage;
import io.papermc.paper.util.MCUtil;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import me.lucko.spark.paper.api.Compatibility;
import me.lucko.spark.paper.api.PaperClassLookup;
import me.lucko.spark.paper.api.PaperScheduler;
import me.lucko.spark.paper.api.PaperSparkModule;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextColor;
import net.minecraft.util.ExceptionSuppressor;
import org.bukkit.Server;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;

public final class SparksFly {
    public static final String ID = "spark";
    public static final String COMMAND_NAME = "spark";
    private static final String PREFER_SPARK_PLUGIN_PROPERTY = "paper.preferSparkPlugin";
    private static final int SPARK_YELLOW = 16763194;
    private final Logger logger;
    private final PaperSparkModule spark;
    private final ConcurrentLinkedQueue<Runnable> mainThreadTaskQueue = new ConcurrentLinkedQueue();
    private boolean enabled;
    private boolean disabledInConfigurationWarningLogged;

    public SparksFly(Server server) {
        this.logger = Logger.getLogger("spark");
        this.logger.log(Level.INFO, "This server bundles the spark profiler. For more information please visit https://docs.papermc.io/paper/profiling");
        this.spark = PaperSparkModule.create((Compatibility)Compatibility.VERSION_1_0, (Server)server, (Logger)this.logger, (PaperScheduler)new PaperScheduler(){

            public void executeAsync(Runnable runnable) {
                MCUtil.scheduleAsyncTask(this.catching(runnable, "asynchronous"));
            }

            public void executeSync(Runnable runnable) {
                SparksFly.this.mainThreadTaskQueue.offer(this.catching(runnable, "synchronous"));
            }

            private Runnable catching(Runnable runnable, String type) {
                return () -> {
                    try {
                        runnable.run();
                    }
                    catch (Throwable t2) {
                        SparksFly.this.logger.log(Level.SEVERE, "An exception was encountered while executing a " + type + " spark task", t2);
                    }
                };
            }
        }, (PaperClassLookup)new PaperClassLookup(this){

            public Class<?> lookup(String className) throws Exception {
                ExceptionSuppressor<ClassNotFoundException> exceptions = new ExceptionSuppressor<ClassNotFoundException>();
                try {
                    return Class.forName(className);
                }
                catch (ClassNotFoundException e2) {
                    exceptions.a(e2);
                    for (ConfiguredPluginClassLoader loader : ((PaperPluginClassLoaderStorage)PaperClassLoaderStorage.instance()).getGlobalGroup().getClassLoaders()) {
                        try {
                            Class loadedClass = loader.loadClass(className, true, false, true);
                            if (loadedClass == null) continue;
                            return loadedClass;
                        }
                        catch (ClassNotFoundException exception) {
                            exceptions.a(exception);
                        }
                    }
                    exceptions.a();
                    return null;
                }
            }
        });
    }

    public void executeMainThreadTasks() {
        Runnable task;
        while ((task = this.mainThreadTaskQueue.poll()) != null) {
            task.run();
        }
    }

    public void enableEarlyIfRequested() {
        if (!SparksFly.isPluginPreferred() && SparksFly.shouldEnableImmediately()) {
            this.enable();
        }
    }

    public void enableBeforePlugins() {
        if (!SparksFly.isPluginPreferred()) {
            this.enable();
        }
    }

    public void enableAfterPlugins(Server server) {
        boolean isPluginPreferred = SparksFly.isPluginPreferred();
        boolean isPluginEnabled = SparksFly.isPluginEnabled(server);
        if (!isPluginPreferred || !isPluginEnabled) {
            if (isPluginPreferred && !this.enabled) {
                this.logger.log(Level.INFO, "The spark plugin has been preferred but was not loaded. The bundled spark profiler will enabled instead.");
            }
            this.enable();
        }
    }

    private void enable() {
        if (!this.enabled) {
            if (GlobalConfiguration.get().spark.enabled) {
                this.enabled = true;
                this.spark.enable();
            } else if (!this.disabledInConfigurationWarningLogged) {
                this.logger.log(Level.INFO, "The spark profiler will not be enabled because it is currently disabled in the configuration.");
                this.disabledInConfigurationWarningLogged = true;
            }
        }
    }

    public void disable() {
        if (this.enabled) {
            this.spark.disable();
            this.enabled = false;
        }
    }

    public void registerCommandBeforePlugins(Server server) {
        if (!SparksFly.isPluginPreferred()) {
            this.registerCommand(server);
        }
    }

    public void registerCommandAfterPlugins(Server server) {
        if (!(SparksFly.isPluginPreferred() && SparksFly.isPluginEnabled(server) || server.getCommandMap().getCommand("spark") != null)) {
            this.registerCommand(server);
        }
    }

    private void registerCommand(Server server) {
        server.getCommandMap().register("spark", "paper", (Command)new CommandImpl("spark", this.spark.getPermissions()));
    }

    public void tickStart() {
        this.spark.onServerTickStart();
    }

    public void tickEnd(double duration) {
        this.spark.onServerTickEnd(duration);
    }

    void executeCommand(CommandSender sender, String[] args) {
        this.spark.executeCommand(sender, args);
    }

    List<String> tabComplete(CommandSender sender, String[] args) {
        return this.spark.tabComplete(sender, args);
    }

    public static boolean isPluginPreferred() {
        return Boolean.getBoolean(PREFER_SPARK_PLUGIN_PROPERTY);
    }

    private static boolean isPluginEnabled(Server server) {
        return server.getPluginManager().isPluginEnabled("spark");
    }

    private static boolean shouldEnableImmediately() {
        return GlobalConfiguration.get().spark.enableImmediately;
    }

    public static final class CommandImpl
    extends Command {
        CommandImpl(String name, Collection<String> permissions) {
            super(name);
            this.setPermission(String.join((CharSequence)";", permissions));
        }

        public boolean execute(CommandSender sender, String commandLabel, String[] args) {
            SparksFly spark = ((CraftServer)sender.getServer()).spark;
            if (spark.enabled) {
                spark.executeCommand(sender, args);
            } else {
                sender.sendMessage((Component)Component.text((String)"The spark profiler is currently disabled.", (TextColor)TextColor.color((int)16763194)));
            }
            return true;
        }

        public List<String> tabComplete(CommandSender sender, String alias, String[] args) throws IllegalArgumentException {
            SparksFly spark = ((CraftServer)sender.getServer()).spark;
            if (spark.enabled) {
                return spark.tabComplete(sender, args);
            }
            return List.of();
        }
    }
}

