/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.advancement;

import io.papermc.paper.advancement.AdvancementDisplay;
import io.papermc.paper.adventure.PaperAdventure;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementFrameType;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftNamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record PaperAdvancementDisplay(net.minecraft.advancements.AdvancementDisplay handle) implements AdvancementDisplay
{
    @NotNull
    public AdvancementDisplay.Frame frame() {
        return PaperAdvancementDisplay.asPaperFrame(this.handle.e());
    }

    @NotNull
    public Component title() {
        return PaperAdventure.asAdventure(this.handle.a());
    }

    @NotNull
    public Component description() {
        return PaperAdventure.asAdventure(this.handle.b());
    }

    @NotNull
    public ItemStack icon() {
        return CraftItemStack.asBukkitCopy(this.handle.c());
    }

    public boolean doesShowToast() {
        return this.handle.h();
    }

    public boolean doesAnnounceToChat() {
        return this.handle.i();
    }

    public boolean isHidden() {
        return this.handle.j();
    }

    @Nullable
    public NamespacedKey backgroundPath() {
        return this.handle.d().map(asset -> CraftNamespacedKey.fromMinecraft(asset.a())).orElse(null);
    }

    @NotNull
    public Component displayName() {
        return PaperAdventure.asAdventure(Advancement.a(Objects.requireNonNull(this.handle, "cannot build display name for null handle, invalid state")));
    }

    @NotNull
    public static AdvancementDisplay.Frame asPaperFrame(@NotNull AdvancementFrameType frameType) {
        return switch (frameType) {
            default -> throw new MatchException(null, null);
            case AdvancementFrameType.a -> AdvancementDisplay.Frame.TASK;
            case AdvancementFrameType.b -> AdvancementDisplay.Frame.CHALLENGE;
            case AdvancementFrameType.c -> AdvancementDisplay.Frame.GOAL;
        };
    }
}

