/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.antixray;

import io.papermc.paper.antixray.BitStorageReader;
import io.papermc.paper.antixray.BitStorageWriter;
import io.papermc.paper.antixray.ChunkPacketBlockController;
import io.papermc.paper.antixray.ChunkPacketInfo;
import io.papermc.paper.antixray.ChunkPacketInfoAntiXray;
import io.papermc.paper.configuration.WorldConfiguration;
import io.papermc.paper.configuration.type.EngineMode;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.IntSupplier;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.network.protocol.game.PacketPlayInBlockDig;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerInteractManager;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ITileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkEmpty;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.DataPalette;
import net.minecraft.world.level.chunk.DataPaletteExpandable;
import net.minecraft.world.level.chunk.DataPaletteGlobal;
import net.minecraft.world.level.chunk.MissingPaletteEntryException;
import org.bukkit.Bukkit;
import org.bukkit.World;

public final class ChunkPacketBlockControllerAntiXray
extends ChunkPacketBlockController {
    private static final DataPalette<IBlockData> GLOBAL_BLOCKSTATE_PALETTE = new DataPaletteGlobal<IBlockData>(Block.k);
    private static final ChunkSection EMPTY_SECTION = null;
    private final Executor executor;
    private final EngineMode engineMode;
    private final int maxBlockHeight;
    private final int updateRadius;
    private final boolean usePermission;
    private final IBlockData[] presetBlockStates;
    private final IBlockData[] presetBlockStatesFull;
    private final IBlockData[] presetBlockStatesStone;
    private final IBlockData[] presetBlockStatesDeepslate;
    private final IBlockData[] presetBlockStatesNetherrack;
    private final IBlockData[] presetBlockStatesEndStone;
    private final int[] presetBlockStateBitsGlobal;
    private final int[] presetBlockStateBitsStoneGlobal;
    private final int[] presetBlockStateBitsDeepslateGlobal;
    private final int[] presetBlockStateBitsNetherrackGlobal;
    private final int[] presetBlockStateBitsEndStoneGlobal;
    private final boolean[] solidGlobal = new boolean[Block.k.d()];
    private final boolean[] obfuscateGlobal = new boolean[Block.k.d()];
    private final ChunkSection[] emptyNearbyChunkSections = new ChunkSection[]{EMPTY_SECTION, EMPTY_SECTION, EMPTY_SECTION, EMPTY_SECTION};
    private final int maxBlockHeightUpdatePosition;
    private final ThreadLocal<int[]> presetBlockStateBits = ThreadLocal.withInitial(() -> new int[this.getPresetBlockStatesFullLength()]);
    private static final ThreadLocal<boolean[]> SOLID = ThreadLocal.withInitial(() -> new boolean[Block.k.d()]);
    private static final ThreadLocal<boolean[]> OBFUSCATE = ThreadLocal.withInitial(() -> new boolean[Block.k.d()]);
    private static final ThreadLocal<boolean[][]> CURRENT = ThreadLocal.withInitial(() -> new boolean[16][16]);
    private static final ThreadLocal<boolean[][]> NEXT = ThreadLocal.withInitial(() -> new boolean[16][16]);
    private static final ThreadLocal<boolean[][]> NEXT_NEXT = ThreadLocal.withInitial(() -> new boolean[16][16]);

    public ChunkPacketBlockControllerAntiXray(World level, Executor executor) {
        List<Block> toObfuscate;
        this.executor = executor;
        WorldConfiguration.Anticheat.AntiXray paperWorldConfig = level.paperConfig().anticheat.antiXray;
        this.engineMode = paperWorldConfig.engineMode;
        this.maxBlockHeight = paperWorldConfig.maxBlockHeight >> 4 << 4;
        this.updateRadius = paperWorldConfig.updateRadius;
        this.usePermission = paperWorldConfig.usePermission;
        if (this.engineMode == EngineMode.HIDE) {
            toObfuscate = paperWorldConfig.hiddenBlocks;
            this.presetBlockStates = null;
            this.presetBlockStatesFull = null;
            this.presetBlockStatesStone = new IBlockData[]{Blocks.b.m()};
            this.presetBlockStatesDeepslate = new IBlockData[]{Blocks.ui.m()};
            this.presetBlockStatesNetherrack = new IBlockData[]{Blocks.ey.m()};
            this.presetBlockStatesEndStone = new IBlockData[]{Blocks.go.m()};
            this.presetBlockStateBitsGlobal = null;
            this.presetBlockStateBitsStoneGlobal = new int[]{GLOBAL_BLOCKSTATE_PALETTE.a(Blocks.b.m(), DataPaletteExpandable.a())};
            this.presetBlockStateBitsDeepslateGlobal = new int[]{GLOBAL_BLOCKSTATE_PALETTE.a(Blocks.ui.m(), DataPaletteExpandable.a())};
            this.presetBlockStateBitsNetherrackGlobal = new int[]{GLOBAL_BLOCKSTATE_PALETTE.a(Blocks.ey.m(), DataPaletteExpandable.a())};
            this.presetBlockStateBitsEndStoneGlobal = new int[]{GLOBAL_BLOCKSTATE_PALETTE.a(Blocks.go.m(), DataPaletteExpandable.a())};
        } else {
            IBlockData[] iBlockDataArray;
            toObfuscate = new ArrayList<Block>(paperWorldConfig.replacementBlocks);
            LinkedList<IBlockData> presetBlockStateList = new LinkedList<IBlockData>();
            for (Block block : paperWorldConfig.hiddenBlocks) {
                if (block instanceof ITileEntity) continue;
                toObfuscate.add(block);
                presetBlockStateList.add(block.m());
            }
            LinkedHashSet<IBlockData> presetBlockStateSet = new LinkedHashSet<IBlockData>();
            presetBlockStateSet.addAll(presetBlockStateList);
            if (presetBlockStateSet.isEmpty()) {
                IBlockData[] iBlockDataArray2 = new IBlockData[1];
                v1 = iBlockDataArray2;
                iBlockDataArray2[0] = Blocks.cU.m();
            } else {
                v1 = this.presetBlockStates = presetBlockStateSet.toArray(new IBlockData[0]);
            }
            if (presetBlockStateSet.isEmpty()) {
                IBlockData[] iBlockDataArray3 = new IBlockData[1];
                iBlockDataArray = iBlockDataArray3;
                iBlockDataArray3[0] = Blocks.cU.m();
            } else {
                iBlockDataArray = presetBlockStateList.toArray(new IBlockData[0]);
            }
            this.presetBlockStatesFull = iBlockDataArray;
            this.presetBlockStatesStone = null;
            this.presetBlockStatesDeepslate = null;
            this.presetBlockStatesNetherrack = null;
            this.presetBlockStatesEndStone = null;
            this.presetBlockStateBitsGlobal = new int[this.presetBlockStatesFull.length];
            for (int i2 = 0; i2 < this.presetBlockStatesFull.length; ++i2) {
                this.presetBlockStateBitsGlobal[i2] = GLOBAL_BLOCKSTATE_PALETTE.a(this.presetBlockStatesFull[i2], DataPaletteExpandable.a());
            }
            this.presetBlockStateBitsStoneGlobal = null;
            this.presetBlockStateBitsDeepslateGlobal = null;
            this.presetBlockStateBitsNetherrackGlobal = null;
            this.presetBlockStateBitsEndStoneGlobal = null;
        }
        for (Block block : toObfuscate) {
            if (block == null || block.m().l()) continue;
            for (IBlockData blockState : block.l().a()) {
                this.obfuscateGlobal[ChunkPacketBlockControllerAntiXray.GLOBAL_BLOCKSTATE_PALETTE.a((IBlockData)blockState, DataPaletteExpandable.a())] = true;
            }
        }
        ChunkEmpty emptyChunk = new ChunkEmpty(level, new ChunkCoordIntPair(0, 0), MinecraftServer.getServer().bc().f(Registries.aS).b(Biomes.b));
        BlockPosition zeroPos = new BlockPosition(0, 0, 0);
        for (int i3 = 0; i3 < this.solidGlobal.length; ++i3) {
            IBlockData blockState;
            blockState = GLOBAL_BLOCKSTATE_PALETTE.a(i3);
            if (blockState == null) continue;
            this.solidGlobal[i3] = blockState.d(emptyChunk, zeroPos) && !blockState.a(Blocks.cP) && !blockState.a(Blocks.iO) && !blockState.a(Blocks.lL) && !blockState.a(Blocks.iN) && !blockState.a(Blocks.ag) || paperWorldConfig.lavaObscures && blockState == Blocks.K.m();
        }
        this.maxBlockHeightUpdatePosition = this.maxBlockHeight + this.updateRadius - 1;
    }

    private int getPresetBlockStatesFullLength() {
        return this.engineMode == EngineMode.HIDE ? 1 : this.presetBlockStatesFull.length;
    }

    @Override
    public IBlockData[] getPresetBlockStates(World level, ChunkCoordIntPair chunkPos, int chunkSectionY) {
        int bottomBlockY = chunkSectionY << 4;
        if (bottomBlockY < this.maxBlockHeight) {
            if (this.engineMode == EngineMode.HIDE) {
                return switch (level.getWorld().getEnvironment()) {
                    case World.Environment.NETHER -> this.presetBlockStatesNetherrack;
                    case World.Environment.THE_END -> this.presetBlockStatesEndStone;
                    default -> bottomBlockY < 0 ? this.presetBlockStatesDeepslate : this.presetBlockStatesStone;
                };
            }
            return this.presetBlockStates;
        }
        return null;
    }

    @Override
    public boolean shouldModify(EntityPlayer player, Chunk chunk) {
        return !this.usePermission || !player.getBukkitEntity().hasPermission("paper.antixray.bypass");
    }

    public ChunkPacketInfoAntiXray getChunkPacketInfo(ClientboundLevelChunkWithLightPacket chunkPacket, Chunk chunk) {
        return new ChunkPacketInfoAntiXray(chunkPacket, chunk, this);
    }

    @Override
    public void modifyBlocks(ClientboundLevelChunkWithLightPacket chunkPacket, ChunkPacketInfo<IBlockData> chunkPacketInfo) {
        if (!(chunkPacketInfo instanceof ChunkPacketInfoAntiXray)) {
            chunkPacket.setReady(true);
            return;
        }
        if (!Bukkit.isPrimaryThread()) {
            MinecraftServer.getServer().scheduleOnMain(() -> this.modifyBlocks(chunkPacket, chunkPacketInfo));
            return;
        }
        Chunk chunk = chunkPacketInfo.getChunk();
        int x2 = chunk.f().h;
        int z2 = chunk.f().i;
        World level = chunk.I();
        ((ChunkPacketInfoAntiXray)chunkPacketInfo).setNearbyChunks(level.getChunkIfLoaded(x2 - 1, z2), level.getChunkIfLoaded(x2 + 1, z2), level.getChunkIfLoaded(x2, z2 - 1), level.getChunkIfLoaded(x2, z2 + 1));
        this.executor.execute((Runnable)((Object)chunkPacketInfo));
    }

    public void obfuscate(ChunkPacketInfoAntiXray chunkPacketInfoAntiXray) {
        int[] presetBlockStateBits = this.presetBlockStateBits.get();
        boolean[] solid = SOLID.get();
        boolean[] obfuscate = OBFUSCATE.get();
        boolean[][] current = CURRENT.get();
        boolean[][] next = NEXT.get();
        boolean[][] nextNext = NEXT_NEXT.get();
        BitStorageReader bitStorageReader = new BitStorageReader();
        BitStorageWriter bitStorageWriter = new BitStorageWriter();
        ChunkSection[] nearbyChunkSections = new ChunkSection[4];
        Chunk chunk = chunkPacketInfoAntiXray.getChunk();
        World level = chunk.I();
        int maxChunkSectionIndex = Math.min((this.maxBlockHeight >> 4) - chunk.ay(), chunk.ax()) - 1;
        boolean[] solidTemp = null;
        boolean[] obfuscateTemp = null;
        bitStorageReader.setBuffer(chunkPacketInfoAntiXray.getBuffer());
        bitStorageWriter.setBuffer(chunkPacketInfoAntiXray.getBuffer());
        final int numberOfBlocks = presetBlockStateBits.length;
        LayeredIntSupplier random = numberOfBlocks == 1 ? () -> 0 : (this.engineMode == EngineMode.OBFUSCATE_LAYER ? new LayeredIntSupplier(){
            private int state;
            private int next;
            {
                while ((this.state = ThreadLocalRandom.current().nextInt()) == 0) {
                }
            }

            @Override
            public void nextLayer() {
                this.state ^= this.state << 13;
                this.state ^= this.state >>> 17;
                this.state ^= this.state << 5;
                this.next = (int)(Integer.toUnsignedLong(this.state) * (long)numberOfBlocks >>> 32);
            }

            @Override
            public int getAsInt() {
                return this.next;
            }
        } : new LayeredIntSupplier(){
            private int state;
            {
                while ((this.state = ThreadLocalRandom.current().nextInt()) == 0) {
                }
            }

            @Override
            public int getAsInt() {
                this.state ^= this.state << 13;
                this.state ^= this.state >>> 17;
                this.state ^= this.state << 5;
                return (int)(Integer.toUnsignedLong(this.state) * (long)numberOfBlocks >>> 32);
            }
        });
        for (int chunkSectionIndex = 0; chunkSectionIndex <= maxChunkSectionIndex; ++chunkSectionIndex) {
            int x2;
            int z2;
            int[] presetBlockStateBitsTemp;
            if (!chunkPacketInfoAntiXray.isWritten(chunkSectionIndex) || chunkPacketInfoAntiXray.getPresetValues(chunkSectionIndex) == null) continue;
            if (chunkPacketInfoAntiXray.getPalette(chunkSectionIndex) instanceof DataPaletteGlobal) {
                if (this.engineMode == EngineMode.HIDE) {
                    presetBlockStateBitsTemp = switch (level.getWorld().getEnvironment()) {
                        case World.Environment.NETHER -> this.presetBlockStateBitsNetherrackGlobal;
                        case World.Environment.THE_END -> this.presetBlockStateBitsEndStoneGlobal;
                        default -> chunkSectionIndex + chunk.ay() < 0 ? this.presetBlockStateBitsDeepslateGlobal : this.presetBlockStateBitsStoneGlobal;
                    };
                } else {
                    presetBlockStateBitsTemp = this.presetBlockStateBitsGlobal;
                }
            } else {
                IBlockData[] presetBlockStatesFull = chunkPacketInfoAntiXray.getPresetValues(chunkSectionIndex) == this.presetBlockStates ? this.presetBlockStatesFull : (IBlockData[])chunkPacketInfoAntiXray.getPresetValues(chunkSectionIndex);
                presetBlockStateBitsTemp = presetBlockStateBits;
                for (int i2 = 0; i2 < presetBlockStateBitsTemp.length; ++i2) {
                    presetBlockStateBitsTemp[i2] = chunkPacketInfoAntiXray.getPalette(chunkSectionIndex).a(presetBlockStatesFull[i2], DataPaletteExpandable.a());
                }
            }
            bitStorageWriter.setIndex(chunkPacketInfoAntiXray.getIndex(chunkSectionIndex));
            if (chunkSectionIndex == 0 || !chunkPacketInfoAntiXray.isWritten(chunkSectionIndex - 1) || chunkPacketInfoAntiXray.getPresetValues(chunkSectionIndex - 1) == null) {
                bitStorageReader.setBits(chunkPacketInfoAntiXray.getBits(chunkSectionIndex));
                bitStorageReader.setIndex(chunkPacketInfoAntiXray.getIndex(chunkSectionIndex));
                solidTemp = this.readPalette(chunkPacketInfoAntiXray.getPalette(chunkSectionIndex), solid, this.solidGlobal);
                obfuscateTemp = this.readPalette(chunkPacketInfoAntiXray.getPalette(chunkSectionIndex), obfuscate, this.obfuscateGlobal);
                ChunkSection belowChunkSection = null;
                boolean skipFirstLayer = chunkSectionIndex == 0 || (belowChunkSection = chunk.d()[chunkSectionIndex - 1]) == EMPTY_SECTION;
                for (z2 = 0; z2 < 16; ++z2) {
                    for (x2 = 0; x2 < 16; ++x2) {
                        current[z2][x2] = true;
                        next[z2][x2] = skipFirstLayer || this.isTransparent(belowChunkSection, x2, 15, z2);
                    }
                }
                bitStorageWriter.setBits(0);
                this.obfuscateLayer(-1, bitStorageReader, bitStorageWriter, solidTemp, obfuscateTemp, presetBlockStateBitsTemp, current, next, nextNext, this.emptyNearbyChunkSections, random);
            }
            bitStorageWriter.setBits(chunkPacketInfoAntiXray.getBits(chunkSectionIndex));
            nearbyChunkSections[0] = chunkPacketInfoAntiXray.getNearbyChunks()[0] == null ? EMPTY_SECTION : chunkPacketInfoAntiXray.getNearbyChunks()[0].d()[chunkSectionIndex];
            nearbyChunkSections[1] = chunkPacketInfoAntiXray.getNearbyChunks()[1] == null ? EMPTY_SECTION : chunkPacketInfoAntiXray.getNearbyChunks()[1].d()[chunkSectionIndex];
            nearbyChunkSections[2] = chunkPacketInfoAntiXray.getNearbyChunks()[2] == null ? EMPTY_SECTION : chunkPacketInfoAntiXray.getNearbyChunks()[2].d()[chunkSectionIndex];
            nearbyChunkSections[3] = chunkPacketInfoAntiXray.getNearbyChunks()[3] == null ? EMPTY_SECTION : chunkPacketInfoAntiXray.getNearbyChunks()[3].d()[chunkSectionIndex];
            for (int y2 = 0; y2 < 15; ++y2) {
                boolean[][] temp = current;
                current = next;
                next = nextNext;
                nextNext = temp;
                random.nextLayer();
                this.obfuscateLayer(y2, bitStorageReader, bitStorageWriter, solidTemp, obfuscateTemp, presetBlockStateBitsTemp, current, next, nextNext, nearbyChunkSections, random);
            }
            if (chunkSectionIndex == maxChunkSectionIndex || !chunkPacketInfoAntiXray.isWritten(chunkSectionIndex + 1) || chunkPacketInfoAntiXray.getPresetValues(chunkSectionIndex + 1) == null) {
                ChunkSection aboveChunkSection;
                if (chunkSectionIndex != chunk.ax() - 1 && (aboveChunkSection = chunk.d()[chunkSectionIndex + 1]) != EMPTY_SECTION) {
                    boolean[][] temp = current;
                    current = next;
                    next = nextNext;
                    nextNext = temp;
                    for (z2 = 0; z2 < 16; ++z2) {
                        for (x2 = 0; x2 < 16; ++x2) {
                            if (!this.isTransparent(aboveChunkSection, x2, 0, z2)) continue;
                            current[z2][x2] = true;
                        }
                    }
                    bitStorageReader.setBits(0);
                    solid[0] = true;
                    random.nextLayer();
                    this.obfuscateLayer(15, bitStorageReader, bitStorageWriter, solid, obfuscateTemp, presetBlockStateBitsTemp, current, next, nextNext, nearbyChunkSections, random);
                }
            } else {
                bitStorageReader.setBits(chunkPacketInfoAntiXray.getBits(chunkSectionIndex + 1));
                bitStorageReader.setIndex(chunkPacketInfoAntiXray.getIndex(chunkSectionIndex + 1));
                solidTemp = this.readPalette(chunkPacketInfoAntiXray.getPalette(chunkSectionIndex + 1), solid, this.solidGlobal);
                obfuscateTemp = this.readPalette(chunkPacketInfoAntiXray.getPalette(chunkSectionIndex + 1), obfuscate, this.obfuscateGlobal);
                boolean[][] temp = current;
                current = next;
                next = nextNext;
                nextNext = temp;
                random.nextLayer();
                this.obfuscateLayer(15, bitStorageReader, bitStorageWriter, solidTemp, obfuscateTemp, presetBlockStateBitsTemp, current, next, nextNext, nearbyChunkSections, random);
            }
            bitStorageWriter.flush();
        }
        chunkPacketInfoAntiXray.getChunkPacket().setReady(true);
    }

    private void obfuscateLayer(int y2, BitStorageReader bitStorageReader, BitStorageWriter bitStorageWriter, boolean[] solid, boolean[] obfuscate, int[] presetBlockStateBits, boolean[][] current, boolean[][] next, boolean[][] nextNext, ChunkSection[] nearbyChunkSections, IntSupplier random) {
        int x2;
        int bits = bitStorageReader.read();
        nextNext[0][0] = !solid[bits];
        if (nextNext[0][0]) {
            bitStorageWriter.skip();
            next[0][1] = true;
            next[1][0] = true;
        } else if (current[0][0] || this.isTransparent(nearbyChunkSections[2], 0, y2, 15) || this.isTransparent(nearbyChunkSections[0], 15, y2, 0)) {
            bitStorageWriter.skip();
        } else {
            bitStorageWriter.write(presetBlockStateBits[random.getAsInt()]);
        }
        if (!obfuscate[bits]) {
            next[0][0] = true;
        }
        for (x2 = 1; x2 < 15; ++x2) {
            bits = bitStorageReader.read();
            nextNext[0][x2] = !solid[bits];
            if (nextNext[0][x2]) {
                bitStorageWriter.skip();
                next[0][x2 - 1] = true;
                next[0][x2 + 1] = true;
                next[1][x2] = true;
            } else if (current[0][x2] || this.isTransparent(nearbyChunkSections[2], x2, y2, 15)) {
                bitStorageWriter.skip();
            } else {
                bitStorageWriter.write(presetBlockStateBits[random.getAsInt()]);
            }
            if (obfuscate[bits]) continue;
            next[0][x2] = true;
        }
        bits = bitStorageReader.read();
        nextNext[0][15] = !solid[bits];
        if (nextNext[0][15]) {
            bitStorageWriter.skip();
            next[0][14] = true;
            next[1][15] = true;
        } else if (current[0][15] || this.isTransparent(nearbyChunkSections[2], 15, y2, 15) || this.isTransparent(nearbyChunkSections[1], 0, y2, 0)) {
            bitStorageWriter.skip();
        } else {
            bitStorageWriter.write(presetBlockStateBits[random.getAsInt()]);
        }
        if (!obfuscate[bits]) {
            next[0][15] = true;
        }
        for (int z2 = 1; z2 < 15; ++z2) {
            bits = bitStorageReader.read();
            nextNext[z2][0] = !solid[bits];
            if (nextNext[z2][0]) {
                bitStorageWriter.skip();
                next[z2][1] = true;
                next[z2 - 1][0] = true;
                next[z2 + 1][0] = true;
            } else if (current[z2][0] || this.isTransparent(nearbyChunkSections[0], 15, y2, z2)) {
                bitStorageWriter.skip();
            } else {
                bitStorageWriter.write(presetBlockStateBits[random.getAsInt()]);
            }
            if (!obfuscate[bits]) {
                next[z2][0] = true;
            }
            for (int x3 = 1; x3 < 15; ++x3) {
                bits = bitStorageReader.read();
                nextNext[z2][x3] = !solid[bits];
                if (nextNext[z2][x3]) {
                    bitStorageWriter.skip();
                    next[z2][x3 - 1] = true;
                    next[z2][x3 + 1] = true;
                    next[z2 - 1][x3] = true;
                    next[z2 + 1][x3] = true;
                } else if (current[z2][x3]) {
                    bitStorageWriter.skip();
                } else {
                    bitStorageWriter.write(presetBlockStateBits[random.getAsInt()]);
                }
                if (obfuscate[bits]) continue;
                next[z2][x3] = true;
            }
            bits = bitStorageReader.read();
            nextNext[z2][15] = !solid[bits];
            if (nextNext[z2][15]) {
                bitStorageWriter.skip();
                next[z2][14] = true;
                next[z2 - 1][15] = true;
                next[z2 + 1][15] = true;
            } else if (current[z2][15] || this.isTransparent(nearbyChunkSections[1], 0, y2, z2)) {
                bitStorageWriter.skip();
            } else {
                bitStorageWriter.write(presetBlockStateBits[random.getAsInt()]);
            }
            if (obfuscate[bits]) continue;
            next[z2][15] = true;
        }
        bits = bitStorageReader.read();
        nextNext[15][0] = !solid[bits];
        if (nextNext[15][0]) {
            bitStorageWriter.skip();
            next[15][1] = true;
            next[14][0] = true;
        } else if (current[15][0] || this.isTransparent(nearbyChunkSections[3], 0, y2, 0) || this.isTransparent(nearbyChunkSections[0], 15, y2, 15)) {
            bitStorageWriter.skip();
        } else {
            bitStorageWriter.write(presetBlockStateBits[random.getAsInt()]);
        }
        if (!obfuscate[bits]) {
            next[15][0] = true;
        }
        for (x2 = 1; x2 < 15; ++x2) {
            bits = bitStorageReader.read();
            nextNext[15][x2] = !solid[bits];
            if (nextNext[15][x2]) {
                bitStorageWriter.skip();
                next[15][x2 - 1] = true;
                next[15][x2 + 1] = true;
                next[14][x2] = true;
            } else if (current[15][x2] || this.isTransparent(nearbyChunkSections[3], x2, y2, 0)) {
                bitStorageWriter.skip();
            } else {
                bitStorageWriter.write(presetBlockStateBits[random.getAsInt()]);
            }
            if (obfuscate[bits]) continue;
            next[15][x2] = true;
        }
        bits = bitStorageReader.read();
        nextNext[15][15] = !solid[bits];
        if (nextNext[15][15]) {
            bitStorageWriter.skip();
            next[15][14] = true;
            next[14][15] = true;
        } else if (current[15][15] || this.isTransparent(nearbyChunkSections[3], 15, y2, 0) || this.isTransparent(nearbyChunkSections[1], 0, y2, 15)) {
            bitStorageWriter.skip();
        } else {
            bitStorageWriter.write(presetBlockStateBits[random.getAsInt()]);
        }
        if (!obfuscate[bits]) {
            next[15][15] = true;
        }
    }

    private boolean isTransparent(ChunkSection chunkSection, int x2, int y2, int z2) {
        if (chunkSection == EMPTY_SECTION) {
            return true;
        }
        try {
            return !this.solidGlobal[GLOBAL_BLOCKSTATE_PALETTE.a(chunkSection.a(x2, y2, z2), DataPaletteExpandable.a())];
        }
        catch (MissingPaletteEntryException e2) {
            return true;
        }
    }

    private boolean[] readPalette(DataPalette<IBlockData> palette, boolean[] temp, boolean[] global) {
        if (palette instanceof DataPaletteGlobal) {
            return global;
        }
        try {
            for (int i2 = 0; i2 < palette.a(); ++i2) {
                temp[i2] = global[GLOBAL_BLOCKSTATE_PALETTE.a(palette.a(i2), DataPaletteExpandable.a())];
            }
        }
        catch (MissingPaletteEntryException missingPaletteEntryException) {
            // empty catch block
        }
        return temp;
    }

    @Override
    public void onBlockChange(World level, BlockPosition blockPos, IBlockData newBlockState, IBlockData oldBlockState, @Block.b int flags, int maxUpdateDepth) {
        if (oldBlockState != null && this.solidGlobal[GLOBAL_BLOCKSTATE_PALETTE.a(oldBlockState, DataPaletteExpandable.a())] && !this.solidGlobal[GLOBAL_BLOCKSTATE_PALETTE.a(newBlockState, DataPaletteExpandable.a())] && blockPos.v() <= this.maxBlockHeightUpdatePosition) {
            this.updateNearbyBlocks(level, blockPos);
        }
    }

    @Override
    public void onPlayerLeftClickBlock(PlayerInteractManager serverPlayerGameMode, BlockPosition blockPos, PacketPlayInBlockDig.EnumPlayerDigType action, EnumDirection direction, int worldHeight, int sequence) {
        if (blockPos.v() <= this.maxBlockHeightUpdatePosition) {
            this.updateNearbyBlocks(serverPlayerGameMode.c, blockPos);
        }
    }

    private void updateNearbyBlocks(World level, BlockPosition blockPos) {
        if (this.updateRadius >= 2) {
            BlockPosition temp = blockPos.h();
            this.updateBlock(level, temp);
            this.updateBlock(level, temp.h());
            this.updateBlock(level, temp.e());
            this.updateBlock(level, temp.d());
            this.updateBlock(level, temp.f());
            this.updateBlock(level, temp.g());
            temp = blockPos.i();
            this.updateBlock(level, temp);
            this.updateBlock(level, temp.i());
            this.updateBlock(level, temp.e());
            this.updateBlock(level, temp.d());
            this.updateBlock(level, temp.f());
            this.updateBlock(level, temp.g());
            temp = blockPos.e();
            this.updateBlock(level, temp);
            this.updateBlock(level, temp.e());
            this.updateBlock(level, temp.f());
            this.updateBlock(level, temp.g());
            temp = blockPos.d();
            this.updateBlock(level, temp);
            this.updateBlock(level, temp.d());
            this.updateBlock(level, temp.f());
            this.updateBlock(level, temp.g());
            temp = blockPos.f();
            this.updateBlock(level, temp);
            this.updateBlock(level, temp.f());
            temp = blockPos.g();
            this.updateBlock(level, temp);
            this.updateBlock(level, temp.g());
        } else if (this.updateRadius == 1) {
            this.updateBlock(level, blockPos.h());
            this.updateBlock(level, blockPos.i());
            this.updateBlock(level, blockPos.e());
            this.updateBlock(level, blockPos.d());
            this.updateBlock(level, blockPos.f());
            this.updateBlock(level, blockPos.g());
        }
    }

    private void updateBlock(World level, BlockPosition blockPos) {
        IBlockData blockState = level.getBlockStateIfLoaded(blockPos);
        if (blockState != null && this.obfuscateGlobal[GLOBAL_BLOCKSTATE_PALETTE.a(blockState, DataPaletteExpandable.a())]) {
            ((WorldServer)level).p().a(blockPos);
        }
    }

    @FunctionalInterface
    private static interface LayeredIntSupplier
    extends IntSupplier {
        default public void nextLayer() {
        }
    }
}

