/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.command;

import com.destroystokyo.paper.util.VersionFetcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.plugin.configuration.PluginMeta;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftMagicNumbers;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.StringUtil;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class PaperVersionCommand {
    public static final String DESCRIPTION = "Gets the version of this server including any plugins in use";
    private static final Component NOT_RUNNING = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)"This server is not running any plugin by that name."))).appendNewline()).append(Component.text((String)"Use /plugins to get a list of plugins.").clickEvent(ClickEvent.suggestCommand((String)"/plugins")))).build();
    private static final JoinConfiguration PLAYER_JOIN_CONFIGURATION = JoinConfiguration.separators((ComponentLike)Component.text((String)", ", (TextColor)NamedTextColor.WHITE), (ComponentLike)Component.text((String)", and ", (TextColor)NamedTextColor.WHITE));
    private static final Component FAILED_TO_FETCH = Component.text((String)"Could not fetch version information!", (TextColor)NamedTextColor.RED);
    private static final Component FETCHING = Component.text((String)"Checking version, please wait...", (TextColor)NamedTextColor.WHITE, (TextDecoration[])new TextDecoration[]{TextDecoration.ITALIC});
    private final VersionFetcher versionFetcher = CraftMagicNumbers.INSTANCE.getVersionFetcher();
    private CompletableFuture<ComputedVersion> computedVersion = CompletableFuture.completedFuture(new ComputedVersion((Component)Component.empty(), -1L));

    public static LiteralCommandNode<CommandSourceStack> create() {
        PaperVersionCommand command = new PaperVersionCommand();
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"version").requires(source -> source.getSender().hasPermission("bukkit.command.version"))).then(Commands.argument((String)"plugin", (ArgumentType)StringArgumentType.word()).suggests(command::suggestPlugins).executes(command::pluginVersion))).executes(command::serverVersion)).build();
    }

    private int pluginVersion(CommandContext<CommandSourceStack> context) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        String pluginName = ((String)context.getArgument("plugin", String.class)).toLowerCase(Locale.ROOT);
        Plugin plugin = Bukkit.getPluginManager().getPlugin(pluginName);
        if (plugin == null) {
            plugin = Arrays.stream(Bukkit.getPluginManager().getPlugins()).filter(checkPlugin -> checkPlugin.getName().toLowerCase(Locale.ROOT).contains(pluginName)).findAny().orElse(null);
        }
        if (plugin != null) {
            this.sendPluginInfo(plugin, sender);
        } else {
            sender.sendMessage(NOT_RUNNING);
        }
        return 1;
    }

    private CompletableFuture<Suggestions> suggestPlugins(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        for (Plugin plugin : Bukkit.getPluginManager().getPlugins()) {
            String name = plugin.getName();
            if (!StringUtil.startsWithIgnoreCase((String)name, (String)builder.getRemainingLowerCase())) continue;
            builder.suggest(name);
        }
        return CompletableFuture.completedFuture(builder.build());
    }

    private void sendPluginInfo(Plugin plugin, CommandSender sender) {
        PluginMeta meta = plugin.getPluginMeta();
        TextComponent.Builder builder = (TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text((String)meta.getName()))).append((Component)Component.text((String)" version "))).append(((TextComponent)Component.text((String)meta.getVersion(), (TextColor)NamedTextColor.GREEN).hoverEvent((HoverEventSource)Component.translatable((String)"chat.copy.click"))).clickEvent(ClickEvent.copyToClipboard((String)meta.getVersion())));
        if (meta.getDescription() != null) {
            ((TextComponent.Builder)builder.appendNewline()).append((Component)Component.text((String)meta.getDescription()));
        }
        if (meta.getWebsite() != null) {
            Component websiteComponent = Component.text((String)meta.getWebsite(), (TextColor)NamedTextColor.GREEN).clickEvent(ClickEvent.openUrl((String)meta.getWebsite()));
            ((TextComponent.Builder)builder.appendNewline()).append(Component.text((String)"Website: ").append(websiteComponent));
        }
        if (!meta.getAuthors().isEmpty()) {
            String prefix = meta.getAuthors().size() == 1 ? "Author: " : "Authors: ";
            ((TextComponent.Builder)builder.appendNewline()).append(Component.text((String)prefix).append(PaperVersionCommand.formatNameList(meta.getAuthors())));
        }
        if (!meta.getContributors().isEmpty()) {
            ((TextComponent.Builder)builder.appendNewline()).append(Component.text((String)"Contributors: ").append(PaperVersionCommand.formatNameList(meta.getContributors())));
        }
        sender.sendMessage((Component)builder.build());
    }

    private static Component formatNameList(List<String> names) {
        return Component.join((JoinConfiguration)PLAYER_JOIN_CONFIGURATION, names.stream().map(Component::text).toList()).color((TextColor)NamedTextColor.GREEN);
    }

    private int serverVersion(CommandContext<CommandSourceStack> context) {
        this.sendVersion(((CommandSourceStack)context.getSource()).getSender());
        return 1;
    }

    private void sendVersion(CommandSender sender) {
        CompletableFuture<ComputedVersion> version = this.getVersionOrFetch();
        if (!version.isDone()) {
            sender.sendMessage(FETCHING);
        }
        version.whenComplete((computedVersion, throwable) -> {
            if (computedVersion != null) {
                sender.sendMessage(computedVersion.message);
            } else if (throwable != null) {
                sender.sendMessage(FAILED_TO_FETCH);
                MinecraftServer.m.warn("Could not fetch version information!", throwable);
            }
        });
    }

    private CompletableFuture<ComputedVersion> getVersionOrFetch() {
        if (!this.computedVersion.isDone()) {
            return this.computedVersion;
        }
        if (this.computedVersion.isCompletedExceptionally() || System.currentTimeMillis() - this.computedVersion.resultNow().computedTime() > this.versionFetcher.getCacheTime()) {
            this.computedVersion = this.fetchVersionMessage();
        }
        return this.computedVersion;
    }

    private CompletableFuture<ComputedVersion> fetchVersionMessage() {
        return CompletableFuture.supplyAsync(() -> {
            TextComponent message = Component.textOfChildren((ComponentLike[])new ComponentLike[]{Component.text((String)Bukkit.getVersionMessage(), (TextColor)NamedTextColor.WHITE), Component.newline(), this.versionFetcher.getVersionMessage()});
            return new ComputedVersion(message.hoverEvent((HoverEventSource)Component.translatable((String)"chat.copy.click", (TextColor)NamedTextColor.WHITE)).clickEvent(ClickEvent.copyToClipboard((String)PlainTextComponentSerializer.plainText().serialize((Component)message))), System.currentTimeMillis());
        });
    }

    record ComputedVersion(Component message, long computedTime) {
    }
}

