/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.command.brigadier;

import com.destroystokyo.paper.brigadier.BukkitBrigadierCommandSource;
import com.google.common.base.Preconditions;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftEntity;
import org.bukkit.entity.Entity;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public interface PaperCommandSourceStack
extends CommandSourceStack,
BukkitBrigadierCommandSource {
    public CommandListenerWrapper getHandle();

    default public @NonNull Location getLocation() {
        Vec2F rot = this.getHandle().l();
        Vec3D pos = this.getHandle().e();
        WorldServer level = this.getHandle().f();
        return new Location((World)level.getWorld(), pos.g, pos.h, pos.i, rot.k, rot.j);
    }

    default public @NonNull CommandSender getSender() {
        return this.getHandle().getBukkitSender();
    }

    default public @Nullable Entity getExecutor() {
        net.minecraft.world.entity.Entity nmsEntity = this.getHandle().g();
        if (nmsEntity == null) {
            return null;
        }
        return nmsEntity.getBukkitEntity();
    }

    default public CommandSourceStack withExecutor(@NonNull Entity executor) {
        Preconditions.checkNotNull((Object)executor, (Object)"Executor cannot be null.");
        return this.getHandle().a(((CraftEntity)executor).getHandle());
    }

    default public Entity getBukkitEntity() {
        return this.getExecutor();
    }

    default public World getBukkitWorld() {
        return this.getLocation().getWorld();
    }

    default public Location getBukkitLocation() {
        return this.getLocation();
    }

    default public CommandSender getBukkitSender() {
        return this.getSender();
    }
}

