/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.command.subcommands;

import com.google.common.collect.ImmutableMap;
import io.papermc.paper.command.CommandUtil;
import io.papermc.paper.command.PaperSubcommand;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.ToIntFunction;
import net.kyori.adventure.text.BuildableComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.level.SpawnerCreature;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_21_R7.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftSpawnCategory;
import org.bukkit.entity.Player;
import org.bukkit.generator.WorldInfo;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.DefaultQualifier;

@DefaultQualifier(value=NonNull.class)
public final class MobcapsCommand
implements PaperSubcommand {
    static final Map<EnumCreatureType, TextColor> MOB_CATEGORY_COLORS = ImmutableMap.builder().put((Object)EnumCreatureType.a, (Object)NamedTextColor.RED).put((Object)EnumCreatureType.b, (Object)NamedTextColor.GREEN).put((Object)EnumCreatureType.c, (Object)NamedTextColor.GRAY).put((Object)EnumCreatureType.d, (Object)TextColor.color((int)7546111)).put((Object)EnumCreatureType.e, (Object)TextColor.color((int)3490278)).put((Object)EnumCreatureType.f, (Object)TextColor.color((int)28415)).put((Object)EnumCreatureType.g, (Object)TextColor.color((int)46079)).put((Object)EnumCreatureType.h, (Object)TextColor.color((int)0x636363)).build();

    @Override
    public boolean execute(CommandSender sender, String subCommand, String[] args) {
        switch (subCommand) {
            case "mobcaps": {
                this.printMobcaps(sender, args);
                break;
            }
            case "playermobcaps": {
                this.printPlayerMobcaps(sender, args);
            }
        }
        return true;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String subCommand, String[] args) {
        return switch (subCommand) {
            case "mobcaps" -> CommandUtil.getListMatchingLast(sender, args, this.suggestMobcaps(args));
            case "playermobcaps" -> CommandUtil.getListMatchingLast(sender, args, this.suggestPlayerMobcaps(sender, args));
            default -> throw new IllegalArgumentException();
        };
    }

    private List<String> suggestMobcaps(String[] args) {
        if (args.length == 1) {
            ArrayList<String> worlds = new ArrayList<String>(Bukkit.getWorlds().stream().map(WorldInfo::getName).toList());
            worlds.add("*");
            return worlds;
        }
        return Collections.emptyList();
    }

    private List<String> suggestPlayerMobcaps(CommandSender sender, String[] args) {
        if (args.length == 1) {
            ArrayList<String> list = new ArrayList<String>();
            for (Player player : Bukkit.getOnlinePlayers()) {
                Player senderPlayer;
                if (sender instanceof Player && !(senderPlayer = (Player)sender).canSee(player)) continue;
                list.add(player.getName());
            }
            return list;
        }
        return Collections.emptyList();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void printMobcaps(CommandSender sender, String[] args) {
        World world;
        List<World> worlds;
        if (args.length == 0) {
            if (!(sender instanceof Player)) {
                sender.sendMessage((Component)Component.text((String)"Must specify a world! ex: '/paper mobcaps world'", (TextColor)NamedTextColor.RED));
                return;
            }
            Player player = (Player)sender;
            worlds = List.of(player.getWorld());
        } else {
            if (args.length != 1) {
                sender.sendMessage((Component)Component.text((String)"Too many arguments!", (TextColor)NamedTextColor.RED));
                return;
            }
            String input = args[0];
            if (input.equals("*")) {
                worlds = Bukkit.getWorlds();
            } else {
                world = Bukkit.getWorld((String)input);
                if (world == null) {
                    sender.sendMessage((Component)Component.text((String)("'" + input + "' is not a valid world!"), (TextColor)NamedTextColor.RED));
                    return;
                }
                worlds = List.of(world);
            }
        }
        Iterator<World> iterator = worlds.iterator();
        while (iterator.hasNext()) {
            world = iterator.next();
            WorldServer level = ((CraftWorld)world).getHandle();
            @Nullable SpawnerCreature.d state = level.p().p();
            int chunks = state == null ? 0 : state.a();
            sender.sendMessage(Component.join((JoinConfiguration)JoinConfiguration.noSeparators(), (ComponentLike[])new ComponentLike[]{Component.text((String)"Mobcaps for world: "), Component.text((String)world.getName(), (TextColor)NamedTextColor.AQUA), Component.text((String)(" (" + chunks + " spawnable chunks)"))}));
            sender.sendMessage(MobcapsCommand.createMobcapsComponent(category -> {
                if (state == null) {
                    return 0;
                }
                return state.b().getOrDefault(category, 0);
            }, category -> SpawnerCreature.globalLimitForCategory(level, category, chunks)));
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void printPlayerMobcaps(CommandSender sender, String[] args) {
        Player player;
        if (args.length == 0) {
            Player pl;
            if (!(sender instanceof Player)) {
                sender.sendMessage((Component)Component.text((String)"Must specify a player! ex: '/paper playermobcount playerName'", (TextColor)NamedTextColor.RED));
                return;
            }
            player = pl = (Player)sender;
        } else {
            if (args.length != 1) {
                sender.sendMessage((Component)Component.text((String)"Too many arguments!", (TextColor)NamedTextColor.RED));
                return;
            }
            String input = args[0];
            player = Bukkit.getPlayerExact((String)input);
            if (player == null) {
                sender.sendMessage((Component)Component.text((String)("Could not find player named '" + input + "'"), (TextColor)NamedTextColor.RED));
                return;
            }
        }
        EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        WorldServer level = serverPlayer.A();
        if (!level.paperConfig().entities.spawning.perPlayerMobSpawns) {
            sender.sendMessage((Component)Component.text((String)"Use '/paper mobcaps' for worlds where per-player mob spawning is disabled.", (TextColor)NamedTextColor.RED));
            return;
        }
        sender.sendMessage(Component.join((JoinConfiguration)JoinConfiguration.noSeparators(), (ComponentLike[])new ComponentLike[]{Component.text((String)"Mobcaps for player: "), Component.text((String)player.getName(), (TextColor)NamedTextColor.GREEN)}));
        sender.sendMessage(MobcapsCommand.createMobcapsComponent(category -> level.G.a.getMobCountNear(serverPlayer, (EnumCreatureType)category), category -> level.getWorld().getSpawnLimitUnsafe(CraftSpawnCategory.toBukkit(category))));
    }

    private static Component createMobcapsComponent(ToIntFunction<EnumCreatureType> countGetter, ToIntFunction<EnumCreatureType> limitGetter) {
        return (Component)MOB_CATEGORY_COLORS.entrySet().stream().map(entry -> {
            EnumCreatureType category = (EnumCreatureType)entry.getKey();
            TextColor color = (TextColor)entry.getValue();
            Component categoryHover = Component.join((JoinConfiguration)JoinConfiguration.noSeparators(), (ComponentLike[])new ComponentLike[]{Component.text((String)"Entity types in category ", (TextColor)TextColor.color((int)0xE0E0E0)), Component.text((String)category.a(), (TextColor)color), Component.text((char)':', (TextColor)NamedTextColor.GRAY), Component.newline(), Component.newline(), (ComponentLike)BuiltInRegistries.g.k().stream().filter(it -> ((EntityTypes)it.getValue()).f() == category).map(it -> Component.translatable((String)((EntityTypes)it.getValue()).g())).collect(Component.toComponent((Component)Component.text((String)", ", (TextColor)NamedTextColor.GRAY)))});
            BuildableComponent categoryComponent = ((TextComponent.Builder)((TextComponent.Builder)Component.text().content("  " + category.a()).color(color)).hoverEvent((HoverEventSource)categoryHover)).build();
            TextComponent.Builder builder = (TextComponent.Builder)Component.text().append(new Component[]{categoryComponent, Component.text((String)": ", (TextColor)NamedTextColor.GRAY)});
            int limit = limitGetter.applyAsInt(category);
            if (limit != -1) {
                builder.append(new Component[]{Component.text((int)countGetter.applyAsInt(category)), Component.text((String)"/", (TextColor)NamedTextColor.GRAY), Component.text((int)limit)});
            } else {
                builder.append(((TextComponent.Builder)Component.text().append(new Component[]{Component.text((char)'n'), Component.text((String)"/", (TextColor)NamedTextColor.GRAY), Component.text((char)'a')})).hoverEvent((HoverEventSource)Component.text((String)"This category does not naturally spawn.")));
            }
            return builder;
        }).map(ComponentLike::asComponent).collect(Component.toComponent((Component)Component.newline()));
    }
}

