/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.commands;

import io.papermc.paper.adventure.PaperAdventure;
import java.util.function.Consumer;
import net.kyori.adventure.audience.MessageType;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICommandListener;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.permissions.LevelBasedPermissionSet;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_21_R7.CraftServer;
import org.bukkit.craftbukkit.v1_21_R7.command.ServerCommandSender;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.DefaultQualifier;

@DefaultQualifier(value=NonNull.class)
public final class FeedbackForwardingSender
extends ServerCommandSender {
    private final Consumer<? super Component> feedback;
    private final CraftServer server;

    public FeedbackForwardingSender(Consumer<? super Component> feedback, CraftServer server) {
        super(((ServerCommandSender)server.getConsoleSender()).perm);
        this.server = server;
        this.feedback = feedback;
    }

    public void sendMessage(String message) {
        this.sendMessage((Component)LegacyComponentSerializer.legacySection().deserialize(message));
    }

    public void sendMessage(String ... messages) {
        for (String message : messages) {
            this.sendMessage(message);
        }
    }

    public void sendMessage(Identity identity, Component message, MessageType type) {
        this.feedback.accept((Component)message);
    }

    public String getName() {
        return "FeedbackForwardingSender";
    }

    public Component name() {
        return Component.text((String)this.getName());
    }

    public boolean isOp() {
        return true;
    }

    public void setOp(boolean value) {
        throw new UnsupportedOperationException("Cannot change operator status of " + this.getClass().getName());
    }

    public CommandListenerWrapper asVanilla() {
        @Nullable WorldServer respawnDimension = this.server.getServer().aH();
        return new CommandListenerWrapper(new Source(this), respawnDimension == null ? Vec3D.c : Vec3D.a(respawnDimension.C().b()), Vec2F.a, respawnDimension, LevelBasedPermissionSet.e, this.getName(), IChatBaseComponent.b(this.getName()), this.server.getServer(), null);
    }

    private record Source(FeedbackForwardingSender sender) implements ICommandListener
    {
        @Override
        public void a(IChatBaseComponent message) {
            this.sender.sendMessage(Identity.nil(), PaperAdventure.asAdventure(message));
        }

        @Override
        public boolean x_() {
            return true;
        }

        @Override
        public boolean y_() {
            return true;
        }

        @Override
        public boolean c() {
            return false;
        }

        @Override
        public CommandSender getBukkitSender(CommandListenerWrapper stack) {
            return this.sender;
        }
    }
}

