/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.configuration.serializer;

import com.mojang.logging.LogUtils;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.geantyref.TypeToken;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.spongepowered.configurate.serialize.ScalarSerializer;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.util.EnumLookup;

public class EnumValueSerializer
extends ScalarSerializer.Annotated<Enum<?>> {
    private static final Logger LOGGER = LogUtils.getClassLogger();

    public EnumValueSerializer() {
        super(new TypeToken<Enum<?>>(){});
    }

    public @Nullable Enum<?> deserialize(AnnotatedType annotatedType, Object obj) throws SerializationException {
        String enumConstant = obj.toString();
        Class<Enum> typeClass = GenericTypeReflector.erase((Type)annotatedType.getType()).asSubclass(Enum.class);
        Enum ret = EnumLookup.lookupEnum(typeClass, (String)enumConstant);
        if (ret == null) {
            ret = EnumLookup.lookupEnum(typeClass, (String)enumConstant.replace("-", "_"));
        }
        if (ret == null) {
            boolean longer = typeClass.getEnumConstants().length > 10;
            List<String> options = Arrays.stream(typeClass.getEnumConstants()).limit(10L).map(Enum::name).toList();
            LOGGER.error("Invalid enum constant provided, expected one of [{}{}], but got {}", new Object[]{String.join((CharSequence)", ", options), longer ? ", ..." : "", enumConstant});
        }
        return ret;
    }

    public Object serialize(AnnotatedType type, Enum<?> item, Predicate<Class<?>> typeSupported) {
        return item.name();
    }
}

