/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.configuration.transformation.global;

import com.mojang.logging.LogUtils;
import java.util.function.Predicate;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.network.protocol.game.PacketPlayInAutoRecipe;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.YamlConfiguration;
import org.slf4j.Logger;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.NodePath;
import org.spongepowered.configurate.transformation.ConfigurationTransformation;
import org.spongepowered.configurate.transformation.TransformAction;

public final class LegacyPaperConfig {
    private static final Logger LOGGER = LogUtils.getClassLogger();

    private LegacyPaperConfig() {
    }

    public static ConfigurationTransformation transformation(YamlConfiguration spigotConfiguration) {
        return ConfigurationTransformation.chain((ConfigurationTransformation[])new ConfigurationTransformation[]{LegacyPaperConfig.versioned(), LegacyPaperConfig.notVersioned(spigotConfiguration)});
    }

    private static ConfigurationTransformation.Versioned versioned() {
        return ConfigurationTransformation.versionedBuilder().versionKey(new Object[]{"config-version"}).addVersion(11, ConfigurationTransformation.builder().addAction(NodePath.path((Object[])new Object[]{"settings", "play-in-use-item-spam-threshold"}), TransformAction.rename((Object)"incoming-packet-spam-threshold")).build()).addVersion(14, ConfigurationTransformation.builder().addAction(NodePath.path((Object[])new Object[]{"settings", "spam-limiter", "tab-spam-increment"}), (path, value) -> {
            if (value.getInt() == 10) {
                value.set((Object)2);
            }
            return null;
        }).build()).addVersion(15, ConfigurationTransformation.builder().addAction(NodePath.path((Object[])new Object[]{"settings"}), (path, value) -> {
            value.node(new Object[]{"async-chunks", "threads"}).set((Object)-1);
            return null;
        }).build()).addVersion(21, ConfigurationTransformation.builder().addAction(NodePath.path((Object[])new Object[]{"use-display-name-in-quit-message"}), (path, value) -> new Object[]{"settings", "use-display-name-in-quit-message"}).build()).addVersion(23, ConfigurationTransformation.builder().addAction(NodePath.path((Object[])new Object[]{"settings", "chunk-loading", "global-max-chunk-load-rate"}), (path, value) -> {
            if (value.getDouble() == 300.0) {
                value.set((Object)-1.0);
            }
            return null;
        }).build()).addVersion(25, ConfigurationTransformation.builder().addAction(NodePath.path((Object[])new Object[]{"settings", "chunk-loading", "player-max-concurrent-loads"}), (path, value) -> {
            if (value.getDouble() == 4.0) {
                value.set((Object)20.0);
            }
            return null;
        }).build()).build();
    }

    private static ConfigurationTransformation notVersioned(YamlConfiguration spigotConfiguration) {
        return ConfigurationTransformation.builder().addAction(NodePath.path((Object[])new Object[]{"settings"}), (path, value) -> {
            ConfigurationNode node = value.node(new Object[]{"async-chunks"});
            if (node.hasChild(new Object[]{"load-threads"})) {
                if (!node.hasChild(new Object[]{"threads"})) {
                    node.node(new Object[]{"threads"}).set((Object)node.node(new Object[]{"load-threads"}).getInt());
                }
                node.removeChild((Object)"load-threads");
            }
            node.removeChild((Object)"generation");
            node.removeChild((Object)"enabled");
            node.removeChild((Object)"thread-per-world-generation");
            return null;
        }).addAction(NodePath.path((Object[])new Object[]{"allow-perm-block-break-exploits"}), (path, value) -> new Object[]{"settings", "unsupported-settings", "allow-permanent-block-break-exploits"}).addAction(NodePath.path((Object[])new Object[]{"settings", "unsupported-settings", "allow-tnt-duplication"}), TransformAction.rename((Object)"allow-piston-duplication")).addAction(NodePath.path((Object[])new Object[]{"settings", "save-player-data"}), (path, value) -> {
            Object val = value.raw();
            if (val instanceof Boolean) {
                Boolean bool = (Boolean)val;
                spigotConfiguration.set("players.disable-saving", (Object)(bool == false ? 1 : 0));
            }
            value.raw(null);
            return null;
        }).addAction(NodePath.path((Object[])new Object[]{"settings", "log-named-entity-deaths"}), (path, value) -> {
            Boolean bool;
            Object val = value.raw();
            if (val instanceof Boolean && !(bool = (Boolean)val).booleanValue()) {
                spigotConfiguration.set("settings.log-named-deaths", (Object)false);
            }
            value.raw(null);
            return null;
        }).build();
    }

    public static ConfigurationTransformation toNewFormat() {
        return ConfigurationTransformation.chain((ConfigurationTransformation[])new ConfigurationTransformation[]{ConfigurationTransformation.versionedBuilder().versionKey(new Object[]{"config-version"}).addVersion(28, LegacyPaperConfig.newFormatTransformation()).build(), ConfigurationTransformation.builder().addAction(NodePath.path((Object[])new Object[]{"config-version"}), TransformAction.rename((Object)"_version")).build()});
    }

    private static ConfigurationTransformation newFormatTransformation() {
        ConfigurationTransformation.Builder builder = ConfigurationTransformation.builder().addAction(NodePath.path((Object[])new Object[]{"verbose"}), TransformAction.remove()).addAction(NodePath.path((Object[])new Object[]{"unsupported-settings", "allow-headless-pistons-readme"}), TransformAction.remove()).addAction(NodePath.path((Object[])new Object[]{"unsupported-settings", "allow-permanent-block-break-exploits-readme"}), TransformAction.remove()).addAction(NodePath.path((Object[])new Object[]{"unsupported-settings", "allow-piston-duplication-readme"}), TransformAction.remove()).addAction(NodePath.path((Object[])new Object[]{"packet-limiter", "limits", "all"}), (path, value) -> new Object[]{"packet-limiter", "all-packets"}).addAction(NodePath.path((Object[])new Object[]{"packet-limiter", "limits"}), (path, value) -> new Object[]{"packet-limiter", "overrides"}).addAction(NodePath.path((Object[])new Object[]{"packet-limiter", "overrides", ConfigurationTransformation.WILDCARD_OBJECT}), (path, value) -> {
            Object keyValue = value.key();
            if (keyValue != null && keyValue.toString().equals("PacketPlayInAutoRecipe")) {
                return path.with(path.size() - 1, (Object)PacketPlayInAutoRecipe.class.getSimpleName()).array();
            }
            return null;
        }).addAction(NodePath.path((Object[])new Object[]{"loggers"}), TransformAction.rename((Object)"logging"));
        LegacyPaperConfig.moveFromRootAndRename(builder, "incoming-packet-spam-threshold", "incoming-packet-threshold", "spam-limiter");
        LegacyPaperConfig.moveFromRoot(builder, "save-empty-scoreboard-teams", "scoreboards");
        LegacyPaperConfig.moveFromRoot(builder, "track-plugin-scoreboards", "scoreboards");
        LegacyPaperConfig.moveFromRoot(builder, "suggest-player-names-when-null-tab-completions", "commands");
        LegacyPaperConfig.moveFromRoot(builder, "time-command-affects-all-worlds", "commands");
        LegacyPaperConfig.moveFromRoot(builder, "fix-target-selector-tag-completion", "commands");
        LegacyPaperConfig.moveFromRoot(builder, "log-player-ip-addresses", "loggers");
        LegacyPaperConfig.moveFromRoot(builder, "use-display-name-in-quit-message", "messages");
        LegacyPaperConfig.moveFromRootAndRename(builder, "console-has-all-permissions", "has-all-permissions", "console");
        LegacyPaperConfig.moveFromRootAndRename(builder, "bungee-online-mode", "online-mode", "proxies", "bungee-cord");
        LegacyPaperConfig.moveFromRootAndRename(builder, "velocity-support", "velocity", "proxies");
        LegacyPaperConfig.moveFromRoot(builder, "book-size", "item-validation");
        LegacyPaperConfig.moveFromRoot(builder, "resolve-selectors-in-books", "item-validation");
        LegacyPaperConfig.moveFromRoot(builder, "enable-player-collisions", "collisions");
        LegacyPaperConfig.moveFromRoot(builder, "send-full-pos-for-hard-colliding-entities", "collisions");
        LegacyPaperConfig.moveFromRootAndRename(builder, "player-auto-save-rate", "rate", "player-auto-save");
        LegacyPaperConfig.moveFromRootAndRename(builder, "max-player-auto-save-per-tick", "max-per-tick", "player-auto-save");
        LegacyPaperConfig.moveFromRootToMisc(builder, "max-joins-per-tick");
        LegacyPaperConfig.moveFromRootToMisc(builder, "fix-entity-position-desync");
        LegacyPaperConfig.moveFromRootToMisc(builder, "load-permissions-yml-before-plugins");
        LegacyPaperConfig.moveFromRootToMisc(builder, "region-file-cache-size");
        LegacyPaperConfig.moveFromRootToMisc(builder, "use-alternative-luck-formula");
        LegacyPaperConfig.moveFromRootToMisc(builder, "lag-compensate-block-breaking");
        LegacyPaperConfig.moveFromRootToMisc(builder, "use-dimension-type-for-custom-spawners");
        LegacyPaperConfig.moveFromRoot(builder, "proxy-protocol", "proxies");
        LegacyPaperConfig.miniMessageWithTranslatable(builder, String::isBlank, "multiplayer.disconnect.authservers_down", "messages", "kick", "authentication-servers-down");
        LegacyPaperConfig.miniMessageWithTranslatable(builder, Predicate.isEqual("Flying is not enabled on this server"), "multiplayer.disconnect.flying", "messages", "kick", "flying-player");
        LegacyPaperConfig.miniMessageWithTranslatable(builder, Predicate.isEqual("Flying is not enabled on this server"), "multiplayer.disconnect.flying", "messages", "kick", "flying-vehicle");
        LegacyPaperConfig.miniMessage(builder, "messages", "kick", "connection-throttle");
        LegacyPaperConfig.miniMessage(builder, "messages", "no-permission");
        LegacyPaperConfig.miniMessageWithTranslatable(builder, Predicate.isEqual("&cSent too many packets"), (Component)Component.translatable((String)"disconnect.exceeded_packet_rate", (TextColor)NamedTextColor.RED), "packet-limiter", "kick-message");
        return builder.build();
    }

    private static void miniMessageWithTranslatable(ConfigurationTransformation.Builder builder, Predicate<String> englishCheck, String i18nKey, String ... strPath) {
        LegacyPaperConfig.miniMessageWithTranslatable(builder, englishCheck, (Component)Component.translatable((String)i18nKey), strPath);
    }

    private static void miniMessageWithTranslatable(ConfigurationTransformation.Builder builder, Predicate<String> englishCheck, Component component, String ... strPath) {
        builder.addAction(NodePath.path((Object[])strPath), (path, value) -> {
            String strVal;
            Object val = value.raw();
            if (val != null && !englishCheck.test(strVal = val.toString())) {
                value.set((Object)LegacyPaperConfig.miniMessage(strVal));
                return null;
            }
            value.set(MiniMessage.miniMessage().serialize(component));
            return null;
        });
    }

    private static void miniMessage(ConfigurationTransformation.Builder builder, String ... strPath) {
        builder.addAction(NodePath.path((Object[])strPath), (path, value) -> {
            Object val = value.raw();
            if (val != null) {
                value.set((Object)LegacyPaperConfig.miniMessage(val.toString()));
            }
            return null;
        });
    }

    private static String miniMessage(String input) {
        return (String)MiniMessage.miniMessage().serialize((Component)LegacyComponentSerializer.legacySection().deserialize(ChatColor.translateAlternateColorCodes((char)'&', (String)input)));
    }

    private static void moveFromRootToMisc(ConfigurationTransformation.Builder builder, String key) {
        LegacyPaperConfig.moveFromRoot(builder, key, "misc");
    }

    private static void moveFromRoot(ConfigurationTransformation.Builder builder, String key, String ... parents) {
        LegacyPaperConfig.moveFromRootAndRename(builder, key, key, parents);
    }

    private static void moveFromRootAndRename(ConfigurationTransformation.Builder builder, String oldKey, String newKey, String ... parents) {
        builder.addAction(NodePath.path((Object[])new Object[]{oldKey}), (path, value) -> {
            Object[] newPath = new Object[parents.length + 1];
            newPath[parents.length] = newKey;
            System.arraycopy(parents, 0, newPath, 0, parents.length);
            return newPath;
        });
    }
}

