/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.datacomponent;

import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.datacomponent.DataComponentAdapter;
import io.papermc.paper.datacomponent.item.PaperAttackRange;
import io.papermc.paper.datacomponent.item.PaperBannerPatternLayers;
import io.papermc.paper.datacomponent.item.PaperBlockItemDataProperties;
import io.papermc.paper.datacomponent.item.PaperBlocksAttacks;
import io.papermc.paper.datacomponent.item.PaperBundleContents;
import io.papermc.paper.datacomponent.item.PaperChargedProjectiles;
import io.papermc.paper.datacomponent.item.PaperConsumable;
import io.papermc.paper.datacomponent.item.PaperCustomModelData;
import io.papermc.paper.datacomponent.item.PaperDamageResistant;
import io.papermc.paper.datacomponent.item.PaperDeathProtection;
import io.papermc.paper.datacomponent.item.PaperDyedItemColor;
import io.papermc.paper.datacomponent.item.PaperEnchantable;
import io.papermc.paper.datacomponent.item.PaperEquippable;
import io.papermc.paper.datacomponent.item.PaperFireworks;
import io.papermc.paper.datacomponent.item.PaperFoodProperties;
import io.papermc.paper.datacomponent.item.PaperItemAdventurePredicate;
import io.papermc.paper.datacomponent.item.PaperItemArmorTrim;
import io.papermc.paper.datacomponent.item.PaperItemAttributeModifiers;
import io.papermc.paper.datacomponent.item.PaperItemContainerContents;
import io.papermc.paper.datacomponent.item.PaperItemEnchantments;
import io.papermc.paper.datacomponent.item.PaperItemLore;
import io.papermc.paper.datacomponent.item.PaperItemTool;
import io.papermc.paper.datacomponent.item.PaperJukeboxPlayable;
import io.papermc.paper.datacomponent.item.PaperKineticWeapon;
import io.papermc.paper.datacomponent.item.PaperLodestoneTracker;
import io.papermc.paper.datacomponent.item.PaperMapDecorations;
import io.papermc.paper.datacomponent.item.PaperMapId;
import io.papermc.paper.datacomponent.item.PaperMapItemColor;
import io.papermc.paper.datacomponent.item.PaperOminousBottleAmplifier;
import io.papermc.paper.datacomponent.item.PaperPiercingWeapon;
import io.papermc.paper.datacomponent.item.PaperPotDecorations;
import io.papermc.paper.datacomponent.item.PaperPotionContents;
import io.papermc.paper.datacomponent.item.PaperRepairable;
import io.papermc.paper.datacomponent.item.PaperResolvableProfile;
import io.papermc.paper.datacomponent.item.PaperSeededContainerLoot;
import io.papermc.paper.datacomponent.item.PaperSuspiciousStewEffects;
import io.papermc.paper.datacomponent.item.PaperSwingAnimation;
import io.papermc.paper.datacomponent.item.PaperTooltipDisplay;
import io.papermc.paper.datacomponent.item.PaperUseCooldown;
import io.papermc.paper.datacomponent.item.PaperUseEffects;
import io.papermc.paper.datacomponent.item.PaperUseRemainder;
import io.papermc.paper.datacomponent.item.PaperWeapon;
import io.papermc.paper.datacomponent.item.PaperWritableBookContent;
import io.papermc.paper.datacomponent.item.PaperWrittenBookContent;
import io.papermc.paper.item.MapPostProcessing;
import io.papermc.paper.registry.PaperRegistries;
import io.papermc.paper.util.MCUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.Unit;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.animal.chicken.ChickenVariant;
import net.minecraft.world.entity.animal.cow.EntityMushroomCow;
import net.minecraft.world.entity.animal.equine.EntityLlama;
import net.minecraft.world.entity.animal.equine.HorseColor;
import net.minecraft.world.entity.animal.fish.EntitySalmon;
import net.minecraft.world.entity.animal.fish.EntityTropicalFish;
import net.minecraft.world.entity.animal.fox.EntityFox;
import net.minecraft.world.entity.animal.nautilus.ZombieNautilusVariant;
import net.minecraft.world.entity.animal.parrot.EntityParrot;
import net.minecraft.world.entity.animal.rabbit.EntityRabbit;
import net.minecraft.world.item.EitherHolder;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.EnumItemRarity;
import net.minecraft.world.item.component.InstrumentComponent;
import net.minecraft.world.item.component.ProvidesTrimMaterial;
import org.bukkit.DyeColor;
import org.bukkit.craftbukkit.v1_21_R7.CraftArt;
import org.bukkit.craftbukkit.v1_21_R7.CraftMusicInstrument;
import org.bukkit.craftbukkit.v1_21_R7.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R7.damage.CraftDamageType;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftCat;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftChicken;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftCow;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftFrog;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftPig;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftVillager;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftWolf;
import org.bukkit.craftbukkit.v1_21_R7.entity.CraftZombieNautilus;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftMetaFirework;
import org.bukkit.craftbukkit.v1_21_R7.inventory.trim.CraftTrimMaterial;
import org.bukkit.craftbukkit.v1_21_R7.util.Handleable;
import org.bukkit.entity.Axolotl;
import org.bukkit.entity.Fox;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Llama;
import org.bukkit.entity.MushroomCow;
import org.bukkit.entity.Parrot;
import org.bukkit.entity.Rabbit;
import org.bukkit.entity.Salmon;
import org.bukkit.entity.TropicalFish;
import org.bukkit.inventory.ItemRarity;

public final class DataComponentAdapters {
    static final Function<Unit, Void> UNIT_TO_API_CONVERTER = $ -> {
        throw new UnsupportedOperationException("Cannot convert the Unit type to an API value");
    };
    static final Function UNIMPLEMENTED_TO_API_CONVERTER = $ -> {
        throw new UnsupportedOperationException("Cannot convert the an unimplemented type to an API value");
    };
    static final Map<ResourceKey<DataComponentType<?>>, DataComponentAdapter<?, ?>> ADAPTERS = new HashMap();

    public static void bootstrap() {
        DataComponentAdapters.registerIdentity(DataComponents.c);
        DataComponentAdapters.registerIdentity(DataComponents.d);
        DataComponentAdapters.registerIdentity(DataComponents.e);
        DataComponentAdapters.registerUntyped(DataComponents.f);
        DataComponentAdapters.register(DataComponents.g, PaperUseEffects::new);
        DataComponentAdapters.registerIdentity(DataComponents.Z);
        DataComponentAdapters.register(DataComponents.h, PaperAdventure::asAdventure, PaperAdventure::asVanilla);
        DataComponentAdapters.registerIdentity(DataComponents.i);
        DataComponentAdapters.register(DataComponents.j, nms -> CraftDamageType.minecraftHolderToBukkit(nms.a(CraftRegistry.getMinecraftRegistry()).orElseThrow()), api -> new EitherHolder<DamageType>(CraftDamageType.bukkitToMinecraftHolder(api)));
        DataComponentAdapters.register(DataComponents.k, PaperAdventure::asAdventure, PaperAdventure::asVanilla);
        DataComponentAdapters.register(DataComponents.l, PaperAdventure::asAdventure, PaperAdventure::asVanilla);
        DataComponentAdapters.register(DataComponents.m, PaperItemLore::new);
        DataComponentAdapters.register(DataComponents.n, nms -> ItemRarity.valueOf((String)nms.name()), api -> EnumItemRarity.valueOf(api.name()));
        DataComponentAdapters.register(DataComponents.o, PaperItemEnchantments::new);
        DataComponentAdapters.register(DataComponents.p, PaperItemAdventurePredicate::new);
        DataComponentAdapters.register(DataComponents.q, PaperItemAdventurePredicate::new);
        DataComponentAdapters.register(DataComponents.r, PaperItemAttributeModifiers::new);
        DataComponentAdapters.register(DataComponents.s, PaperCustomModelData::new);
        DataComponentAdapters.registerIdentity(DataComponents.u);
        DataComponentAdapters.registerIdentity(DataComponents.w);
        DataComponentAdapters.registerUntyped(DataComponents.x);
        DataComponentAdapters.register(DataComponents.y, PaperFoodProperties::new);
        DataComponentAdapters.register(DataComponents.z, PaperConsumable::new);
        DataComponentAdapters.register(DataComponents.A, PaperUseRemainder::new);
        DataComponentAdapters.register(DataComponents.B, PaperUseCooldown::new);
        DataComponentAdapters.register(DataComponents.C, PaperDamageResistant::new);
        DataComponentAdapters.register(DataComponents.D, PaperItemTool::new);
        DataComponentAdapters.register(DataComponents.G, PaperEnchantable::new);
        DataComponentAdapters.register(DataComponents.H, PaperEquippable::new);
        DataComponentAdapters.register(DataComponents.I, PaperRepairable::new);
        DataComponentAdapters.registerUntyped(DataComponents.J);
        DataComponentAdapters.register(DataComponents.K, PaperAdventure::asAdventure, PaperAdventure::asVanilla);
        DataComponentAdapters.register(DataComponents.L, PaperDeathProtection::new);
        DataComponentAdapters.register(DataComponents.Q, PaperItemEnchantments::new);
        DataComponentAdapters.register(DataComponents.R, PaperDyedItemColor::new);
        DataComponentAdapters.register(DataComponents.S, PaperMapItemColor::new);
        DataComponentAdapters.register(DataComponents.T, PaperMapId::new);
        DataComponentAdapters.register(DataComponents.U, PaperMapDecorations::new);
        DataComponentAdapters.register(DataComponents.V, nms -> MapPostProcessing.valueOf((String)nms.name()), api -> net.minecraft.world.item.component.MapPostProcessing.valueOf(api.name()));
        DataComponentAdapters.register(DataComponents.W, PaperChargedProjectiles::new);
        DataComponentAdapters.register(DataComponents.X, PaperBundleContents::new);
        DataComponentAdapters.register(DataComponents.Y, PaperPotionContents::new);
        DataComponentAdapters.register(DataComponents.aa, PaperSuspiciousStewEffects::new);
        DataComponentAdapters.register(DataComponents.ac, PaperWrittenBookContent::new);
        DataComponentAdapters.register(DataComponents.ab, PaperWritableBookContent::new);
        DataComponentAdapters.register(DataComponents.ad, PaperItemArmorTrim::new);
        DataComponentAdapters.register(DataComponents.ai, nms -> CraftMusicInstrument.minecraftHolderToBukkit(nms.a().a(CraftRegistry.getMinecraftRegistry()).orElseThrow()), api -> new InstrumentComponent(CraftMusicInstrument.bukkitToMinecraftHolder(api)));
        DataComponentAdapters.register(DataComponents.aj, nms -> CraftTrimMaterial.minecraftHolderToBukkit(nms.a().a(CraftRegistry.getMinecraftRegistry()).orElseThrow()), api -> new ProvidesTrimMaterial(CraftTrimMaterial.bukkitToMinecraftHolder(api)));
        DataComponentAdapters.register(DataComponents.ak, PaperOminousBottleAmplifier::new);
        DataComponentAdapters.register(DataComponents.al, PaperJukeboxPlayable::new);
        DataComponentAdapters.register(DataComponents.am, PaperRegistries::fromNms, PaperRegistries::toNms);
        DataComponentAdapters.register(DataComponents.an, nms -> MCUtil.transformUnmodifiable(nms, PaperAdventure::asAdventureKey), api -> MCUtil.transformUnmodifiable(api, key -> PaperAdventure.asVanilla(Registries.bK, key)));
        DataComponentAdapters.register(DataComponents.ao, PaperLodestoneTracker::new);
        DataComponentAdapters.register(DataComponents.ap, CraftMetaFirework::getEffect, CraftMetaFirework::getExplosion);
        DataComponentAdapters.register(DataComponents.aq, PaperFireworks::new);
        DataComponentAdapters.register(DataComponents.ar, PaperResolvableProfile::new);
        DataComponentAdapters.register(DataComponents.as, PaperAdventure::asAdventure, PaperAdventure::asVanilla);
        DataComponentAdapters.register(DataComponents.at, PaperBannerPatternLayers::new);
        DataComponentAdapters.register(DataComponents.au, nms -> DyeColor.getByWoolData((byte)((byte)nms.a())), api -> EnumColor.a(api.getWoolData()));
        DataComponentAdapters.register(DataComponents.av, PaperPotDecorations::new);
        DataComponentAdapters.register(DataComponents.aw, PaperItemContainerContents::new);
        DataComponentAdapters.register(DataComponents.ax, PaperBlockItemDataProperties::new);
        DataComponentAdapters.register(DataComponents.aA, PaperSeededContainerLoot::new);
        DataComponentAdapters.register(DataComponents.aB, nms -> PaperAdventure.asAdventure(((SoundEffect)nms.a()).a()), PaperAdventure::resolveSound);
        DataComponentAdapters.register(DataComponents.t, PaperTooltipDisplay::new);
        DataComponentAdapters.register(DataComponents.E, PaperWeapon::new);
        DataComponentAdapters.register(DataComponents.M, PaperBlocksAttacks::new);
        DataComponentAdapters.register(DataComponents.N, PaperPiercingWeapon::new);
        DataComponentAdapters.register(DataComponents.O, PaperKineticWeapon::new);
        DataComponentAdapters.register(DataComponents.F, PaperAttackRange::new);
        DataComponentAdapters.register(DataComponents.P, PaperSwingAnimation::new);
        DataComponentAdapters.register(DataComponents.aC, CraftVillager.CraftType::minecraftHolderToBukkit, CraftVillager.CraftType::bukkitToMinecraftHolder);
        DataComponentAdapters.register(DataComponents.aD, CraftWolf.CraftVariant::minecraftHolderToBukkit, CraftWolf.CraftVariant::bukkitToMinecraftHolder);
        DataComponentAdapters.register(DataComponents.aF, nms -> DyeColor.getByWoolData((byte)((byte)nms.a())), api -> EnumColor.a(api.getWoolData()));
        DataComponentAdapters.register(DataComponents.aE, CraftWolf.CraftSoundVariant::minecraftHolderToBukkit, CraftWolf.CraftSoundVariant::bukkitToMinecraftHolder);
        DataComponentAdapters.register(DataComponents.aG, nms -> Fox.Type.values()[nms.ordinal()], api -> EntityFox.Type.a(api.ordinal()));
        DataComponentAdapters.register(DataComponents.aH, nms -> Salmon.Variant.values()[nms.ordinal()], api -> EntitySalmon.Variant.values()[api.ordinal()]);
        DataComponentAdapters.register(DataComponents.aI, nms -> Parrot.Variant.values()[nms.ordinal()], api -> EntityParrot.Variant.a(api.ordinal()));
        DataComponentAdapters.register(DataComponents.aJ, nms -> TropicalFish.Pattern.values()[nms.ordinal()], api -> EntityTropicalFish.Variant.values()[api.ordinal()]);
        DataComponentAdapters.register(DataComponents.aK, nms -> DyeColor.getByWoolData((byte)((byte)nms.a())), api -> EnumColor.a(api.getWoolData()));
        DataComponentAdapters.register(DataComponents.aL, nms -> DyeColor.getByWoolData((byte)((byte)nms.a())), api -> EnumColor.a(api.getWoolData()));
        DataComponentAdapters.register(DataComponents.aM, nms -> MushroomCow.Variant.values()[nms.ordinal()], api -> EntityMushroomCow.Type.values()[api.ordinal()]);
        DataComponentAdapters.register(DataComponents.aN, nms -> Rabbit.Type.values()[nms.ordinal()], api -> EntityRabbit.Variant.a(api.ordinal()));
        DataComponentAdapters.register(DataComponents.aO, CraftPig.CraftVariant::minecraftHolderToBukkit, CraftPig.CraftVariant::bukkitToMinecraftHolder);
        DataComponentAdapters.register(DataComponents.aP, CraftCow.CraftVariant::minecraftHolderToBukkit, CraftCow.CraftVariant::bukkitToMinecraftHolder);
        DataComponentAdapters.register(DataComponents.aQ, nms -> CraftChicken.CraftVariant.minecraftHolderToBukkit(nms.a(CraftRegistry.getMinecraftRegistry()).orElseThrow()), api -> new EitherHolder<ChickenVariant>(CraftChicken.CraftVariant.bukkitToMinecraftHolder(api)));
        DataComponentAdapters.register(DataComponents.aS, CraftFrog.CraftVariant::minecraftHolderToBukkit, CraftFrog.CraftVariant::bukkitToMinecraftHolder);
        DataComponentAdapters.register(DataComponents.aR, nms -> CraftZombieNautilus.CraftVariant.minecraftHolderToBukkit(nms.a(CraftRegistry.getMinecraftRegistry()).orElseThrow()), api -> new EitherHolder<ZombieNautilusVariant>(CraftZombieNautilus.CraftVariant.bukkitToMinecraftHolder(api)));
        DataComponentAdapters.register(DataComponents.aT, nms -> Horse.Color.values()[nms.ordinal()], api -> HorseColor.a(api.ordinal()));
        DataComponentAdapters.register(DataComponents.aU, CraftArt::minecraftHolderToBukkit, CraftArt::bukkitToMinecraftHolder);
        DataComponentAdapters.register(DataComponents.aV, nms -> Llama.Color.values()[nms.ordinal()], api -> EntityLlama.Variant.a(api.ordinal()));
        DataComponentAdapters.register(DataComponents.aW, nms -> Axolotl.Variant.values()[nms.ordinal()], api -> Axolotl.Variant.a(api.ordinal()));
        DataComponentAdapters.register(DataComponents.aX, CraftCat.CraftType::minecraftHolderToBukkit, CraftCat.CraftType::bukkitToMinecraftHolder);
        DataComponentAdapters.register(DataComponents.aY, nms -> DyeColor.getByWoolData((byte)((byte)nms.a())), api -> EnumColor.a(api.getWoolData()));
        DataComponentAdapters.register(DataComponents.aZ, nms -> DyeColor.getByWoolData((byte)((byte)nms.a())), api -> EnumColor.a(api.getWoolData()));
        DataComponentAdapters.register(DataComponents.ba, nms -> DyeColor.getByWoolData((byte)((byte)nms.a())), api -> EnumColor.a(api.getWoolData()));
        for (ResourceKey<DataComponentType<?>> key : BuiltInRegistries.am.j()) {
            if (ADAPTERS.containsKey(key)) continue;
            DataComponentAdapters.registerUnimplemented(key);
        }
    }

    private static <NMS> ResourceKey<DataComponentType<?>> getKey(DataComponentType<NMS> type) {
        return BuiltInRegistries.am.d(type).orElseThrow();
    }

    public static void registerUntyped(DataComponentType<Unit> type) {
        DataComponentAdapters.registerInternal(DataComponentAdapters.getKey(type), UNIT_TO_API_CONVERTER, DataComponentAdapter.API_TO_UNIT_CONVERTER, false);
    }

    private static <COMMON> void registerIdentity(DataComponentType<COMMON> type) {
        DataComponentAdapters.registerInternal(DataComponentAdapters.getKey(type), Function.identity(), Function.identity(), true);
    }

    public static void registerUnimplemented(ResourceKey<DataComponentType<?>> key) {
        DataComponentAdapters.registerInternal(key, UNIMPLEMENTED_TO_API_CONVERTER, DataComponentAdapter.API_TO_UNIMPLEMENTED_CONVERTER, false);
    }

    private static <NMS, API extends Handleable<NMS>> void register(DataComponentType<NMS> type, Function<NMS, API> vanillaToApi) {
        DataComponentAdapters.registerInternal(DataComponentAdapters.getKey(type), vanillaToApi, Handleable::getHandle, false);
    }

    private static <NMS, API> void register(DataComponentType<NMS> type, Function<NMS, API> vanillaToApi, Function<API, NMS> apiToVanilla) {
        DataComponentAdapters.registerInternal(DataComponentAdapters.getKey(type), vanillaToApi, apiToVanilla, false);
    }

    private static <NMS, API> void registerInternal(ResourceKey<DataComponentType<?>> key, Function<NMS, API> vanillaToApi, Function<API, NMS> apiToVanilla, boolean codecValidation) {
        if (ADAPTERS.containsKey(key)) {
            throw new IllegalStateException("Duplicate adapter registration for " + String.valueOf(key));
        }
        ADAPTERS.put(key, new DataComponentAdapter<NMS, API>(apiToVanilla, vanillaToApi, codecValidation));
    }
}

