/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.datacomponent.item.consumable;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.datacomponent.item.consumable.ConsumableTypesBridge;
import io.papermc.paper.datacomponent.item.consumable.ConsumeEffect;
import io.papermc.paper.datacomponent.item.consumable.PaperApplyStatusEffects;
import io.papermc.paper.datacomponent.item.consumable.PaperClearAllStatusEffects;
import io.papermc.paper.datacomponent.item.consumable.PaperPlaySound;
import io.papermc.paper.datacomponent.item.consumable.PaperRemoveStatusEffects;
import io.papermc.paper.datacomponent.item.consumable.PaperTeleportRandomly;
import io.papermc.paper.registry.data.util.Conversions;
import io.papermc.paper.registry.set.PaperRegistrySets;
import io.papermc.paper.registry.set.RegistryKeySet;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.key.Key;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.consume_effects.ApplyStatusEffectsConsumeEffect;
import net.minecraft.world.item.consume_effects.PlaySoundConsumeEffect;
import net.minecraft.world.item.consume_effects.RemoveStatusEffectsConsumeEffect;
import net.minecraft.world.item.consume_effects.TeleportRandomlyConsumeEffect;
import org.bukkit.craftbukkit.v1_21_R7.potion.CraftPotionUtil;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class ConsumableTypesBridgeImpl
implements ConsumableTypesBridge {
    public ConsumeEffect.ApplyStatusEffects applyStatusEffects(List<PotionEffect> effectList, float probability) {
        Preconditions.checkArgument((0.0f <= probability && probability <= 1.0f ? 1 : 0) != 0, (String)"probability must be between 0-1, was %s", (Object)Float.valueOf(probability));
        return new PaperApplyStatusEffects(new ApplyStatusEffectsConsumeEffect(new ArrayList<MobEffect>(Lists.transform(effectList, CraftPotionUtil::fromBukkit)), probability));
    }

    public ConsumeEffect.RemoveStatusEffects removeStatusEffects(RegistryKeySet<PotionEffectType> effectTypes) {
        return new PaperRemoveStatusEffects(new RemoveStatusEffectsConsumeEffect(PaperRegistrySets.convertToNms(Registries.ae, Conversions.global().lookup(), effectTypes)));
    }

    public ConsumeEffect.ClearAllStatusEffects clearAllStatusEffects() {
        return PaperClearAllStatusEffects.INSTANCE;
    }

    public ConsumeEffect.PlaySound playSoundEffect(Key sound) {
        return new PaperPlaySound(new PlaySoundConsumeEffect(PaperAdventure.resolveSound(sound)));
    }

    public ConsumeEffect.TeleportRandomly teleportRandomlyEffect(float diameter) {
        Preconditions.checkArgument((diameter > 0.0f ? 1 : 0) != 0, (String)"diameter must be positive, was %s", (Object)Float.valueOf(diameter));
        return new PaperTeleportRandomly(new TeleportRandomlyConsumeEffect(diameter));
    }
}

