/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.datapack;

import com.google.common.collect.Collections2;
import io.papermc.paper.datapack.Datapack;
import io.papermc.paper.datapack.DatapackManager;
import io.papermc.paper.datapack.PaperDatapack;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Predicate;
import net.minecraft.server.packs.repository.ResourcePackLoader;
import net.minecraft.server.packs.repository.ResourcePackRepository;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.DefaultQualifier;

@DefaultQualifier(value=NonNull.class)
public class PaperDatapackManager
implements DatapackManager {
    private final ResourcePackRepository repository;

    public PaperDatapackManager(ResourcePackRepository repository) {
        this.repository = repository;
    }

    public void refreshPacks() {
        this.repository.a();
    }

    public @Nullable Datapack getPack(String name) {
        @Nullable ResourcePackLoader pack = this.repository.c(name);
        if (pack == null) {
            return null;
        }
        return new PaperDatapack(pack, this.repository.g().contains(pack));
    }

    public Collection<Datapack> getPacks() {
        Collection<ResourcePackLoader> enabledPacks = this.repository.g();
        return this.transformPacks(this.repository.d(), enabledPacks::contains);
    }

    public Collection<Datapack> getEnabledPacks() {
        return this.transformPacks(this.repository.g(), pack -> true);
    }

    private Collection<Datapack> transformPacks(Collection<ResourcePackLoader> packs, Predicate<ResourcePackLoader> enabled) {
        return Collections.unmodifiableCollection(Collections2.transform(packs, pack -> new PaperDatapack((ResourcePackLoader)pack, enabled.test((ResourcePackLoader)pack))));
    }
}

