/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.entity.activation;

import io.papermc.paper.entity.activation.ActivationType;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.Marker;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.bee.EntityBee;
import net.minecraft.world.entity.animal.equine.EntityLlama;
import net.minecraft.world.entity.animal.sheep.EntitySheep;
import net.minecraft.world.entity.boss.enderdragon.EntityComplexPart;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderCrystal;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.boss.wither.EntityWither;
import net.minecraft.world.entity.item.EntityFallingBlock;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.item.EntityTNTPrimed;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.monster.illager.EntityPillager;
import net.minecraft.world.entity.npc.villager.EntityVillager;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityEnderSignal;
import net.minecraft.world.entity.projectile.EntityFireworks;
import net.minecraft.world.entity.projectile.EntityProjectile;
import net.minecraft.world.entity.projectile.arrow.EntityArrow;
import net.minecraft.world.entity.projectile.arrow.EntityThrownTrident;
import net.minecraft.world.entity.projectile.hurtingprojectile.EntityFireball;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.vehicle.boat.AbstractBoat;
import net.minecraft.world.entity.vehicle.minecart.EntityMinecartAbstract;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.AxisAlignedBB;
import org.spigotmc.SpigotWorldConfig;

public final class ActivationRange {
    static Activity[] VILLAGER_PANIC_IMMUNITIES = new Activity[]{Activity.j, Activity.i, Activity.h, Activity.g};
    static AxisAlignedBB maxBB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private static Set<EntityTypes<?>> ENTITIES_THAT_FLY = Set.of(EntityTypes.ah, EntityTypes.ai, EntityTypes.aX);

    private ActivationRange() {
    }

    private static int checkInactiveWakeup(Entity entity) {
        World world = entity.ao();
        SpigotWorldConfig config = world.spigotConfig;
        long inactiveFor = (long)MinecraftServer.currentTick - entity.activatedTick;
        if (entity.activationType == ActivationType.VILLAGER) {
            if (inactiveFor > (long)config.wakeUpInactiveVillagersEvery && world.wakeupInactiveRemainingVillagers > 0) {
                --world.wakeupInactiveRemainingVillagers;
                return config.wakeUpInactiveVillagersFor;
            }
        } else if (entity.activationType == ActivationType.ANIMAL) {
            if (inactiveFor > (long)config.wakeUpInactiveAnimalsEvery && world.wakeupInactiveRemainingAnimals > 0) {
                --world.wakeupInactiveRemainingAnimals;
                return config.wakeUpInactiveAnimalsFor;
            }
        } else if (entity.activationType == ActivationType.FLYING_MONSTER) {
            if (inactiveFor > (long)config.wakeUpInactiveFlyingEvery && world.wakeupInactiveRemainingFlying > 0) {
                --world.wakeupInactiveRemainingFlying;
                return config.wakeUpInactiveFlyingFor;
            }
        } else if ((entity.activationType == ActivationType.MONSTER || entity.activationType == ActivationType.RAIDER) && inactiveFor > (long)config.wakeUpInactiveMonstersEvery && world.wakeupInactiveRemainingMonsters > 0) {
            --world.wakeupInactiveRemainingMonsters;
            return config.wakeUpInactiveMonstersFor;
        }
        return -1;
    }

    public static boolean initializeEntityActivationState(Entity entity, SpigotWorldConfig config) {
        return entity.activationType == ActivationType.MISC && config.miscActivationRange <= 0 || entity.activationType == ActivationType.RAIDER && config.raiderActivationRange <= 0 || entity.activationType == ActivationType.ANIMAL && config.animalActivationRange <= 0 || entity.activationType == ActivationType.MONSTER && config.monsterActivationRange <= 0 || entity.activationType == ActivationType.VILLAGER && config.villagerActivationRange <= 0 || entity.activationType == ActivationType.WATER && config.waterActivationRange <= 0 || entity.activationType == ActivationType.FLYING_MONSTER && config.flyingMonsterActivationRange <= 0 || entity instanceof EntityEnderSignal || entity instanceof EntityHuman || entity instanceof EntityProjectile || entity instanceof EntityEnderDragon || entity instanceof EntityComplexPart || entity instanceof EntityWither || entity instanceof EntityFireball || entity instanceof EntityLightning || entity instanceof EntityTNTPrimed || entity instanceof EntityFallingBlock || entity instanceof EntityMinecartAbstract || entity instanceof AbstractBoat || entity instanceof EntityEnderCrystal || entity instanceof EntityFireworks || entity instanceof EntityThrownTrident;
    }

    public static void activateEntities(World world) {
        int miscActivationRange = world.spigotConfig.miscActivationRange;
        int raiderActivationRange = world.spigotConfig.raiderActivationRange;
        int animalActivationRange = world.spigotConfig.animalActivationRange;
        int monsterActivationRange = world.spigotConfig.monsterActivationRange;
        int waterActivationRange = world.spigotConfig.waterActivationRange;
        int flyingActivationRange = world.spigotConfig.flyingMonsterActivationRange;
        int villagerActivationRange = world.spigotConfig.villagerActivationRange;
        world.wakeupInactiveRemainingAnimals = Math.min(world.wakeupInactiveRemainingAnimals + 1, world.spigotConfig.wakeUpInactiveAnimals);
        world.wakeupInactiveRemainingVillagers = Math.min(world.wakeupInactiveRemainingVillagers + 1, world.spigotConfig.wakeUpInactiveVillagers);
        world.wakeupInactiveRemainingMonsters = Math.min(world.wakeupInactiveRemainingMonsters + 1, world.spigotConfig.wakeUpInactiveMonsters);
        world.wakeupInactiveRemainingFlying = Math.min(world.wakeupInactiveRemainingFlying + 1, world.spigotConfig.wakeUpInactiveFlying);
        int maxRange = Math.max(monsterActivationRange, animalActivationRange);
        maxRange = Math.max(maxRange, raiderActivationRange);
        maxRange = Math.max(maxRange, miscActivationRange);
        maxRange = Math.max(maxRange, flyingActivationRange);
        maxRange = Math.max(maxRange, waterActivationRange);
        maxRange = Math.max(maxRange, villagerActivationRange);
        maxRange = Math.min((world.spigotConfig.simulationDistance << 4) - 8, maxRange);
        for (EntityHuman entityHuman : world.E()) {
            entityHuman.activatedTick = MinecraftServer.currentTick;
            if (world.spigotConfig.ignoreSpectatorActivation && entityHuman.au()) continue;
            int worldHeight = world.L_();
            maxBB = entityHuman.dj().c(maxRange, worldHeight, maxRange);
            ActivationType.MISC.boundingBox = entityHuman.dj().c(miscActivationRange, worldHeight, miscActivationRange);
            ActivationType.RAIDER.boundingBox = entityHuman.dj().c(raiderActivationRange, worldHeight, raiderActivationRange);
            ActivationType.ANIMAL.boundingBox = entityHuman.dj().c(animalActivationRange, worldHeight, animalActivationRange);
            ActivationType.MONSTER.boundingBox = entityHuman.dj().c(monsterActivationRange, worldHeight, monsterActivationRange);
            ActivationType.WATER.boundingBox = entityHuman.dj().c(waterActivationRange, worldHeight, waterActivationRange);
            ActivationType.FLYING_MONSTER.boundingBox = entityHuman.dj().c(flyingActivationRange, worldHeight, flyingActivationRange);
            ActivationType.VILLAGER.boundingBox = entityHuman.dj().c(villagerActivationRange, worldHeight, villagerActivationRange);
            List<Entity> entities = world.a((Entity)null, maxBB, e2 -> true);
            boolean tickMarkers = world.paperConfig().entities.markers.tick;
            for (Entity entity : entities) {
                if (!tickMarkers && entity instanceof Marker) continue;
                ActivationRange.activateEntity(entity);
            }
        }
    }

    private static void activateEntity(Entity entity) {
        if ((long)MinecraftServer.currentTick > entity.activatedTick) {
            if (entity.defaultActivationState) {
                entity.activatedTick = MinecraftServer.currentTick;
                return;
            }
            if (entity.activationType.boundingBox.c(entity.dj())) {
                entity.activatedTick = MinecraftServer.currentTick;
            }
        }
    }

    public static int checkEntityImmunities(Entity entity) {
        SpigotWorldConfig config = entity.ao().spigotConfig;
        int inactiveWakeUpImmunity = ActivationRange.checkInactiveWakeup(entity);
        if (inactiveWakeUpImmunity > -1) {
            return inactiveWakeUpImmunity;
        }
        if (entity.aS() > 0) {
            return 2;
        }
        if (entity.activatedImmunityTick >= (long)MinecraftServer.currentTick) {
            return 1;
        }
        long inactiveFor = (long)MinecraftServer.currentTick - entity.activatedTick;
        if (entity.activationType != ActivationType.WATER && entity.by() && entity.db()) {
            return 100;
        }
        if (!entity.aV() || entity.dN().j() > (double)1.0E-5f) {
            return 100;
        }
        if (!(entity instanceof EntityArrow)) {
            if (!entity.aV() && !ActivationRange.isEntityThatFlies(entity)) {
                return 10;
            }
        } else {
            EntityArrow arrow = (EntityArrow)entity;
            if (!arrow.f()) {
                return 1;
            }
        }
        if (entity instanceof EntityLiving) {
            EntityCreeper creeper;
            EntityLlama llama;
            EntityInsentient mob;
            EntityLiving living = (EntityLiving)entity;
            if (living.fl() || living.bM || living.bu > 0 || !living.co.isEmpty() || living.eb()) {
                return 1;
            }
            if (entity instanceof EntityInsentient && (mob = (EntityInsentient)entity).ag_() != null) {
                return 20;
            }
            if (entity instanceof EntityBee) {
                EntityBee bee = (EntityBee)entity;
                BlockPosition movingTarget = bee.getMovingTarget();
                if (bee.ab_() || bee.gU() != null && bee.gU().equals(movingTarget) || bee.p() != null && bee.p().equals(movingTarget)) {
                    return 20;
                }
            }
            if (entity instanceof EntityVillager) {
                EntityVillager villager = (EntityVillager)entity;
                BehaviorController<EntityVillager> behaviorController = villager.ev();
                if (config.villagersActiveForPanic) {
                    for (Activity activity : VILLAGER_PANIC_IMMUNITIES) {
                        if (!behaviorController.c(activity)) continue;
                        return 100;
                    }
                }
                if (config.villagersWorkImmunityAfter > 0 && inactiveFor >= (long)config.villagersWorkImmunityAfter && behaviorController.c(Activity.c)) {
                    return config.villagersWorkImmunityFor;
                }
            }
            if (entity instanceof EntityLlama && (llama = (EntityLlama)entity).hi()) {
                return 1;
            }
            if (entity instanceof EntityAnimal) {
                EntitySheep sheep;
                EntityAnimal animal = (EntityAnimal)entity;
                if (animal.e_() || animal.hb()) {
                    return 5;
                }
                if (entity instanceof EntitySheep && (sheep = (EntitySheep)entity).gQ()) {
                    return 1;
                }
            }
            if (entity instanceof EntityCreeper && (creeper = (EntityCreeper)entity).gQ()) {
                return 20;
            }
            if (entity instanceof EntityInsentient) {
                mob = (EntityInsentient)entity;
                if (mob.ct.hasTasks()) {
                    return 0;
                }
            }
            if (entity instanceof EntityPillager) {
                EntityPillager entityPillager = (EntityPillager)entity;
            }
        }
        if (entity instanceof EntityExperienceOrb) {
            return 20;
        }
        return -1;
    }

    public static boolean checkIfActive(Entity entity) {
        EntityInsentient mob;
        if (entity instanceof EntityFireworks || entity instanceof EntityItem && (entity.at + entity.aA()) % 4 == 0) {
            return true;
        }
        if (entity.defaultActivationState || entity.at < 200 || !entity.cb() || entity.aG != null && !entity.aG.b() || entity.bt > 0) {
            return true;
        }
        if (entity instanceof EntityInsentient && (mob = (EntityInsentient)entity).C() instanceof EntityHuman) {
            return true;
        }
        boolean isActive = entity.activatedTick >= (long)MinecraftServer.currentTick;
        entity.isTemporarilyActive = false;
        if (!isActive && ((long)MinecraftServer.currentTick - entity.activatedTick - 1L) % 20L == 0L) {
            int immunity = ActivationRange.checkEntityImmunities(entity);
            if (immunity >= 0) {
                entity.activatedTick = MinecraftServer.currentTick + immunity;
            } else {
                entity.isTemporarilyActive = true;
            }
            isActive = true;
        }
        return isActive;
    }

    private static boolean isEntityThatFlies(Entity entity) {
        return ENTITIES_THAT_FLY.contains(entity.ay());
    }
}

