/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.potion;

import com.google.common.base.Preconditions;
import io.papermc.paper.potion.PotionMix;
import java.util.Collection;
import net.minecraft.server.MinecraftServer;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.potion.PotionBrewer;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionType;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.framework.qual.DefaultQualifier;

@DefaultQualifier(value=NonNull.class)
public class PaperPotionBrewer
implements PotionBrewer {
    private final MinecraftServer minecraftServer;

    public PaperPotionBrewer(MinecraftServer minecraftServer) {
        this.minecraftServer = minecraftServer;
    }

    @Deprecated(forRemoval=true)
    public Collection<PotionEffect> getEffects(PotionType type, boolean upgraded, boolean extended) {
        NamespacedKey key = type.getKey();
        Preconditions.checkArgument((!key.getKey().startsWith("strong_") ? 1 : 0) != 0, (String)"Strong potion type cannot be used directly, got %s", (Object)key);
        Preconditions.checkArgument((!key.getKey().startsWith("long_") ? 1 : 0) != 0, (String)"Extended potion type cannot be used directly, got %s", (Object)key);
        NamespacedKey effectiveKey = key;
        if (upgraded) {
            effectiveKey = new NamespacedKey(key.namespace(), "strong_" + String.valueOf(key.key()));
        } else if (extended) {
            effectiveKey = new NamespacedKey(key.namespace(), "long_" + String.valueOf(key.key()));
        }
        PotionType effectivePotionType = (PotionType)Registry.POTION.get(effectiveKey);
        Preconditions.checkNotNull((Object)type, (Object)("Unknown potion type from data " + effectiveKey.asMinimalString()));
        return effectivePotionType.getPotionEffects();
    }

    public void addPotionMix(PotionMix potionMix) {
        this.minecraftServer.br().addPotionMix(potionMix);
    }

    public void removePotionMix(NamespacedKey key) {
        this.minecraftServer.aI.removePotionMix(key);
    }

    public void resetPotionMixes() {
        this.minecraftServer.aI = this.minecraftServer.br().reload(this.minecraftServer.bb().J());
    }
}

