/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.raytracing;

import com.google.common.base.Preconditions;
import io.papermc.paper.raytracing.BlockCollisionMode;
import io.papermc.paper.raytracing.PositionedRayTraceConfigurationBuilder;
import io.papermc.paper.raytracing.RayTraceTarget;
import java.util.EnumSet;
import java.util.OptionalDouble;
import java.util.function.Predicate;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class PositionedRayTraceConfigurationBuilderImpl
implements PositionedRayTraceConfigurationBuilder {
    public @Nullable Location start;
    public @Nullable Vector direction;
    public OptionalDouble maxDistance = OptionalDouble.empty();
    public FluidCollisionMode fluidCollisionMode = FluidCollisionMode.NEVER;
    public BlockCollisionMode blockCollisionMode = BlockCollisionMode.OUTLINE;
    public double raySize = 0.0;
    public @Nullable Predicate<? super Entity> entityFilter;
    public @Nullable Predicate<? super Block> blockFilter;
    public EnumSet<RayTraceTarget> targets = EnumSet.noneOf(RayTraceTarget.class);

    public PositionedRayTraceConfigurationBuilder start(Location start) {
        Preconditions.checkArgument((start != null ? 1 : 0) != 0, (Object)"start must not be null");
        this.start = start.clone();
        return this;
    }

    public PositionedRayTraceConfigurationBuilder direction(Vector direction) {
        Preconditions.checkArgument((direction != null ? 1 : 0) != 0, (Object)"direction must not be null");
        this.direction = direction.clone();
        return this;
    }

    public PositionedRayTraceConfigurationBuilder maxDistance(double maxDistance) {
        Preconditions.checkArgument((maxDistance >= 0.0 ? 1 : 0) != 0, (Object)"maxDistance must be non-negative");
        this.maxDistance = OptionalDouble.of(maxDistance);
        return this;
    }

    public PositionedRayTraceConfigurationBuilder fluidCollisionMode(FluidCollisionMode fluidCollisionMode) {
        Preconditions.checkArgument((fluidCollisionMode != null ? 1 : 0) != 0, (Object)"fluidCollisionMode must not be null");
        this.fluidCollisionMode = fluidCollisionMode;
        return this;
    }

    public PositionedRayTraceConfigurationBuilder blockCollisionMode(BlockCollisionMode blockCollisionMode) {
        Preconditions.checkArgument((blockCollisionMode != null ? 1 : 0) != 0, (Object)"blockCollisionMode must not be null");
        this.blockCollisionMode = blockCollisionMode;
        return this;
    }

    public PositionedRayTraceConfigurationBuilder ignorePassableBlocks(boolean ignorePassableBlocks) {
        this.blockCollisionMode = ignorePassableBlocks ? BlockCollisionMode.COLLIDER : BlockCollisionMode.OUTLINE;
        return this;
    }

    public PositionedRayTraceConfigurationBuilder raySize(double raySize) {
        Preconditions.checkArgument((raySize >= 0.0 ? 1 : 0) != 0, (Object)"raySize must be non-negative");
        this.raySize = raySize;
        return this;
    }

    public PositionedRayTraceConfigurationBuilder entityFilter(Predicate<? super Entity> entityFilter) {
        Preconditions.checkArgument((entityFilter != null ? 1 : 0) != 0, (Object)"entityFilter must not be null");
        this.entityFilter = entityFilter;
        return this;
    }

    public PositionedRayTraceConfigurationBuilder blockFilter(Predicate<? super Block> blockFilter) {
        Preconditions.checkArgument((blockFilter != null ? 1 : 0) != 0, (Object)"blockFilter must not be null");
        this.blockFilter = blockFilter;
        return this;
    }

    public PositionedRayTraceConfigurationBuilder targets(RayTraceTarget first, RayTraceTarget ... others) {
        Preconditions.checkArgument((first != null ? 1 : 0) != 0, (Object)"first must not be null");
        Preconditions.checkArgument((others != null ? 1 : 0) != 0, (Object)"others must not be null");
        this.targets = EnumSet.of(first, others);
        return this;
    }
}

