/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry.data;

import io.papermc.paper.registry.PaperRegistryBuilder;
import io.papermc.paper.registry.data.ChickenVariantRegistryEntry;
import io.papermc.paper.registry.data.client.ClientTextureAsset;
import io.papermc.paper.registry.data.util.Checks;
import io.papermc.paper.registry.data.util.Conversions;
import net.minecraft.world.entity.animal.chicken.ChickenVariant;
import net.minecraft.world.entity.variant.ModelAndTexture;
import net.minecraft.world.entity.variant.SpawnPrioritySelectors;
import org.bukkit.entity.Chicken;
import org.jspecify.annotations.Nullable;

public class PaperChickenVariantRegistryEntry
implements ChickenVariantRegistryEntry {
    protected @Nullable ChickenVariant.a model;
    protected  @Nullable ClientAsset.b clientTextureAsset;
    protected SpawnPrioritySelectors spawnConditions;
    protected final Conversions conversions;

    public PaperChickenVariantRegistryEntry(Conversions conversions, @Nullable ChickenVariant internal) {
        this.conversions = conversions;
        if (internal == null) {
            this.spawnConditions = SpawnPrioritySelectors.a;
            return;
        }
        this.clientTextureAsset = internal.b().b();
        this.model = internal.b().a();
        this.spawnConditions = internal.c();
    }

    public ClientTextureAsset clientTextureAsset() {
        return this.conversions.asBukkit(Checks.asConfigured(this.clientTextureAsset, "clientTextureAsset"));
    }

    public ChickenVariantRegistryEntry.Model model() {
        return switch (Checks.asConfigured(this.model, "model")) {
            default -> throw new MatchException(null, null);
            case ChickenVariant.a.a -> ChickenVariantRegistryEntry.Model.NORMAL;
            case ChickenVariant.a.b -> ChickenVariantRegistryEntry.Model.COLD;
        };
    }

    public static final class PaperBuilder
    extends PaperChickenVariantRegistryEntry
    implements ChickenVariantRegistryEntry.Builder,
    PaperRegistryBuilder<ChickenVariant, Chicken.Variant> {
        public PaperBuilder(Conversions conversions, @Nullable ChickenVariant internal) {
            super(conversions, internal);
        }

        public ChickenVariantRegistryEntry.Builder clientTextureAsset(ClientTextureAsset clientTextureAsset) {
            this.clientTextureAsset = this.conversions.asVanilla(Checks.asArgument(clientTextureAsset, "clientTextureAsset"));
            return this;
        }

        public ChickenVariantRegistryEntry.Builder model(ChickenVariantRegistryEntry.Model model) {
            this.model = switch (Checks.asArgument(model, "model")) {
                default -> throw new MatchException(null, null);
                case ChickenVariantRegistryEntry.Model.NORMAL -> ChickenVariant.a.a;
                case ChickenVariantRegistryEntry.Model.COLD -> ChickenVariant.a.b;
            };
            return this;
        }

        @Override
        public ChickenVariant build() {
            return new ChickenVariant(new ModelAndTexture<ChickenVariant.a>(Checks.asConfigured(this.model, "model"), Checks.asConfigured(this.clientTextureAsset, "clientTextureAsset")), Checks.asConfigured(this.spawnConditions, "spawnConditions"));
        }
    }
}

