/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry.data;

import io.papermc.paper.registry.PaperRegistryBuilder;
import io.papermc.paper.registry.data.CowVariantRegistryEntry;
import io.papermc.paper.registry.data.client.ClientTextureAsset;
import io.papermc.paper.registry.data.util.Checks;
import io.papermc.paper.registry.data.util.Conversions;
import net.minecraft.world.entity.animal.cow.CowVariant;
import net.minecraft.world.entity.variant.ModelAndTexture;
import net.minecraft.world.entity.variant.SpawnPrioritySelectors;
import org.bukkit.entity.Cow;
import org.jspecify.annotations.Nullable;

public class PaperCowVariantRegistryEntry
implements CowVariantRegistryEntry {
    protected @Nullable CowVariant.a model = null;
    protected  @Nullable ClientAsset.b clientTextureAsset = null;
    protected SpawnPrioritySelectors spawnConditions;
    protected final Conversions conversions;

    public PaperCowVariantRegistryEntry(Conversions conversions, @Nullable CowVariant internal) {
        this.conversions = conversions;
        if (internal == null) {
            this.spawnConditions = SpawnPrioritySelectors.a;
            return;
        }
        this.clientTextureAsset = internal.b().b();
        this.model = internal.b().a();
        this.spawnConditions = internal.c();
    }

    public ClientTextureAsset clientTextureAsset() {
        return this.conversions.asBukkit(Checks.asConfigured(this.clientTextureAsset, "clientTextureAsset"));
    }

    public CowVariantRegistryEntry.Model model() {
        return switch (Checks.asConfigured(this.model, "model")) {
            default -> throw new MatchException(null, null);
            case CowVariant.a.a -> CowVariantRegistryEntry.Model.NORMAL;
            case CowVariant.a.b -> CowVariantRegistryEntry.Model.COLD;
            case CowVariant.a.c -> CowVariantRegistryEntry.Model.WARM;
        };
    }

    public static final class PaperBuilder
    extends PaperCowVariantRegistryEntry
    implements CowVariantRegistryEntry.Builder,
    PaperRegistryBuilder<CowVariant, Cow.Variant> {
        public PaperBuilder(Conversions conversions, @Nullable CowVariant internal) {
            super(conversions, internal);
        }

        public CowVariantRegistryEntry.Builder clientTextureAsset(ClientTextureAsset clientTextureAsset) {
            this.clientTextureAsset = this.conversions.asVanilla(Checks.asArgument(clientTextureAsset, "clientTextureAsset"));
            return this;
        }

        public CowVariantRegistryEntry.Builder model(CowVariantRegistryEntry.Model model) {
            this.model = switch (Checks.asArgument(model, "model")) {
                default -> throw new MatchException(null, null);
                case CowVariantRegistryEntry.Model.NORMAL -> CowVariant.a.a;
                case CowVariantRegistryEntry.Model.COLD -> CowVariant.a.b;
                case CowVariantRegistryEntry.Model.WARM -> CowVariant.a.c;
            };
            return this;
        }

        @Override
        public CowVariant build() {
            return new CowVariant(new ModelAndTexture<CowVariant.a>(Checks.asConfigured(this.model, "model"), Checks.asConfigured(this.clientTextureAsset, "clientTextureAsset")), this.spawnConditions);
        }
    }
}

