/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry.data;

import io.papermc.paper.registry.PaperRegistries;
import io.papermc.paper.registry.PaperRegistryBuilder;
import io.papermc.paper.registry.RegistryBuilderFactory;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.TypedKey;
import io.papermc.paper.registry.data.InstrumentRegistryEntry;
import io.papermc.paper.registry.data.PaperSoundEventRegistryEntry;
import io.papermc.paper.registry.data.SoundEventRegistryEntry;
import io.papermc.paper.registry.data.util.Checks;
import io.papermc.paper.registry.data.util.Conversions;
import io.papermc.paper.registry.holder.PaperRegistryHolders;
import io.papermc.paper.registry.holder.RegistryHolder;
import java.util.function.Consumer;
import net.kyori.adventure.text.Component;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.world.item.Instrument;
import org.bukkit.MusicInstrument;
import org.bukkit.Sound;
import org.checkerframework.checker.index.qual.Positive;
import org.jspecify.annotations.Nullable;

public class PaperInstrumentRegistryEntry
implements InstrumentRegistryEntry {
    protected final Conversions conversions;
    protected @Nullable Holder<SoundEffect> soundEvent;
    protected @Nullable Float useDuration;
    protected @Nullable Float range;
    protected @Nullable IChatBaseComponent description;

    public PaperInstrumentRegistryEntry(Conversions conversions, @Nullable Instrument internal) {
        this.conversions = conversions;
        if (internal == null) {
            return;
        }
        this.soundEvent = internal.a();
        this.useDuration = Float.valueOf(internal.b());
        this.range = Float.valueOf(internal.c());
        this.description = internal.d();
    }

    public RegistryHolder<Sound, SoundEventRegistryEntry> soundEvent() {
        Holder<SoundEffect> current = Checks.asConfigured(this.soundEvent, "soundEvent");
        return PaperRegistryHolders.create(current, e2 -> new PaperSoundEventRegistryEntry(this.conversions, (SoundEffect)e2));
    }

    public @Positive float duration() {
        return Checks.asConfigured(this.useDuration, "useDuration").floatValue();
    }

    public @Positive float range() {
        return Checks.asConfigured(this.range, "range").floatValue();
    }

    public Component description() {
        return this.conversions.asAdventure(Checks.asConfigured(this.description, "description"));
    }

    public static final class PaperBuilder
    extends PaperInstrumentRegistryEntry
    implements InstrumentRegistryEntry.Builder,
    PaperRegistryBuilder<Instrument, MusicInstrument> {
        public PaperBuilder(Conversions conversions, @Nullable Instrument internal) {
            super(conversions, internal);
        }

        public InstrumentRegistryEntry.Builder soundEvent(TypedKey<Sound> soundEvent) {
            this.soundEvent = this.conversions.getReferenceHolder(PaperRegistries.toNms(Checks.asArgument(soundEvent, "soundEvent")));
            return this;
        }

        public InstrumentRegistryEntry.Builder soundEvent(Consumer<RegistryBuilderFactory<Sound, ? extends SoundEventRegistryEntry.Builder>> soundEvent) {
            this.soundEvent = this.conversions.createHolderFromBuilder(RegistryKey.SOUND_EVENT, Checks.asArgument(soundEvent, "soundEvent"));
            return this;
        }

        public InstrumentRegistryEntry.Builder soundEvent(RegistryHolder<Sound, SoundEventRegistryEntry> soundEvent) {
            this.soundEvent = PaperRegistryHolders.convert(soundEvent, this.conversions);
            return this;
        }

        public InstrumentRegistryEntry.Builder duration(@Positive float duration) {
            this.useDuration = Float.valueOf(Checks.asArgumentMinExclusive(duration, "useDuration", 0.0f));
            return this;
        }

        public InstrumentRegistryEntry.Builder range(@Positive float range) {
            this.range = Float.valueOf(Checks.asArgumentMinExclusive(range, "range", 0.0f));
            return this;
        }

        public InstrumentRegistryEntry.Builder description(Component description) {
            this.description = this.conversions.asVanilla(Checks.asArgument(description, "description"));
            return this;
        }

        @Override
        public Instrument build() {
            return new Instrument(Checks.asConfigured(this.soundEvent, "soundEvent"), this.duration(), this.range(), Checks.asConfigured(this.description, "description"));
        }
    }
}

